/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.fulltextindexportlet.gwt.server;

import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import java.io.StringReader;
import java.net.URI;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.security.PortalSecurityManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.types.VOID;
import org.gcube.index.fulltextindexnode.stubs.CreateResource;
import org.gcube.index.fulltextindexnode.stubs.CreateResourceResponse;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodeFactoryPortType;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodePortType;
import org.gcube.index.fulltextindexnode.stubs.GetIndexInformationResponse;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeFactoryServiceAddressingLocator;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeServiceAddressingLocator;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.server.util.GenericResourceManager;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.CollectionBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.FieldBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.FullTextIndexTypeBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.IndexBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.IndexTypeBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.MgmtPropertiesBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.RunningInstanceBean;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ManagementServiceImpl
extends RemoteServiceServlet
implements ManagementService {
    private static final long serialVersionUID = 2262958144498861061L;
    private static final long RSTIMEOUT = 10L;
    private static final int NORESULTS = 25;
    private static Logger logger = Logger.getLogger(ManagementServiceImpl.class);
    private Map<String, GCUBEGenericResource> indexTypeResources;

    public ManagementServiceImpl() {
        try {
            ResourceRegistry.startBridging();
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Error initialising servlet");
        }
    }

    private static List<EndpointReferenceType> getWSResourceEPRsFromPropValuesAndNamespace(List<String[]> properties, String namespace, GCUBEScope scope) throws Exception {
        String filter = "$result/child::*[local-name()='" + properties.get(0)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(0)[1].trim() + "'";
        int i = 1;
        while (i < properties.size()) {
            filter = String.valueOf(filter) + " and $result/child::*[local-name()='" + properties.get(i)[0].trim() + "' and namespace-uri(.)='" + namespace.trim() + "']/string() eq '" + properties.get(i)[1].trim() + "'";
            ++i;
        }
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        WSResourceQuery gquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
        gquery.addGenericCondition(filter);
        logger.debug((Object)("query!! --> " + gquery.getExpression()));
        LinkedList<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
        for (RPDocument d : client.execute((ISQuery)gquery, scope)) {
            ret.add(d.getEndpoint());
        }
        return ret;
    }

    private GCUBEScope getScope() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session.getScope();
    }

    private String getScopeName() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session.getScopeName();
    }

    private <PORTTYPE extends Remote> PORTTYPE getStubProxy(PORTTYPE portTypeStub) throws Exception {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        PortalSecurityManager secManager = new PortalSecurityManager(session.getScope());
        if (secManager.isSecurityEnabled()) {
            try {
                secManager.useCredentials((GSSCredential)session.getCredential());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return (PORTTYPE)GCUBERemotePortTypeContext.getProxy(portTypeStub, (GCUBEScope)session.getScope(), (GCUBESecurityManager[])new GCUBESecurityManager[]{secManager});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<RunningInstanceBean> getRunningInstances() throws Exception {
        LinkedList<RunningInstanceBean> factoryEPRs = new LinkedList<RunningInstanceBean>();
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery gquery = client.getQuery("RIEndpoint");
        gquery.addParameters(new QueryParameter[]{new QueryParameter("NAME", "FullTextIndexNode"), new QueryParameter("CLASS", "Index"), new QueryParameter("ENTRY", "gcube/index/FullTextIndexNodeFactory")});
        logger.debug((Object)"Quering for fulltextindexnodefactory RIs...");
        logger.debug((Object)gquery.getExpression());
        List eprs = client.execute((ISQuery)gquery, this.getScope());
        if (eprs == null || eprs.size() == 0) {
            throw new Exception("Unable to find any FullTextIndexNodeFactory service instances.");
        }
        for (XMLResult r : eprs) {
            for (String r1 : r.evaluate("//Endpoint/text()")) {
                RunningInstanceBean ribean = new RunningInstanceBean();
                ribean.setRunningInstanceEPR(r1);
                factoryEPRs.add(ribean);
            }
        }
        return factoryEPRs;
    }

    public List<String> query(String queryString, String indexID) throws Exception {
        logger.debug((Object)"-------->   query");
        try {
            LinkedList<String[]> props = new LinkedList<String[]>();
            String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
            props.add(new String[]{"IndexID", indexID});
            List lookupInstanceEPRs = ManagementServiceImpl.getWSResourceEPRsFromPropValuesAndNamespace(props, (String)namespace, (GCUBEScope)this.getScope());
            if (lookupInstanceEPRs.size() == 0) {
                throw new Exception("The lookup with the id [" + indexID + "] was not found on the IS");
            }
            FullTextIndexNodePortType lookupInstance = null;
            FullTextIndexNodeServiceAddressingLocator lookupInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
            lookupInstance = lookupInstanceLocator.getFullTextIndexNodePortTypePort((EndpointReferenceType)lookupInstanceEPRs.get(0));
            lookupInstance = (FullTextIndexNodePortType)this.getStubProxy((Remote)lookupInstance);
            String rsEPR = lookupInstance.query(queryString);
            logger.info((Object)("FT index Query RSepr -> " + rsEPR));
            return this.getListFromRS(rsEPR);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public List<CollectionBean> getCollections() throws Exception {
        logger.debug((Object)("-------->  getCollections() in " + this.getScope().toString()));
        HashMap<String, CollectionBean> beanFromIDMap = new HashMap<String, CollectionBean>();
        try {
            logger.debug((Object)("SCOPE " + this.getScope().getName() + " ( " + this.getScopeName() + ")"));
            List collections = DataCollection.getCollectionsOfScope((boolean)true, (String)this.getScopeName());
            logger.debug((Object)("Size of collections is " + collections.size()));
            for (DataCollection c : collections) {
                String colID = c.getID();
                String colName = c.getName();
                logger.debug((Object)("Added collection -> " + colName + " (" + colID + ") to nameFromIDMap"));
                CollectionBean collection = new CollectionBean();
                collection.setId(colID);
                collection.setName(colName);
                collection.setIsReal(true);
                beanFromIDMap.put(colID, collection);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error((Object)"Failed to retrieve the content collections");
        }
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        CollectionBean fakeCollections = new CollectionBean();
        fakeCollections.setName("Empty Managers");
        List indexData = new ArrayList();
        try {
            WSResourceQuery wsquery = (WSResourceQuery)client.getQuery(WSResourceQuery.class);
            wsquery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//gc:ServiceName", "FullTextIndexNode")});
            indexData = client.execute((ISQuery)wsquery, this.getScope());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.debug((Object)"Failed to execute the WS resource query");
        }
        String idxID = null;
        for (RPDocument d : indexData) {
            List indexCollectionIDs;
            logger.debug((Object)("RPD Data -> " + d.toString()));
            if (d.evaluate("//IndexID/text()") != null) {
                idxID = (String)d.evaluate("//IndexID/text()").get(0);
                logger.debug((Object)("idxID ***** ---> " + idxID));
            }
            if ((indexCollectionIDs = d.evaluate("//CollectionID/text()")) == null || indexCollectionIDs.isEmpty()) {
                IndexBean idx = new IndexBean();
                idx.setId(idxID);
                fakeCollections.addIndex(idx);
                continue;
            }
            for (String idxColID : indexCollectionIDs) {
                logger.debug((Object)("Fond index resource for collection -> " + idxColID + " Going to check if it is real"));
                CollectionBean collection = (CollectionBean)beanFromIDMap.get(idxColID);
                if (collection == null) {
                    logger.debug((Object)("Found fake index with CollectionID=" + idxColID));
                    continue;
                }
                logger.debug((Object)("Found index for CollectionID=" + idxColID));
                if (idxID == null) continue;
                IndexBean idx = new IndexBean();
                idx.setId(idxID);
                collection.addIndex(idx);
            }
        }
        ArrayList<CollectionBean> returnList = new ArrayList<CollectionBean>();
        returnList.addAll(beanFromIDMap.values());
        Collections.sort(returnList);
        returnList.add(fakeCollections);
        int i = 0;
        while (i < returnList.size()) {
            ((CollectionBean)returnList.get(i)).sort();
            ++i;
        }
        System.out.println("getCollections() -------->");
        return returnList;
    }

    public IndexBean[] getIndices(String collectionID) throws Exception {
        LinkedList<String[]> props = new LinkedList<String[]>();
        String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
        props.add(new String[]{"CollectionID", collectionID});
        List eprs = ManagementServiceImpl.getWSResourceEPRsFromPropValuesAndNamespace(props, (String)namespace, (GCUBEScope)this.getScope());
        String indexID = "";
        FullTextIndexNodePortType managementInstance = null;
        FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
        IndexBean[] returnArray = new IndexBean[eprs.size()];
        int i = 0;
        while (i < eprs.size()) {
            try {
                managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort((EndpointReferenceType)eprs.get(i));
                managementInstance = (FullTextIndexNodePortType)this.getStubProxy((Remote)managementInstance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GetResourcePropertyResponse valueRP = managementInstance.getResourceProperty(new QName(namespace, "IndexID"));
            indexID = valueRP.get_any()[0].getValue();
            QName resourceReference = new QName(namespace, "FullTextIndexNodeResourceReference");
            String epr = ObjectSerializer.toString(eprs.get(i), (QName)resourceReference);
            IndexBean indexBean = new IndexBean();
            indexBean.setId(indexID);
            indexBean.setName(String.valueOf(indexID) + "_name");
            indexBean.setHost(((EndpointReferenceType)eprs.get(i)).getAddress().getHost());
            indexBean.setEpr(epr);
            returnArray[i] = indexBean;
            ++i;
        }
        return returnArray;
    }

    public List<FullTextIndexTypeBean> getAvailableIndexTypeIDs() throws Exception {
        String condition = "contains($result/Profile/Name/string(), 'IndexType_ft')";
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
        query.addParameters(new QueryParameter[]{new QueryParameter("FILTER", condition), new QueryParameter("TYPE", "GenericResource"), new QueryParameter("RESULT", "<Result>{$result/Profile/Name}</Result>")});
        List result = client.execute((ISQuery)query, this.getScope());
        LinkedList<FullTextIndexTypeBean> ret = new LinkedList<FullTextIndexTypeBean>();
        for (XMLResult r : result) {
            String indexTypeID = (String)r.evaluate("//Name/text()").get(0);
            indexTypeID = indexTypeID.substring("IndexType_".length());
            FullTextIndexTypeBean ibean = new FullTextIndexTypeBean();
            ibean.setIndexTypeID(indexTypeID);
            ret.add(ibean);
        }
        return ret;
    }

    public String getIndexTypeID(String indexID) throws Exception {
        logger.debug((Object)"-------->   getIndexTypeID");
        try {
            LinkedList<String[]> props = new LinkedList<String[]>();
            String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
            props.add(new String[]{"IndexID", indexID});
            List eprs = ManagementServiceImpl.getWSResourceEPRsFromPropValuesAndNamespace(props, (String)namespace, (GCUBEScope)this.getScope());
            if (eprs.size() == 0) {
                throw new Exception("The index with the id [" + indexID + "] was not found in IS");
            }
            FullTextIndexNodePortType managementInstance = null;
            FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
            managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort((EndpointReferenceType)eprs.get(0));
            managementInstance = (FullTextIndexNodePortType)this.getStubProxy((Remote)managementInstance);
            GetIndexInformationResponse indexInfo = managementInstance.getIndexInformation(new VOID());
            String idxType = indexInfo.getIndexID();
            logger.debug((Object)"getIndexTypeID -------->");
            return idxType;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public MgmtPropertiesBean getResourceProperties(String indexID) throws Exception {
        logger.debug((Object)"-------->   getResourceProperties");
        try {
            LinkedList<String[]> props = new LinkedList<String[]>();
            String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
            props.add(new String[]{"IndexID", indexID});
            List eprs = ManagementServiceImpl.getWSResourceEPRsFromPropValuesAndNamespace(props, (String)namespace, (GCUBEScope)this.getScope());
            if (eprs.size() == 0) {
                throw new Exception("The index with the id [" + indexID + "] was not found in IS");
            }
            FullTextIndexNodePortType managementInstance = null;
            FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
            managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort((EndpointReferenceType)eprs.get(0));
            managementInstance = (FullTextIndexNodePortType)this.getStubProxy((Remote)managementInstance);
            QName RP_CREATED = new QName(namespace, "Created");
            QName RP_MODIFIED = new QName(namespace, "Modified");
            QName RP_CLUSTERID = new QName(namespace, "ClusterID");
            QName[] qNames = new QName[]{RP_CREATED, RP_MODIFIED, RP_CLUSTERID};
            GetMultipleResourcePropertiesResponse multipleRP = managementInstance.getMultipleResourceProperties(new GetMultipleResourceProperties_Element(qNames));
            MgmtPropertiesBean properties = new MgmtPropertiesBean();
            properties.setCreated(multipleRP.get_any()[0].getValue());
            properties.setModified(multipleRP.get_any()[1].getValue());
            properties.setClusterID(multipleRP.get_any()[2].getValue());
            properties.setHost(String.valueOf(((EndpointReferenceType)eprs.get(0)).getAddress().getHost()) + ":" + ((EndpointReferenceType)eprs.get(0)).getAddress().getPort());
            logger.debug((Object)"getResourceProperties -------->");
            return properties;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String createIndex(String clusterID, String collectionID, String RIEPR) throws Exception {
        CreateResource mgmtCreateArguments = new CreateResource();
        if (clusterID != null && !clusterID.trim().equals("")) {
            mgmtCreateArguments.setClusterID(clusterID);
        }
        try {
            Address factoryAddress = new Address(RIEPR);
            logger.debug((Object)("Trying LookupFactory on host: " + factoryAddress.getHost() + ", port: " + factoryAddress.getPort()));
            EndpointReferenceType mgmtFactoryEPR = new EndpointReferenceType();
            mgmtFactoryEPR.setAddress((AttributedURI)factoryAddress);
            FullTextIndexNodeFactoryServiceAddressingLocator mgmtFactoryLocator = new FullTextIndexNodeFactoryServiceAddressingLocator();
            FullTextIndexNodeFactoryPortType mgmtFactory = mgmtFactoryLocator.getFullTextIndexNodeFactoryPortTypePort(mgmtFactoryEPR);
            mgmtFactory = (FullTextIndexNodeFactoryPortType)this.getStubProxy((Remote)mgmtFactory);
            CreateResourceResponse mgmtCreateResponse = mgmtFactory.createResource(mgmtCreateArguments);
            String returnedIndexID = mgmtCreateResponse.getIndexID();
            logger.debug((Object)("Created a new index node resource with indexID --> " + returnedIndexID));
            return returnedIndexID;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Boolean removeIndex(String indexID) throws Exception {
        logger.debug((Object)("Destroying all FullTextIndexManagement resources with the ID: " + indexID));
        LinkedList<String[]> props = new LinkedList<String[]>();
        String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
        props.add(new String[]{"IndexID", indexID});
        List managementInstanceEPRs = ManagementServiceImpl.getWSResourceEPRsFromPropValuesAndNamespace(props, (String)namespace, (GCUBEScope)this.getScope());
        FullTextIndexNodePortType managementInstance = null;
        FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
        EndpointReferenceType managementEPR = (EndpointReferenceType)managementInstanceEPRs.get(0);
        try {
            logger.debug((Object)("Handling managementEPR: " + managementEPR));
            managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort(managementEPR);
            managementInstance = (FullTextIndexNodePortType)this.getStubProxy((Remote)managementInstance);
            logger.debug((Object)"Resource has been removed");
            return managementInstance.destroyNode(new VOID());
        }
        catch (Exception e) {
            logger.debug((Object)("Problem deleting " + indexID + " FullTextIndexManagement resource."));
            return false;
        }
    }

    public Map<String, IndexTypeBean> getAllIndexTypes() throws Exception {
        LinkedList<String[]> conditions = new LinkedList<String[]>();
        conditions.add(new String[]{"//SecondaryType", "FullTextIndexType"});
        HashMap<String, IndexTypeBean> retMap = new HashMap<String, IndexTypeBean>();
        this.indexTypeResources = new HashMap();
        for (GCUBEGenericResource gr : GenericResourceManager.retrieveGenericResource(conditions, (GCUBEScope)this.getScope())) {
            this.indexTypeResources.put(gr.getID(), gr);
            retMap.put(gr.getID(), this.parseIndexType(gr));
        }
        return retMap;
    }

    public String saveIndexType(IndexTypeBean idxType) throws Exception {
        String resourceID = idxType.getResourceID();
        GCUBEGenericResource gr = null;
        if (resourceID == null) {
            gr = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
            gr.setSecondaryType("FullTextIndexType");
            gr.setID("");
        } else {
            gr = (GCUBEGenericResource)this.indexTypeResources.get(resourceID);
        }
        gr.setName(idxType.getIndexTypeName());
        gr.setDescription(idxType.getIndexTypeDesc());
        gr.setBody(this.createIndexType(idxType.getIndexTypeFields()));
        resourceID = GenericResourceManager.updateGenericResource((GCUBEGenericResource)gr, (GCUBEScope)this.getScope());
        gr.setID(resourceID);
        this.indexTypeResources.put(resourceID, gr);
        return resourceID;
    }

    private IndexTypeBean parseIndexType(GCUBEGenericResource idxTypeResource) throws Exception {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbFactory.newDocumentBuilder();
            Document idxTypeDoc = builder.parse(new InputSource(new StringReader(idxTypeResource.getBody())));
            XPath xpath = XPathFactory.newInstance().newXPath();
            Element elFieldList = (Element)xpath.evaluate("//field-list", idxTypeDoc.getDocumentElement(), XPathConstants.NODE);
            LinkedList<FieldBean> returnList = new LinkedList<FieldBean>();
            NodeList fieldList = elFieldList.getElementsByTagName("field");
            int fieldListLength = fieldList.getLength();
            int i = 0;
            while (i < fieldListLength) {
                FieldBean fieldBean = new FieldBean();
                Node field = fieldList.item(i);
                NodeList fieldProperties = field.getChildNodes();
                String fieldName = field.getAttributes().getNamedItem("name").getNodeValue();
                fieldBean.setName(fieldName);
                int propCount = fieldProperties.getLength();
                int j = 0;
                while (j < propCount) {
                    String propName = null;
                    try {
                        Node property = fieldProperties.item(j);
                        if (property.getNodeType() == 1) {
                            Node textNode = property.getFirstChild();
                            propName = property.getNodeName();
                            if (propName.equalsIgnoreCase("index")) {
                                fieldBean.setIndex("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            } else if (propName.equalsIgnoreCase("store")) {
                                fieldBean.setStore("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            } else if (propName.equalsIgnoreCase("return")) {
                                fieldBean.setReturned("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            } else if (propName.equalsIgnoreCase("tokenize")) {
                                fieldBean.setTokenize("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            } else if (propName.equalsIgnoreCase("sort")) {
                                fieldBean.setSort("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
                            } else if (propName.equalsIgnoreCase("boost")) {
                                fieldBean.setBoost(textNode.getNodeValue());
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ++j;
                }
                returnList.add(fieldBean);
                ++i;
            }
            IndexTypeBean itb = new IndexTypeBean();
            itb.setIndexTypeName(idxTypeResource.getName());
            itb.setIndexTypeDesc(idxTypeResource.getDescription());
            itb.setResourceID(idxTypeResource.getID());
            FieldBean[] fields = new FieldBean[returnList.size()];
            int i2 = 0;
            while (i2 < returnList.size()) {
                fields[i2] = (FieldBean)returnList.get(i2);
                ++i2;
            }
            itb.setIndexTypeFields(fields);
            return itb;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to parse indexType from generic resource with name: " + idxTypeResource.getName()), (Throwable)e);
            throw new Exception("Failed to parse indexType from generic resource with name: " + idxTypeResource.getName(), e);
        }
    }

    private String createIndexType(FieldBean[] fields) {
        StringBuilder indexType = new StringBuilder();
        indexType.append("<index-type name=\"default\"><field-list sort-xnear-stop-word-threshold=\"2E8\">");
        int i = 0;
        while (i < fields.length) {
            FieldBean field = fields[i];
            indexType.append("<field name=\"" + field.getName() + "\">");
            indexType.append("<index>" + (field.getIndex() ? "yes" : "no") + "</index>");
            indexType.append("<store>" + (field.getStore() ? "yes" : "no") + "</store>");
            indexType.append("<return>" + (field.getReturned() ? "yes" : "no") + "</return>");
            indexType.append("<tokenize>" + (field.getTokenize() ? "yes" : "no") + "</tokenize>");
            indexType.append("<sort>no</sort>");
            indexType.append("<boost>" + field.getBoost() + "</boost>");
            indexType.append("</field>");
            ++i;
        }
        indexType.append("</field-list></index-type>");
        return indexType.toString();
    }

    public void deleteIndexType(IndexTypeBean idxType) throws Exception {
        String resourceID = idxType.getResourceID();
        GenericResourceManager.deleteGenericResource((String)resourceID, (GCUBEScope)this.getScope());
        this.indexTypeResources.remove(resourceID);
    }

    private List<String> getListFromRS(String epr) throws Exception {
        ForwardReader reader = new ForwardReader(new URI(epr));
        Record result = null;
        ArrayList<String> returnList = new ArrayList<String>();
        int i = 0;
        while (i < 25) {
            Field[] fields;
            int counter = 0;
            int maxFail = 5;
            while (true) {
                try {
                    result = reader.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    if (counter++ <= maxFail) {
                        logger.error((Object)("getListFromRS failed for the " + counter + ". time."), (Throwable)e);
                        continue;
                    }
                    logger.error((Object)" getListFromRS giving up. FAILED!", (Throwable)e);
                    throw e;
                }
                break;
            }
            if (result == null && (reader.getStatus() == IBuffer.Status.Dispose || reader.getStatus() == IBuffer.Status.Close && reader.availableRecords() == 0)) break;
            if (result == null) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("<record>");
            Field[] fieldArray = fields = result.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                String fieldName = f.getFieldDefinition().getName();
                String fieldContent = ((StringField)f).getPayload();
                builder.append("<" + fieldName + ">" + fieldContent + "</" + fieldName + ">");
                ++n2;
            }
            builder.append("</record>");
            returnList.add(builder.toString());
            ++i;
        }
        try {
            reader.close();
        }
        catch (Exception e) {
            logger.warn((Object)"could not close reader: ", (Throwable)e);
        }
        System.out.println("query    --------> ");
        return returnList;
    }

    public String updateIndex(String indexID, String rsLocator) throws InvocationException {
        try {
            HttpSession httpSession = this.getThreadLocalRequest().getSession();
            String username = httpSession.getAttribute("username").toString();
            ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
            GCUBEScope scope = session.getScope();
            CreateResourceResponse updaterCreateResponse = null;
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            LinkedList<String> factoryEPRs = new LinkedList<String>();
            GCUBEGenericQuery gquery = client.getQuery("RIEndpoint");
            gquery.addParameters(new QueryParameter[]{new QueryParameter("NAME", "FullTextIndexNode"), new QueryParameter("CLASS", "Index"), new QueryParameter("ENTRY", "gcube/index/FullTextIndexNodeFactory")});
            List eprs = client.execute((ISQuery)gquery, scope);
            for (XMLResult r : eprs) {
                for (String r1 : r.evaluate("//Endpoint/text()")) {
                    factoryEPRs.add(r1);
                }
            }
            if (factoryEPRs.size() == 0) {
                Exception ie = new Exception("Unable to find a FullTextIndexBatchUpdaterFactoryService in the VO.");
                ie.printStackTrace();
                throw ie;
            }
            int i = 0;
            while (true) {
                try {
                    Address factoryAddress = new Address((String)factoryEPRs.get(i));
                    System.out.println("Trying UpdaterFactory on host: " + factoryAddress.getHost() + ", port: " + factoryAddress.getPort());
                    EndpointReferenceType updaterFactoryEPR = new EndpointReferenceType();
                    updaterFactoryEPR.setAddress((AttributedURI)factoryAddress);
                    FullTextIndexNodeFactoryServiceAddressingLocator updaterFactoryLocator = new FullTextIndexNodeFactoryServiceAddressingLocator();
                    FullTextIndexNodeFactoryPortType updaterFactory = updaterFactoryLocator.getFullTextIndexNodeFactoryPortTypePort(updaterFactoryEPR);
                    updaterFactory = (FullTextIndexNodeFactoryPortType)this.getStubProxy((Remote)updaterFactory);
                    CreateResource updaterCreateArguments = new CreateResource();
                    updaterCreateArguments.setIndexID(indexID);
                    updaterCreateResponse = updaterFactory.createResource(updaterCreateArguments);
                }
                catch (Exception e) {
                    if (++i == factoryEPRs.size()) {
                        throw e;
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            EndpointReferenceType updaterInstanceEPR = updaterCreateResponse.getEndpointReference();
            FullTextIndexNodeServiceAddressingLocator updaterInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
            FullTextIndexNodePortType updaterInstance = updaterInstanceLocator.getFullTextIndexNodePortTypePort(updaterInstanceEPR);
            updaterInstance = (FullTextIndexNodePortType)this.getStubProxy((Remote)updaterInstance);
            updaterInstance.feedLocator(rsLocator);
            QName resourceReference = new QName("http://gcube-system.org/namespaces/index/FullTextIndexNode/service", "FullTextIndexNodeResourceReference");
            String endpointString = ObjectSerializer.toString((Object)updaterInstanceEPR, (QName)resourceReference);
            return endpointString;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvocationException("Unexpected server error.", (Throwable)e);
        }
    }
}

