package org.gcube.portlets.admin.fulltextindexportlet.gwt.server;

import gr.uoa.di.madgik.grs.buffer.IBuffer.Status;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.data.DataCollection;

import java.io.StringReader;
import java.net.URI;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.security.PortalSecurityManager;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.index.fulltextindexnode.stubs.CreateResource;
import org.gcube.index.fulltextindexnode.stubs.CreateResourceResponse;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodeFactoryPortType;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodePortType;
import org.gcube.index.fulltextindexnode.stubs.GetIndexInformationResponse;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeFactoryServiceAddressingLocator;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeServiceAddressingLocator;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.server.util.GenericResourceManager;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.CollectionBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.FieldBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.FullTextIndexTypeBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.IndexBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.IndexTypeBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.MgmtPropertiesBean;
import org.gcube.portlets.admin.fulltextindexportlet.gwt.shared.RunningInstanceBean;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * A RemoteService implementation for the ManagementService following GWT RPC
 * design. Used in order to communicate with Management Resources and for
 * Management related queries towards DIS
 */
public class ManagementServiceImpl extends RemoteServiceServlet implements ManagementService {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2262958144498861061L;

	private static final long RSTIMEOUT = 10;
	private static final int NORESULTS = 25;

	/** Logger */
	private static Logger logger = Logger.getLogger(ManagementServiceImpl.class);

	private Map<String, GCUBEGenericResource> indexTypeResources;

	/** Class constructor */
	public ManagementServiceImpl() {
		try {
			ResourceRegistry.startBridging();
		} catch (ResourceRegistryException e) {
			logger.error("Error initialising servlet");
			e.printStackTrace();
		}
	}

	/**
	 * Returns a list of WSResource EPRs, given a list of resource property values and a namespace
	 * @param properties the RP values to search for
	 * @param namespace the namespace to search for
	 * @param scope the scope to search in
	 * @return the list of found WSResource EPRs
	 * @throws Exception
	 */
	private static List<EndpointReferenceType> getWSResourceEPRsFromPropValuesAndNamespace(List<String[]> properties, String namespace, GCUBEScope scope) throws Exception {
		String filter = "$result/child::*[local-name()='"+properties.get(0)[0].trim()+"' and namespace-uri(.)='"+namespace.trim()+"']/string() eq '"+properties.get(0)[1].trim()+"'";
		for (int i=1; i<properties.size(); i++)
			filter += " and $result/child::*[local-name()='"+properties.get(i)[0].trim()+"' and namespace-uri(.)='"+namespace.trim()+"']/string() eq '"+properties.get(i)[1].trim()+"'";

		ISClient client = GHNContext.getImplementation(ISClient.class);
		WSResourceQuery gquery = client.getQuery(WSResourceQuery.class);
		gquery.addGenericCondition(filter);

		logger.debug("query!! --> " + gquery.getExpression());

		List<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
		for(RPDocument d : client.execute(gquery, scope)){
			ret.add(d.getEndpoint());
		}
		return ret;
	}

	/**
	 * Returns the current GCUBE scope
	 * @return the scope
	 */
	private GCUBEScope getScope() {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
		ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
		return session.getScope();
	}

	private String getScopeName() {
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
		ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
		return session.getScopeName();
	}

	/**
	 * Creates a stub proxy given a port-type object.
	 * @param <PORTTYPE> the type of the port-type stub
	 * @param portTypeStub the original port-type to generate a stub proxy for
	 * @return the stub proxy
	 * @throws Exception an error occured
	 */
	private <PORTTYPE extends Remote> PORTTYPE getStubProxy(PORTTYPE portTypeStub) throws Exception {
		/* Get the D4Science session object */
		HttpSession httpSession = this.getThreadLocalRequest().getSession();
		String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
		ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);

		/* Create the security manager */
		PortalSecurityManager secManager = new PortalSecurityManager(session.getScope());
		if(secManager.isSecurityEnabled())
		{
			try {
				secManager.useCredentials(session.getCredential());
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		/* Get the sub proxy */
		try {
			return GCUBERemotePortTypeContext.getProxy(portTypeStub, session.getScope(), secManager);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService#getRunningInstances()
	 */
	public List<RunningInstanceBean> getRunningInstances() throws Exception {
		List<RunningInstanceBean> factoryEPRs = new LinkedList<RunningInstanceBean>();
		ISClient client = GHNContext.getImplementation(ISClient.class);
		GCUBEGenericQuery gquery = client.getQuery("RIEndpoint");
		gquery.addParameters(new QueryParameter("NAME", "FullTextIndexNode"),
				new QueryParameter("CLASS", "Index"),
				new QueryParameter("ENTRY", "gcube/index/FullTextIndexNodeFactory"));

		logger.debug("Quering for fulltextindexnodefactory RIs...");
		logger.debug(gquery.getExpression());

		List<XMLResult> eprs = client.execute(gquery, getScope());
		if (eprs == null || eprs.size() == 0) {
			throw new Exception("Unable to find any FullTextIndexNodeFactory service instances.");
		}
		for(XMLResult r : eprs){
			for (String r1 : r.evaluate("//Endpoint/text()")) {
				RunningInstanceBean ribean = new RunningInstanceBean();
				ribean.setRunningInstanceEPR(r1);
				factoryEPRs.add(ribean);
			}
		}
		return factoryEPRs;
	}

	/**
	 * {@inheritDoc}
	 */
	public List<String> query(String queryString, String indexID) throws Exception {

		logger.debug("-------->   query");
		logger.debug("Quering using --> indexID and term : " + indexID + " -- " + queryString);

		try {
			List<String[]> props = new LinkedList<String[]>();
			String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
			props.add(new String[] { "IndexID", indexID });
			List<EndpointReferenceType> lookupInstanceEPRs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());

			if (lookupInstanceEPRs.size() == 0) {
				throw new Exception("The lookup with the id [" + indexID + "] was not found on the IS");
			}

			FullTextIndexNodePortType lookupInstance = null;
			FullTextIndexNodeServiceAddressingLocator lookupInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
			lookupInstance = lookupInstanceLocator.getFullTextIndexNodePortTypePort(lookupInstanceEPRs.get(0));
			lookupInstance = getStubProxy(lookupInstance);
			// Query string example: (fieldID contains map)project fieldID1 fieldID2 fieldID3;
			String rsEPR = lookupInstance.query(queryString);
			logger.info("FT index Query RSepr -> " + rsEPR);
			return getListFromRS(rsEPR);

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @gwt.typeArgs <org.gcube.portlets.admin.fulltextportlet.gwt.client.beans.CollectionsByNameBean>
	 */
	public List<CollectionBean> getCollections() throws Exception {
		logger.debug("-------->  getCollections() in " + getScope().toString());

		HashMap<String,CollectionBean> beanFromIDMap = new HashMap<String,CollectionBean>();
		String colID, colName;

		try {
			logger.debug("SCOPE " + getScope().getName() + " ( " + getScopeName() +")");
			List<DataCollection> collections = DataCollection.getCollectionsOfScope(true, getScopeName());
			logger.debug("Size of collections is " + collections.size());
			for (DataCollection c : collections) {
				colID = c.getID();
				colName = c.getName();
				logger.debug("Added collection -> " + colName + " (" + colID + ") to nameFromIDMap");
				CollectionBean collection = new CollectionBean();
				collection.setId(colID);
				collection.setName(colName);
				collection.setIsReal(true);
				beanFromIDMap.put(colID, collection);
			}				
		} catch (ResourceRegistryException e) {
			logger.error("Failed to retrieve the collections", e);
			e.printStackTrace();
		}


		ISClient client = GHNContext.getImplementation(ISClient.class);

		CollectionBean fakeCollections = new CollectionBean();
		fakeCollections.setName("Empty Managers");

		List<RPDocument> indexData = new ArrayList<RPDocument>();
		try {
			WSResourceQuery wsquery = client.getQuery(WSResourceQuery.class);
			wsquery.addAtomicConditions(new AtomicCondition("//gc:ServiceName","FullTextIndexNode"));
			indexData = client.execute(wsquery, getScope());
		} catch (Exception e) {
			e.printStackTrace();
			logger.debug("Failed to execute the WS resource query");
		}

		String idxID = null;

		for (RPDocument d : indexData) {
			logger.debug("RPD Data -> " + d.toString());
			//TODO added here loop
			if ( (d.evaluate("//IndexID/text()")) != null) {
				idxID = d.evaluate("//IndexID/text()").get(0);
				logger.debug("idxID ***** ---> " + idxID);
			}
			List<String> indexCollectionIDs = d.evaluate("//CollectionID/text()");
			// This is an empty manager
			if (indexCollectionIDs == null || indexCollectionIDs.isEmpty()) {
				IndexBean idx = new IndexBean();
				idx.setId(idxID);
				fakeCollections.addIndex(idx);
			}
			// This is a manager that contains collections
			else {
				for (String idxColID : indexCollectionIDs ) {
					logger.debug("Fond index resource for collection -> " + idxColID + " Going to check if it is real");
					CollectionBean collection = (CollectionBean) beanFromIDMap.get(idxColID);
					if (collection == null) {
						logger.debug("Found fake index with CollectionID=" + idxColID);
						//	collection = new CollectionBean();
						//	collection.setId(idxColID);
						//	collection.setIsReal(false);
						//	beanFromIDMap.put(idxColID, collection);
						//	fakeCollections.addCollection(collection);
					}
					else {
						logger.debug("Found index for CollectionID=" + idxColID);

						if (idxID != null) {
							IndexBean idx = new IndexBean();
							idx.setId(idxID);
							collection.addIndex(idx);
						}
					}
				}
			}



		}
		//add to return list and sort:
		ArrayList<CollectionBean> returnList = new ArrayList<CollectionBean>();
		returnList.addAll(beanFromIDMap.values());
		Collections.sort(returnList);

		returnList.add(fakeCollections);
		for(int i = 0; i < returnList.size(); i++ ){
			((CollectionBean)returnList.get(i)).sort();
		}

		System.out.println("getCollections() -------->");
		return returnList;
	}

	/**
	 * {@inheritDoc}
	 */
	public IndexBean[] getIndices(String collectionID) throws Exception {
		List<String[]> props = new LinkedList<String[]>();
		String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
		props.add(new String[] { "CollectionID", collectionID });
		List<EndpointReferenceType> eprs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());

		String indexID = "";
		FullTextIndexNodePortType managementInstance = null;
		FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
		GetResourcePropertyResponse valueRP;

		IndexBean[] returnArray = new IndexBean[eprs.size()];
		for (int i = 0; i < eprs.size(); i++) {
			try {
				managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort(eprs.get(i));
				managementInstance = getStubProxy(managementInstance);
			} catch (Exception e) {
				e.printStackTrace();
			}
			valueRP = managementInstance.getResourceProperty(new QName(namespace, "IndexID"));
			indexID = valueRP.get_any()[0].getValue();

			QName resourceReference = new QName(namespace, "FullTextIndexNodeResourceReference");
			String epr = ObjectSerializer.toString(eprs.get(i), resourceReference);

			IndexBean indexBean = new IndexBean();
			indexBean.setId(indexID);
			indexBean.setName(indexID + "_name");
			indexBean.setHost(eprs.get(i).getAddress().getHost());
			indexBean.setEpr(epr);
			returnArray[i] = indexBean;

		}
		return returnArray;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService#getAvailableIndexTypeIDs()
	 */
	public List<FullTextIndexTypeBean> getAvailableIndexTypeIDs() throws Exception {
		String condition = "contains($result/Profile/Name/string(), 'IndexType_ft')";

		ISClient client =  GHNContext.getImplementation(ISClient.class);
		GCUBEGenericQuery query = client.getQuery("GCUBEResourceQuery");
		query.addParameters(new QueryParameter("FILTER", condition),
				new QueryParameter("TYPE", GCUBEGenericResource.TYPE),
				new QueryParameter("RESULT", "<Result>{$result/Profile/Name}</Result>"));

		List<XMLResult> result = client.execute(query, getScope());
		List<FullTextIndexTypeBean> ret = new LinkedList<FullTextIndexTypeBean>();

		for(XMLResult r : result){
			String indexTypeID = r.evaluate("//Name/text()").get(0);
			indexTypeID = indexTypeID.substring("IndexType_".length());
			FullTextIndexTypeBean ibean = new FullTextIndexTypeBean();
			ibean.setIndexTypeID(indexTypeID);
			ret.add(ibean);
		}
		return ret;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getIndexTypeID(String indexID) throws Exception {
		logger.debug("-------->   getIndexTypeID");

		try {
			List<String[]> props = new LinkedList<String[]>();
			String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
			props.add(new String[] { "IndexID", indexID });
			List<EndpointReferenceType> eprs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());

			if (eprs.size() == 0) {
				throw new Exception("The index with the id [" + indexID + "] was not found in IS");
			}

			FullTextIndexNodePortType managementInstance = null;
			FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
			managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort(eprs.get(0));
			managementInstance = getStubProxy(managementInstance);
			GetIndexInformationResponse indexInfo = managementInstance.getIndexInformation(new VOID());
			String idxType = indexInfo.getIndexID();

			logger.debug("getIndexTypeID -------->");
			return idxType;

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public MgmtPropertiesBean getResourceProperties(String indexID) throws Exception {

		logger.debug("-------->   getResourceProperties");

		try {
			List<String[]> props = new LinkedList<String[]>();
			String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
			props.add(new String[] { "IndexID", indexID });
			List<EndpointReferenceType> eprs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());

			if (eprs.size() == 0) {
				throw new Exception("The index with the id [" + indexID + "] was not found in IS");
			}

			FullTextIndexNodePortType managementInstance = null;
			FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
			managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort(eprs.get(0));
			managementInstance = getStubProxy(managementInstance);

			QName RP_CREATED = new QName(namespace, "Created");
			QName RP_MODIFIED = new QName(namespace, "Modified");
			QName RP_CLUSTERID = new QName(namespace, "ClusterID");
			QName[] qNames = { RP_CREATED, RP_MODIFIED, RP_CLUSTERID };

			GetMultipleResourcePropertiesResponse multipleRP = 
					managementInstance.getMultipleResourceProperties(new GetMultipleResourceProperties_Element(qNames));

			MgmtPropertiesBean properties = new MgmtPropertiesBean();
			properties.setCreated(multipleRP.get_any()[0].getValue());
			properties.setModified(multipleRP.get_any()[1].getValue());
			properties.setClusterID(multipleRP.get_any()[2].getValue());
			properties.setHost(eprs.get(0).getAddress().getHost() + ":" + eprs.get(0).getAddress().getPort());

			logger.debug("getResourceProperties -------->");
			return properties;

		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public String createIndex(String clusterID, String collectionID, String RIEPR) throws Exception {

		CreateResource mgmtCreateArguments = new CreateResource();
		if (clusterID != null && !clusterID.trim().equals("")) {
			mgmtCreateArguments.setClusterID(clusterID);
		}
		//TODO this is removed now. we create generic managers not specific collections are assigned
		//mgmtCreateArguments.setCollectionID(collectionID);

		try {
			Address factoryAddress = new Address(RIEPR);
			logger.debug("Trying LookupFactory on host: "
					+ factoryAddress.getHost() + ", port: "
					+ factoryAddress.getPort());
			EndpointReferenceType mgmtFactoryEPR = new EndpointReferenceType();
			mgmtFactoryEPR.setAddress(factoryAddress);
			FullTextIndexNodeFactoryServiceAddressingLocator mgmtFactoryLocator = new FullTextIndexNodeFactoryServiceAddressingLocator();
			FullTextIndexNodeFactoryPortType mgmtFactory = mgmtFactoryLocator.getFullTextIndexNodeFactoryPortTypePort(mgmtFactoryEPR);
			mgmtFactory = getStubProxy(mgmtFactory);
			CreateResourceResponse mgmtCreateResponse = mgmtFactory.createResource(mgmtCreateArguments);
			String returnedIndexID = mgmtCreateResponse.getIndexID();
			logger.debug("Created a new index node resource with indexID --> " + returnedIndexID);
			return returnedIndexID;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public Boolean removeIndex(String indexID, String collectionID) throws Exception {
		logger.debug("Destroying all FullTextIndexManagement resources with the ID: " + indexID);

		List<String[]> props = new LinkedList<String[]>();
		String namespace = "http://gcube-system.org/namespaces/index/FullTextIndexNode/service";
		props.add(new String[] { "IndexID", indexID });
		List<EndpointReferenceType> managementInstanceEPRs = getWSResourceEPRsFromPropValuesAndNamespace(props, namespace, getScope());


		FullTextIndexNodePortType managementInstance = null;
		FullTextIndexNodeServiceAddressingLocator managementInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
		//int counter = 0;
		//for (int i = 0; i < managementInstanceEPRs.size(); i++) {
		EndpointReferenceType managementEPR = managementInstanceEPRs.get(0);
		try {
			logger.debug("Handling managementEPR: " + managementEPR);
			managementInstance = managementInstanceLocator.getFullTextIndexNodePortTypePort(managementEPR);
			managementInstance = getStubProxy(managementInstance);
			//TODO change this with the remove function
			logger.debug("Resource has been removed");
			return managementInstance.deleteCollection(collectionID);

			//counter++;
		} catch (Exception e) {
			logger.debug("Problem deleting " + indexID + " FullTextIndexManagement resource.");
		}
		//}
		//if (counter == 0) {
		//	throw new Exception("No index removed. Wrong id?");
		//}
		return false;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService#getAllIndexTypes()
	 */
	public Map<String, IndexTypeBean> getAllIndexTypes() throws Exception  {
		List<String[]> conditions = new LinkedList<String[]>();
		conditions.add(new String[] { "/Profile/SecondaryType", "FullTextIndexType" });
		Map<String, IndexTypeBean> retMap = new HashMap<String, IndexTypeBean>();
		indexTypeResources = new HashMap<String, GCUBEGenericResource>();
		//	try {
		for (GCUBEGenericResource gr : GenericResourceManager.retrieveGenericResource(conditions, getScope())) {
			indexTypeResources.put(gr.getID(), gr);
			retMap.put(gr.getID(), parseIndexType(gr));
		}
		/*} catch (Exception e) {
			logger.error("Failed to get all indexTypes. An exception is thrown... \n" +  e.getMessage());
			e.printStackTrace();
			throw e;
		}*/
		return retMap;
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService#saveIndexType(org.gcube.portlets.admin.fulltextindexportlet.gwt.client.beans.IndexTypeBean)
	 */
	public String saveIndexType(IndexTypeBean idxType) throws Exception {
		String resourceID = idxType.getResourceID();
		GCUBEGenericResource gr = null;

		if (resourceID == null) {
			gr = GHNContext.getImplementation(GCUBEGenericResource.class);
			gr.setSecondaryType("FullTextIndexType");
			gr.setID("");
		}
		else {
			gr = indexTypeResources.get(resourceID);
		}

		gr.setName(idxType.getIndexTypeName());
		gr.setDescription(idxType.getIndexTypeDesc());
		gr.setBody(createIndexType(idxType.getIndexTypeFields()));

		resourceID = GenericResourceManager.updateGenericResource(gr, getScope());
		gr.setID(resourceID);
		indexTypeResources.put(resourceID, gr);

		return resourceID;
	}

	/**
	 * A method used parse an IndexType DOM document into FieldBeans
	 * 
	 * @param doc -
	 *            A DOM document representation of the IndexType
	 * @return - A list of all the fields of the IndexType in the form of
	 *         FieldBeans
	 */
	private IndexTypeBean parseIndexType(GCUBEGenericResource idxTypeResource) throws Exception {
		try {
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbFactory.newDocumentBuilder();
			Document idxTypeDoc = builder.parse(new InputSource(new StringReader(idxTypeResource.getBody())));
			XPath xpath = XPathFactory.newInstance().newXPath();
			Element elFieldList = (Element) xpath.evaluate("//field-list", idxTypeDoc.getDocumentElement(), XPathConstants.NODE);

			List<FieldBean> returnList = new LinkedList<FieldBean>();
			NodeList fieldList = elFieldList.getElementsByTagName("field");

			int fieldListLength = fieldList.getLength();

			for (int i = 0; i < fieldListLength; i++) {
				FieldBean fieldBean = new FieldBean();
				Node field = fieldList.item(i);
				NodeList fieldProperties = field.getChildNodes();
				String fieldName = field.getAttributes().getNamedItem("name").getNodeValue();
				//logger.debug("-----> " + fieldName);
				fieldBean.setName(fieldName);

				int propCount = fieldProperties.getLength();

				for (int j = 0; j<propCount; j++) {
					String propName = null;
					try {
						Node property = fieldProperties.item(j);

						if (property.getNodeType() == Node.ELEMENT_NODE) {
							Node textNode = property.getFirstChild();
							propName = property.getNodeName();

							if (propName.equalsIgnoreCase("index")) {
								fieldBean.setIndex("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("store")) {
								fieldBean.setStore("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("return")) {
								fieldBean.setReturned("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("tokenize")) {
								fieldBean.setTokenize("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("sort")) {
								fieldBean.setSort("yes".equalsIgnoreCase(textNode.getNodeValue().trim()));
							} else if (propName.equalsIgnoreCase("boost")) {
								fieldBean.setBoost(textNode.getNodeValue());
							}
						}
					} catch (IllegalArgumentException e) {
					} // illegal property -- ignore
				}
				returnList.add(fieldBean);
			}

			IndexTypeBean itb = new IndexTypeBean();
			itb.setIndexTypeName(idxTypeResource.getName());
			itb.setIndexTypeDesc(idxTypeResource.getDescription());
			itb.setResourceID(idxTypeResource.getID());
			FieldBean[] fields = new FieldBean[returnList.size()];
			for (int i=0; i<returnList.size(); i++)
				fields[i] = returnList.get(i);
			itb.setIndexTypeFields(fields);
			return itb;
		} catch (Exception e) {
			logger.error("Failed to parse indexType from generic resource with name: " + idxTypeResource.getName(), e);
			throw new Exception("Failed to parse indexType from generic resource with name: " + idxTypeResource.getName(), e);
		}
	}

	/**
	 * Creates the XML string representation of an indexType, given the list
	 * of fields that the indexType contains.
	 * @param fields the list of indexType fields
	 * @return
	 */
	private String createIndexType(FieldBean[] fields) {
		StringBuilder indexType = new StringBuilder();
		indexType.append("<index-type name=\"default\"><field-list sort-xnear-stop-word-threshold=\"2E8\">");

		for (int i = 0; i < fields.length; i++) {
			FieldBean field = (FieldBean) fields[i];
			indexType.append("<field name=\"" + field.getName() + "\">");
			indexType.append("<index>" + (field.getIndex() ? "yes" : "no") + "</index>");
			indexType.append("<store>" + (field.getStore() ? "yes" : "no") + "</store>");
			indexType.append("<return>" + (field.getReturned() ? "yes" : "no") + "</return>");
			indexType.append("<tokenize>" + (field.getTokenize() ? "yes" : "no") + "</tokenize>");
			indexType.append("<sort>no</sort>");
			indexType.append("<boost>" + field.getBoost() + "</boost>");
			indexType.append("</field>");
		}
		indexType.append("</field-list></index-type>");

		return indexType.toString();
	}

	/* (non-Javadoc)
	 * @see org.gcube.portlets.admin.fulltextindexportlet.gwt.client.interfaces.ManagementService#deleteIndexType(org.gcube.portlets.admin.fulltextindexportlet.gwt.client.beans.IndexTypeBean)
	 */
	public void deleteIndexType(IndexTypeBean idxType) throws Exception {
		String resourceID = idxType.getResourceID();
		GenericResourceManager.deleteGenericResource(resourceID, getScope());
		indexTypeResources.remove(resourceID);
	}

	/**
	 * A method used to harvest the first page of a ResultSet, and put xml
	 * representations all the results into a list of Strings
	 * 
	 * @param epr -
	 *            the epr of the ResultSet
	 * @return XML representation of each result in the first page in a list of
	 *         Strings
	 * @throws Exception -
	 *             When unable to read from the ResultSet
	 */
	private List<String> getListFromRS(String epr) throws Exception {

		ForwardReader<Record> reader = new ForwardReader<Record>(new URI(epr));
		Record result = null;

		ArrayList<String> returnList = new ArrayList<String>();

		int i = 0;
		while(i < NORESULTS) 
		{
			int counter = 0;
			int maxFail = 5;
			//read the next record
			while (true) {

				try {
					result = reader.get(RSTIMEOUT, TimeUnit.SECONDS);
					break;
				} catch (Exception e) {
					if (counter++ <= maxFail) {
						logger.error("getListFromRS failed for the "
								+ counter
								+ ". time.", e);
					} else {
						logger.error(" getListFromRS giving up. FAILED!",	e);
						throw e;
					}
				}
			}

			//if there is nothing else to read
			if(result == null && (reader.getStatus()==Status.Dispose || (reader.getStatus()==Status.Close && reader.availableRecords()==0))) 
			{
				break;
			}

			if(result != null) {
				StringBuilder builder =  new StringBuilder();
				builder.append("<record>");

				//read the fields
				Field[] fields = result.getFields();
				for(Field f : fields) {
					String fieldName = f.getFieldDefinition().getName();
					String fieldContent = ((StringField)f).getPayload();
					builder.append("<" + fieldName + ">" 
							+ fieldContent + "</" + fieldName + ">");
				}

				builder.append("</record>");

				returnList.add(builder.toString());

				i++;
			}
		}

		try{
			reader.close();
		} catch (Exception e) {
			logger.warn("could not close reader: ", e);
		}

		System.out.println("query    --------> ");
		return returnList;
	}

	public String updateIndex(String indexID, String rsLocator) throws InvocationException {

		try {
			HttpSession httpSession = this.getThreadLocalRequest().getSession();
			String username = httpSession.getAttribute(ScopeHelper.USERNAME_ATTRIBUTE).toString();
			ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
			GCUBEScope scope = session.getScope();


			// Find a suitable RI for creating an updater
			CreateResourceResponse updaterCreateResponse = null;

			ISClient client = GHNContext.getImplementation(ISClient.class);
			List<String> factoryEPRs = new LinkedList<String>();
			GCUBEGenericQuery gquery = client.getQuery("RIEndpoint");
			gquery.addParameters(new QueryParameter("NAME", "FullTextIndexNode"),
					new QueryParameter("CLASS", "Index"),
					new QueryParameter("ENTRY", "gcube/index/FullTextIndexNodeFactory"));
			List<XMLResult> eprs = client.execute(gquery, scope);			
			for(XMLResult r : eprs){
				for (String r1 : r.evaluate("//Endpoint/text()"))
					factoryEPRs.add(r1);
			}

			if (factoryEPRs.size() == 0) {
				Exception ie = new Exception("Unable to find a FullTextIndexBatchUpdaterFactoryService in the VO.");
				ie.printStackTrace();
				throw ie;
			}

			int i = 0;
			while (true) {
				try {
					Address factoryAddress = new Address(factoryEPRs.get(i));
					System.out.println("Trying UpdaterFactory on host: "
							+ factoryAddress.getHost() + ", port: "
							+ factoryAddress.getPort());
					EndpointReferenceType updaterFactoryEPR = new EndpointReferenceType();
					updaterFactoryEPR.setAddress(factoryAddress);
					FullTextIndexNodeFactoryServiceAddressingLocator updaterFactoryLocator = new FullTextIndexNodeFactoryServiceAddressingLocator();
					FullTextIndexNodeFactoryPortType updaterFactory = updaterFactoryLocator.getFullTextIndexNodeFactoryPortTypePort(updaterFactoryEPR);
					updaterFactory = getStubProxy(updaterFactory);

					// Create updater resource and get endpoint reference of
					// WS-Resource:
					CreateResource updaterCreateArguments = new CreateResource();
					updaterCreateArguments.setIndexID(indexID);
					updaterCreateResponse = updaterFactory.createResource(updaterCreateArguments);
					break;
				} catch (Exception e) {
					if (++i == factoryEPRs.size()) {
						throw e;
					}
					e.printStackTrace();
				}
			}

			EndpointReferenceType updaterInstanceEPR = updaterCreateResponse.getEndpointReference();
			FullTextIndexNodeServiceAddressingLocator updaterInstanceLocator = new FullTextIndexNodeServiceAddressingLocator();
			FullTextIndexNodePortType updaterInstance = updaterInstanceLocator.getFullTextIndexNodePortTypePort(updaterInstanceEPR);
			updaterInstance = getStubProxy(updaterInstance);

			// Start the update
			updaterInstance.feedLocator(rsLocator);

			QName resourceReference = new QName(
					"http://gcube-system.org/namespaces/index/FullTextIndexNode/service",
					"FullTextIndexNodeResourceReference");
			String endpointString = ObjectSerializer.toString(updaterInstanceEPR, resourceReference);

			return endpointString;
		} catch (Exception e) {
			e.printStackTrace();
			throw new InvocationException("Unexpected server error.", e);
		}
	}

}
