/**
 * 
 */
package org.gcube.portlets.admin.fulltextindexportlet.gwt.server.util;

import java.util.List;

import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class GenericResourceManager {
	
	/** Logger */
	private static Logger logger = Logger.getLogger(GenericResourceManager.class);
	
	/**
	 * Retrieves a set of generic resources from the IS and returns them.
	 * 
	 * @param conditions pairs of strings representing "property"="value" conditions
	 * @return an object representing the generic resource
	 */
	public static List<GCUBEGenericResource> retrieveGenericResource(List<String[]> conditions, GCUBEScope scope) throws Exception {
		try {
			ISClient client = GHNContext.getImplementation(ISClient.class);
			GCUBEGenericResourceQuery query = client.getQuery(GCUBEGenericResourceQuery.class);
			for (String[] cond : conditions) {
				query.addAtomicConditions(new AtomicCondition(cond[0], cond[1]));
			}

			List<GCUBEGenericResource> result = client.execute(query, scope);
			if (result==null || result.size()==0)
				throw new Exception("No generic resources found for the given conditions.");

			return result;
		} catch (Exception e) {
			logger.error("Failed to retrieve generic resources.", e);
			throw new Exception("Failed to retrieve generic resources.", e);
		}
	}
	
	public static String updateGenericResource(GCUBEGenericResource resource, GCUBEScope scope) throws Exception {
		ISPublisher publisher = GHNContext.getImplementation(ISPublisher.class);
		GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
		return publisher.registerGCUBEResource(resource, scope, managerSec);
	}
	
	public static void deleteGenericResource(String resourceID, GCUBEScope scope) throws Exception {
		ISPublisher publisher = GHNContext.getImplementation(ISPublisher.class);
		GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
		publisher.removeGCUBEResource(resourceID, GCUBEGenericResource.TYPE, scope, managerSec);
	}
}
