/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.usersmanagementportlet.gwt.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;

public class EmailNotification {
    private String emailSender;
    private String[] emailrecipients;
    private ArrayList<String> managersEmails = null;
    private boolean notifySupportTeam = false;
    private boolean useConfigEmailAddress = false;
    private static final String supportTeamEmailAddress = "support_team@d4science.org";
    private String recipientType;
    private String emailSubject;
    private String emailBody;
    private static Logger logger = Logger.getLogger(EmailNotification.class);

    public EmailNotification(String sender, String[] recipients, ArrayList<String> managersEmails, String subject, String body, String copyVisibility, boolean notifySupportTeam, boolean useConfigEmail) {
        this.emailSender = sender == null ? ScopeHelper.getSupportMainlingListAddr() : sender;
        this.emailrecipients = recipients;
        this.emailSubject = this.readPortalInstanceNameFromConfigFile() + " - " + subject;
        this.emailBody = body;
        this.recipientType = copyVisibility;
        this.notifySupportTeam = notifySupportTeam;
        this.managersEmails = managersEmails;
        this.useConfigEmailAddress = useConfigEmail;
    }

    public void sendEmail() {
        Properties props = System.getProperties();
        String mailServiceHost = "localhost";
        props.put("mail.smtp.host", mailServiceHost);
        String mailServicePort = "25";
        props.put("mail.smtp.port", mailServicePort);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(true);
        MimeMessage mimeMessage = new MimeMessage(session);
        try {
            Object address;
            InternetAddress from = new InternetAddress(this.emailSender);
            mimeMessage.setFrom((Address)from);
            if (this.notifySupportTeam) {
                address = new InternetAddress(supportTeamEmailAddress);
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)address);
            }
            if (this.useConfigEmailAddress) {
                try {
                    address = this.readEmailAddressFromConfigFile();
                }
                catch (Exception e) {
                    logger.error((Object)"Could not read the config file. Using sender's address in the TO field.");
                    address = this.emailSender;
                }
                logger.debug((Object)("Using the address from the config file as TO type. The address is -> " + (String)address));
                InternetAddress maddress = new InternetAddress((String)address);
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)maddress);
            }
            Message.RecipientType recipientTypeValue = Message.RecipientType.BCC;
            if (this.recipientType.equals("to")) {
                recipientTypeValue = Message.RecipientType.TO;
            } else if (this.recipientType.equals("cc")) {
                recipientTypeValue = Message.RecipientType.CC;
            }
            for (int i = 0; i < this.emailrecipients.length; ++i) {
                InternetAddress address2 = new InternetAddress(this.emailrecipients[i]);
                logger.debug((Object)("RecipientType -> " + recipientTypeValue));
                mimeMessage.addRecipient(recipientTypeValue, (Address)address2);
            }
            if (this.managersEmails != null) {
                for (String managerEmail : this.managersEmails) {
                    InternetAddress address3 = new InternetAddress(managerEmail);
                    mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)address3);
                }
            }
            mimeMessage.setSubject(this.emailSubject);
            mimeMessage.setContent((Object)this.emailBody, "text/html");
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Failed to send the email message.", (Throwable)e);
        }
    }

    private String readEmailAddressFromConfigFile() throws IOException {
        Properties prop = new Properties();
        String catalinaHome = System.getProperty("catalina.base");
        String fileName = catalinaHome + File.separator + "shared" + File.separator + "d4s" + File.separator + "umPortlet-email.config";
        logger.debug((Object)("Using file -> " + fileName));
        FileInputStream is = new FileInputStream(fileName);
        prop.load(is);
        String address = prop.getProperty("email.to");
        return address;
    }

    private String readPortalInstanceNameFromConfigFile() {
        try {
            Properties prop = new Properties();
            String catalinaHome = System.getProperty("catalina.base");
            String fileName = catalinaHome + File.separator + "conf" + File.separator + "gcube-data.properties";
            logger.debug((Object)("Using file -> " + fileName));
            FileInputStream is = new FileInputStream(fileName);
            prop.load(is);
            String address = prop.getProperty("portalinstancename");
            if (address != null) {
                return address;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "[PORTAL - iMARINE]";
    }
}

