/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.usersmanagementportlet.gwt.client;

import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.LoadMask;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.CheckboxColumnConfig;
import com.gwtext.client.widgets.grid.CheckboxSelectionModel;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.event.GridRowListener;
import com.gwtextux.client.data.PagingMemoryProxy;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.ExceptionAlertWindow;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.FilterPanel;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.UserEditContextMenu;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.UsersInfoGrid;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.UsersManagement;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.shared.FilterType;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.shared.UserInfo;

public class UsersInfoGrid
extends Composite {
    protected static final int numberOfAdditionalFields = 3;
    private int numberOfRoles;
    private String[] availableRoles;
    private ArrayList<UserInfo> registeredUsersInfo;
    private ArrayList<UserInfo> initialUsersList;
    private int numberOfRecordsPerPage = 15;
    private ScrollPanel scroller = new ScrollPanel();
    private VerticalPanel panel;
    private HorizontalPanel tp = new HorizontalPanel();
    private VerticalPanel gridHostPanel = new VerticalPanel();
    private HorizontalPanel buttonsPanel;
    private static GridPanel grid = new GridPanel();
    private static LoadMask loadMask = new LoadMask("UsersDiv", "Loading, please wait...");
    private UserEditContextMenu cMenu = new UserEditContextMenu(grid, this);
    private static RecordDef rdef;
    private FilterPanel filterPanel = null;

    public UsersInfoGrid() {
        this.panel = new VerticalPanel();
        this.buttonsPanel = new HorizontalPanel();
        this.buttonsPanel.setSpacing(15);
        this.panel.add((Widget)this.tp);
        1 getAvailableRolesCallback = new /* Unavailable Anonymous Inner Class!! */;
        UsersManagement.userService.getAvailableRolesByCurrentGroup((AsyncCallback)getAvailableRolesCallback);
        loadMask.show();
        this.initWidget((Widget)this.panel);
        Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateSize() {
        RootPanel root = RootPanel.get((String)"UsersDiv");
        int leftBorder = root.getAbsoluteLeft();
        int rightScrollBar = 17;
        int rootWidth = Window.getClientWidth() - 2 * leftBorder - rightScrollBar;
        this.tp.setWidth(new Integer(rootWidth).toString());
        int atomWidth = rootWidth / 4;
        grid.setWidth(atomWidth * 3);
        this.filterPanel.setWidth(new Integer(atomWidth).toString());
    }

    private void createGrid() {
        CheckboxSelectionModel cbSelectionModel = new CheckboxSelectionModel();
        FieldDef[] fieldDef = new FieldDef[this.numberOfRoles + 3];
        fieldDef[0] = new StringFieldDef("username");
        fieldDef[1] = new StringFieldDef("email");
        fieldDef[2] = new StringFieldDef("fullname");
        for (int i = 3; i < this.numberOfRoles + 3; ++i) {
            fieldDef[i] = new StringFieldDef(this.availableRoles[i - 3]);
        }
        BaseColumnConfig[] columns = new BaseColumnConfig[fieldDef.length + 1];
        columns[0] = new CheckboxColumnConfig(cbSelectionModel);
        columns[1] = new ColumnConfig("Username", "username", 140, true, null, "username");
        columns[2] = new ColumnConfig("Email", "email", 200, true);
        columns[3] = new ColumnConfig("Full name", "fullname", 160, true);
        for (int i = 4; i < columns.length; ++i) {
            columns[i] = new ColumnConfig(this.availableRoles[i - 4], this.availableRoles[i - 4], 110, true, null, this.availableRoles[i - 4]);
        }
        RecordDef recordDef = new RecordDef(fieldDef);
        ArrayReader reader = new ArrayReader(recordDef);
        ColumnModel columnModel = new ColumnModel(columns);
        rdef = recordDef;
        3 getUsersAndRolesCallback = new /* Unavailable Anonymous Inner Class!! */;
        UsersManagement.userService.getRegisteredUsersForaVO((AsyncCallback)getUsersAndRolesCallback);
        Button editUserRolesBtn = new Button("Edit Selected User Roles", (ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        editUserRolesBtn.setTooltip("Edits the selected user's roles");
        this.buttonsPanel.add((Widget)editUserRolesBtn);
        grid.addGridRowListener((GridRowListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateGridData(ArrayList<UserInfo> usersData) {
        if (usersData != null) {
            this.registeredUsersInfo = usersData;
        }
        this.reloadStore(grid.getStore(), (Object[][])this.getDataAsObject());
    }

    protected void updateGridTitle() {
        grid.setTitle("Number of registered users: " + grid.getStore().getTotalCount());
    }

    protected void reloadStore(Store store, Object[][] data) {
        store.removeAll();
        store.commitChanges();
        PagingMemoryProxy proxy = new PagingMemoryProxy(data);
        store.setDataProxy((DataProxy)proxy);
        store.commitChanges();
        store.load(0, this.numberOfRecordsPerPage);
        this.updateGridTitle();
    }

    protected void updateLocalRegisteredUsersInfo(ArrayList<UserInfo> newUsers) {
        for (UserInfo u : newUsers) {
            this.registeredUsersInfo.add(u);
        }
    }

    protected void removeLocalRegisteredUsers(String[] usersToBeRemoved) {
        block0: for (int i = 0; i < usersToBeRemoved.length; ++i) {
            int index = 0;
            for (UserInfo u : this.registeredUsersInfo) {
                if (u.getUsername().equals(usersToBeRemoved[i])) {
                    this.registeredUsersInfo.remove(index);
                    continue block0;
                }
                ++index;
            }
        }
    }

    protected void updateLocalRegisteredUserRoles(String username, ArrayList<String> newRoles) {
        for (UserInfo u : this.registeredUsersInfo) {
            if (!u.getUsername().equals(username)) continue;
            u.setAssignedRoles(newRoles);
            break;
        }
        for (UserInfo u : this.initialUsersList) {
            if (!u.getUsername().equals(username)) continue;
            u.setAssignedRoles(newRoles);
            break;
        }
    }

    protected String[][] getDataAsObject() {
        String[][] data = new String[this.registeredUsersInfo.size()][];
        int j = 0;
        for (UserInfo u : this.registeredUsersInfo) {
            String[] rowData = new String[this.numberOfRoles + 3];
            rowData[0] = u.getUsername();
            rowData[1] = u.getEmail();
            rowData[2] = u.getFullname();
            ArrayList usersRoles = u.getAssignedRoles();
            for (int i = 0; i < this.numberOfRoles; ++i) {
                if (usersRoles != null) {
                    if (usersRoles.contains(this.availableRoles[i])) {
                        rowData[i + 3] = "YES";
                        continue;
                    }
                    rowData[i + 3] = "NO";
                    continue;
                }
                rowData[i + 3] = "NO";
            }
            data[j] = rowData;
            ++j;
        }
        return data;
    }

    protected HashMap<String, FilterType> getFilters() {
        HashMap<String, FilterType> filters = new HashMap<String, FilterType>();
        filters.put("username", FilterType.LITERAL);
        filters.put("fullname", FilterType.LITERAL);
        filters.put("email", FilterType.LITERAL);
        for (String role : this.availableRoles) {
            filters.put(role, FilterType.BOOLEAN);
        }
        return filters;
    }

    protected static GridPanel getGridPanel() {
        return grid;
    }

    protected static RecordDef getRecordDef() {
        return rdef;
    }

    protected void refreshGrid() {
        this.gridHostPanel.clear();
        this.createGrid();
    }

    protected static void displayErrorWindow(String userMsg, Throwable caught) {
        ExceptionAlertWindow alertWindow = new ExceptionAlertWindow(userMsg, true);
        alertWindow.addDock(caught);
        int left = Window.getClientWidth() / 2;
        int top = Window.getClientHeight() / 2;
        alertWindow.setPopupPosition(left, top);
        alertWindow.show();
    }

    static /* synthetic */ LoadMask access$000() {
        return loadMask;
    }

    static /* synthetic */ int access$102(UsersInfoGrid x0, int x1) {
        x0.numberOfRoles = x1;
        return x0.numberOfRoles;
    }

    static /* synthetic */ String[] access$202(UsersInfoGrid x0, String[] x1) {
        x0.availableRoles = x1;
        return x1;
    }

    static /* synthetic */ FilterPanel access$302(UsersInfoGrid x0, FilterPanel x1) {
        x0.filterPanel = x1;
        return x0.filterPanel;
    }

    static /* synthetic */ FilterPanel access$300(UsersInfoGrid x0) {
        return x0.filterPanel;
    }

    static /* synthetic */ HorizontalPanel access$400(UsersInfoGrid x0) {
        return x0.tp;
    }

    static /* synthetic */ VerticalPanel access$500(UsersInfoGrid x0) {
        return x0.gridHostPanel;
    }

    static /* synthetic */ ArrayList access$600(UsersInfoGrid x0) {
        return x0.registeredUsersInfo;
    }

    static /* synthetic */ ArrayList access$700(UsersInfoGrid x0) {
        return x0.initialUsersList;
    }

    static /* synthetic */ void access$800(UsersInfoGrid x0) {
        x0.createGrid();
    }

    static /* synthetic */ void access$900(UsersInfoGrid x0) {
        x0.updateSize();
    }

    static /* synthetic */ ArrayList access$602(UsersInfoGrid x0, ArrayList x1) {
        x0.registeredUsersInfo = x1;
        return x0.registeredUsersInfo;
    }

    static /* synthetic */ ArrayList access$702(UsersInfoGrid x0, ArrayList x1) {
        x0.initialUsersList = x1;
        return x0.initialUsersList;
    }

    static /* synthetic */ GridPanel access$1000() {
        return grid;
    }

    static /* synthetic */ int access$1100(UsersInfoGrid x0) {
        return x0.numberOfRecordsPerPage;
    }

    static /* synthetic */ int access$1102(UsersInfoGrid x0, int x1) {
        x0.numberOfRecordsPerPage = x1;
        return x0.numberOfRecordsPerPage;
    }

    static /* synthetic */ ScrollPanel access$1200(UsersInfoGrid x0) {
        return x0.scroller;
    }

    static /* synthetic */ HorizontalPanel access$1300(UsersInfoGrid x0) {
        return x0.buttonsPanel;
    }

    static /* synthetic */ UserEditContextMenu access$1400(UsersInfoGrid x0) {
        return x0.cMenu;
    }
}

