/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.usersmanagementportlet.gwt.client;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Position;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.form.Checkbox;
import com.gwtext.client.widgets.form.Field;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.form.TextField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.shared.FilterType;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.shared.UserInfo;

public class FilterPanel
extends Composite {
    private Panel mainPanel = new Panel("Filters");
    private FormPanel formPanel = new FormPanel(Position.LEFT);
    private Button filterButton = new Button("Filter");
    private Button resetButton = new Button("Reset");

    public FilterPanel(HashMap<String, FilterType> filters) {
        this.mainPanel.setBodyStyle("background-color:#EEEEEE");
        this.mainPanel.setCollapsible(true);
        this.formPanel.setAutoWidth(true);
        this.formPanel.setBodyStyle("background-color:#EEEEEE");
        this.formPanel.setBorder(false);
        this.formPanel.setAutoHeight(true);
        this.filterButton.setTooltip("Filters the records with the given filters");
        this.resetButton.setTooltip("Resets the applied filters");
        for (Map.Entry<String, FilterType> entry : filters.entrySet()) {
            String filterName = entry.getKey();
            FilterType filterType = filters.get(filterName);
            if (filterType == FilterType.LITERAL) {
                TextField filterField = new TextField();
                filterField.setLabel(filterName);
                this.formPanel.add((Component)filterField);
                continue;
            }
            Checkbox filterBox = new Checkbox();
            filterBox.setLabel(filterName);
            this.formPanel.add((Component)filterBox);
        }
        this.formPanel.addButton(this.filterButton);
        this.formPanel.addButton(this.resetButton);
        this.mainPanel.add((Component)this.formPanel);
        this.initWidget((Widget)this.mainPanel);
    }

    protected void setFilterButtonClickHandler(ButtonListenerAdapter listener) {
        this.filterButton.addListener((ButtonListener)listener);
    }

    protected void setResetButtonClickHandler(ButtonListenerAdapter listener) {
        this.resetButton.addListener((ButtonListener)listener);
    }

    protected void resetFields() {
        Field[] fields;
        for (Field f : fields = this.formPanel.getFields()) {
            f.reset();
        }
    }

    protected ArrayList<UserInfo> filterData(ArrayList<UserInfo> availableUsers) {
        HashMap<String, String> filters = new HashMap<String, String>();
        ArrayList<UserInfo> filteredUsers = new ArrayList<UserInfo>();
        Field[] fields = this.formPanel.getFields();
        for (int i = 0; i < fields.length; ++i) {
            String textValue;
            if (fields[i] instanceof Checkbox) {
                String isSelected = fields[i].getValueAsString();
                if (!isSelected.equalsIgnoreCase("true")) continue;
                String name = fields[i].getFieldLabel();
                filters.put(name, "true");
                continue;
            }
            if (!(fields[i] instanceof TextField) || (textValue = fields[i].getValueAsString()).trim().isEmpty()) continue;
            filters.put(fields[i].getFieldLabel(), textValue);
        }
        for (UserInfo ui : availableUsers) {
            Iterator it = filters.keySet().iterator();
            boolean hasMatch = true;
            while (it.hasNext() && hasMatch) {
                String filterName = (String)it.next();
                String filterValue = (String)filters.get(filterName);
                filterValue = filterValue.replaceAll("\\*", "").replaceAll("\\?", "");
                if (filterName.equalsIgnoreCase("username")) {
                    hasMatch = ui.getUsername().toLowerCase().contains(filterValue.trim().toLowerCase());
                    continue;
                }
                if (filterName.equalsIgnoreCase("fullName")) {
                    hasMatch = ui.getFullname().toLowerCase().contains(filterValue.trim().toLowerCase());
                    continue;
                }
                if (filterName.equalsIgnoreCase("email")) {
                    hasMatch = ui.getEmail().toLowerCase().contains(filterValue.trim().toLowerCase());
                    continue;
                }
                ArrayList roles = ui.getAssignedRoles();
                boolean roleFound = false;
                for (String r : roles) {
                    if (!filterName.equalsIgnoreCase(r)) continue;
                    roleFound = true;
                    break;
                }
                if (roleFound) continue;
                hasMatch = false;
            }
            if (!hasMatch) continue;
            filteredUsers.add(new UserInfo(ui.getUsername(), ui.getFullname(), ui.getEmail(), ui.getAssignedRoles(), null, null));
        }
        return filteredUsers;
    }
}

