/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.usersmanagementportlet.gwt.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = -8423345575690165644L;
    private static Logger logger = Logger.getLogger(DownloadServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            response.setHeader("Content-Disposition", "attachment; filename=usersInformation.xml");
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            out.write(this.createXMLWithEmails(request));
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while trying to serve the file with the emails", (Throwable)e);
            response.sendError(500, "Error during data retrieving: " + e.getMessage());
            return;
        }
    }

    private String createXMLWithEmails(HttpServletRequest request) throws Exception {
        HttpSession httpSession = request.getSession();
        String currentUser = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), currentUser);
        LiferayGroupManager groupM = new LiferayGroupManager();
        LiferayUserManager userM = new LiferayUserManager();
        String usersInfo = null;
        HashMap<String, String> usersAndEmails = new HashMap<String, String>();
        List registeredUsers = new ArrayList();
        try {
            registeredUsers = userM.listUsersByGroup(groupM.getGroupId(session.getGroupName()));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the users of the current VO. An exception was thrown", (Throwable)e);
            throw new Exception();
        }
        for (UserModel u : registeredUsers) {
            String user = u.getScreenName();
            String email = u.getEmail();
            usersAndEmails.put(user, email);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document doc = impl.createDocument(null, null, null);
            Element root = doc.createElement("UsersInfo");
            doc.appendChild(root);
            Element users = doc.createElement("RegisteredUsers");
            users.setAttribute("VO-VRE", session.getScopeName().replaceAll("/", " "));
            root.appendChild(users);
            for (String username : usersAndEmails.keySet()) {
                String email = (String)usersAndEmails.get(username);
                Element userEl = doc.createElement("user");
                users.appendChild(userEl);
                Element usernameEl = doc.createElement("username");
                usernameEl.setTextContent(username);
                Element emailEl = doc.createElement("email");
                emailEl.setTextContent(email);
                userEl.appendChild(usernameEl);
                userEl.appendChild(emailEl);
            }
            try {
                usersInfo = this.createStringFromDomTree((Node)doc);
            }
            catch (TransformerException e) {
                logger.error((Object)"Failed to create the XML file");
                throw new Exception("Failed to create the XML file", e);
            }
        }
        catch (ParserConfigurationException e1) {
            logger.error((Object)"Failed to create the XML file");
            e1.printStackTrace();
            throw new Exception("Failed to create the XML file", e1);
        }
        return usersInfo;
    }

    private String createStringFromDomTree(Node tree) throws TransformerException {
        String nodeString = null;
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        DOMSource source = new DOMSource(tree);
        transformer.transform(source, result);
        nodeString = sw.getBuffer().toString();
        return nodeString;
    }
}

