package org.gcube.portlets.admin.usersmanagementportlet.gwt.server;

import org.apache.log4j.Logger;

/**
 * Constructs the body of the email message sent when a user is rejected
 * 
 * @author Panagiota Koltsida, NKUA
 *
 */
public class UserRejectionEmailMessageTemplate {

	private String currentVO;
	private String username;
	private String managerEmail;
	
	
	/** Logger */
	private static Logger logger = Logger.getLogger(UserRejectionEmailMessageTemplate.class);
	
	
	public UserRejectionEmailMessageTemplate(String VO, String username, String managerEmail) {
		this.currentVO = VO;
		this.username = username;
		this.managerEmail = managerEmail;
	}
	
	public String createBodyMessage() {
		String bodyMsg = "<p style=\"font-size:medium\">Dear <b>" + this.username + "</b>,</p>";
		bodyMsg += "<p style=\"font-size:medium\">your request for accessing the </p>";
		bodyMsg += "<p style=\"font-size:medium\"><b>" + this.currentVO + "</b> VO/VRE</p>";
		bodyMsg += "<p style=\"font-size:medium\">has been rejected by " + this.managerEmail + "</p>";
		bodyMsg += "<p style=\"font-size:medium\">For more information please contact the VRE-manager.</p>";
		
		
		bodyMsg += "<br><br><p style=\"font-size:small\"> WARNING / LEGAL TEXT: This message is intended only for the use of the individual or entity to which it is addressed and may contain " +
		"information which is privileged, confidential, proprietary, or exempt from disclosure under applicable law.<br>" +
		"If you are not the intended recipient or the person responsible for " +
				"delivering the message to the intended recipient, you are strictly prohibited from disclosing, distributing, copying, or in any way using this message.<br>" +
				"If you have received this communication in error, please notify the sender and destroy and delete any copies you may have received.</p>";

		
		logger.debug("The body msg that will be sent is.... ");
		logger.debug(bodyMsg);
		
		return bodyMsg;
	}
}
