/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.usersmanagementportlet.gwt.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.exceptions.CurrentGroupRetrievalException;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.exceptions.GroupAssignmentException;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.exceptions.PendingUsersRetrievalException;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.exceptions.RegisteredUsersRetrievalException;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.exceptions.RolesRetrievalException;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.exceptions.UserInfoRetrievalException;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.exceptions.UserRemovalFailureException;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.client.interfaces.UsersManagementService;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.server.EmailNotification;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.server.ErrorNotificationEmailMessageTemplate;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.server.UserRegistrationEmailMessageTemplate;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.server.UserRejectionEmailMessageTemplate;
import org.gcube.portlets.admin.usersmanagementportlet.gwt.shared.UserInfo;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GroupModel;
import org.gcube.vomanagement.usermanagement.model.RoleModel;
import org.gcube.vomanagement.usermanagement.model.UserModel;

public class UsersManagementServlet
extends RemoteServiceServlet
implements UsersManagementService {
    private static Logger logger = Logger.getLogger(UsersManagementServlet.class);
    private static final long serialVersionUID = 1L;
    private UserManager userM = new LiferayUserManager();
    private RoleManager roleM = new LiferayRoleManager();
    private GroupManager groupM = new LiferayGroupManager();
    private static final String SESSION_VOMS_UNREGISTERED_USERS = "ump_session_voms_users";
    private static final String USER_ADDED = "user_added";
    private static final String USER_REMOVED = "user_removed";

    public UsersManagementServlet() {
        try {
        }
        catch (ServletException e) {
            logger.error((Object)"Servlet failed to initialize");
        }
    }

    private ASLSession getASLsession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    private String getCurrentGroupID() throws CurrentGroupRetrievalException {
        ASLSession session = this.getASLsession();
        logger.debug((Object)("The current group NAME is --> " + session.getGroupName()));
        try {
            try {
                return this.groupM.getGroupId(session.getGroupName());
            }
            catch (UserManagementSystemException e) {
                throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
            }
        }
        catch (GroupRetrievalFault e) {
            throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
        }
    }

    public String[] getAvailableRolesByCurrentGroup() {
        try {
            List roles = this.roleM.listRolesByGroup(this.getCurrentGroupID());
            String[] rolesNames = new String[roles.size()];
            int i = 0;
            for (RoleModel role : roles) {
                rolesNames[i] = role.getRoleName();
                logger.debug((Object)("Geting roles from group: " + this.getASLsession().getGroupName()));
                logger.debug((Object)("Role " + ++i + " is --> " + role.getRoleName()));
            }
            return rolesNames;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve the available roles. An exception was thrown", (Throwable)e);
            return null;
        }
    }

    public ArrayList<UserInfo> getAllRegisteredUsers() {
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        try {
            List allUsers = this.userM.listUsers();
            logger.debug((Object)("Number of Portal users --> " + allUsers.size()));
            for (UserModel u : allUsers) {
                ArrayList<String> userRoles = new ArrayList<String>();
                List allRoles = this.roleM.listRolesByUser(this.userM.getUserId(u.getScreenName()));
                for (RoleModel r : allRoles) {
                    userRoles.add(r.getRoleName());
                }
                UserInfo user = new UserInfo(u.getScreenName(), u.getFullname(), u.getEmail(), userRoles, null, null);
                logger.debug((Object)"Portal's user information....");
                logger.debug((Object)("email --> " + u.getEmail() + ", username --> " + u.getScreenName()));
                userInfos.add(user);
            }
            logger.debug((Object)("Number of UserInfo users --> " + userInfos.size()));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get all registered users. An exception was thrown", (Throwable)e);
        }
        return userInfos;
    }

    public ArrayList<UserInfo> getUnregisteredUsersForVO() {
        try {
            ASLSession session = this.getASLsession();
            ArrayList sessionUnUsers = (ArrayList)session.getAttribute(SESSION_VOMS_UNREGISTERED_USERS + session.getScopeName());
            if (sessionUnUsers != null) {
                return sessionUnUsers;
            }
            ArrayList<UserInfo> unregisteredUsers = new ArrayList<UserInfo>();
            List unVomsUsers = this.userM.listUnregisteredUsersByGroup(this.getCurrentGroupID());
            for (UserModel u : unVomsUsers) {
                UserInfo myUser = new UserInfo(u.getScreenName(), u.getFullname(), u.getEmail(), null, null, null);
                unregisteredUsers.add(myUser);
            }
            logger.debug((Object)("The total unregistered users are:  " + unregisteredUsers.size()));
            Collections.sort(unregisteredUsers);
            session.setAttribute(SESSION_VOMS_UNREGISTERED_USERS + session.getScopeName(), unregisteredUsers);
            return unregisteredUsers;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve the unregistered users. An exception was thrown", (Throwable)e);
            return null;
        }
    }

    public ArrayList<UserInfo> getRegisteredUsersForaVO() {
        ArrayList<UserInfo> usersInfo = new ArrayList<UserInfo>();
        try {
            HashMap userInfoAndRoles = this.userM.listUsersAndRolesByGroup(this.getCurrentGroupID());
            if (userInfoAndRoles != null && userInfoAndRoles.size() > 0) {
                for (UserModel user : userInfoAndRoles.keySet()) {
                    ArrayList<String> userRs = new ArrayList<String>();
                    List userRoles = (List)userInfoAndRoles.get(user);
                    Iterator UserRoleIter = userRoles.iterator();
                    while (UserRoleIter.hasNext()) {
                        String roleName = ((RoleModel)UserRoleIter.next()).getRoleName();
                        userRs.add(roleName);
                    }
                    UserInfo myUser = new UserInfo(user.getScreenName(), user.getFullname(), user.getEmail(), userRs, null, null);
                    usersInfo.add(myUser);
                }
            }
            logger.debug((Object)("Number of registered users --> " + usersInfo.size()));
            return usersInfo;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the registered users of the current VO. An exception was thrown", (Throwable)e);
            return null;
        }
    }

    public Boolean removeUsersFromVO(String[] users) throws CurrentGroupRetrievalException, RolesRetrievalException, UserRemovalFailureException, UserInfoRetrievalException {
        Boolean ret = true;
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                logger.debug((Object)("Going to remove user from the current Group: " + this.getCurrentGroupID() + ". Username is: " + users[i]));
                try {
                    this.userM.dismissUserFromGroup(this.getCurrentGroupID(), this.userM.getUserId(users[i]));
                }
                catch (Exception e) {
                    throw new UserRemovalFailureException(e.getMessage(), e.getCause());
                }
                try {
                    this.updateSessionUnUsers(this.userM.getUser(this.userM.getUserId(users[i])), USER_REMOVED);
                    continue;
                }
                catch (Exception e) {
                    throw new UserInfoRetrievalException(e.getMessage(), e.getCause());
                }
            }
        }
        return ret;
    }

    public Boolean denyRequests(String[] users) throws CurrentGroupRetrievalException, RolesRetrievalException, UserRemovalFailureException, UserInfoRetrievalException {
        Boolean ret = true;
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                logger.debug((Object)("Going to remove user from the current Group: " + this.getCurrentGroupID() + ". Username is: " + users[i]));
                try {
                    this.userM.denyMembershipRequest(this.userM.getUserId(users[i]), this.getCurrentGroupID());
                    UserModel allUserInfo = this.userM.getUser(this.userM.getUserId(users[i]));
                    this.notifyUserForVORejection(users[i], allUserInfo.getEmail());
                    continue;
                }
                catch (Exception e) {
                    throw new UserRemovalFailureException(e.getMessage(), e.getCause());
                }
            }
        }
        return ret;
    }

    public Boolean addUsersToVO(ArrayList<String> users) throws RolesRetrievalException, UserInfoRetrievalException, CurrentGroupRetrievalException, GroupAssignmentException {
        Iterator<String> i$;
        Boolean ret = true;
        if (users != null && (i$ = users.iterator()).hasNext()) {
            String userToadd = i$.next();
            logger.debug((Object)("User to be added is --> " + userToadd));
            logger.debug((Object)"Going to add user as a member of the VO.........");
            try {
                try {
                    this.userM.assignUserToGroup(this.getCurrentGroupID(), this.userM.getUserId(userToadd));
                    logger.debug((Object)("User --> " + userToadd + " is added to the VO."));
                    UserModel allUserInfo = this.userM.getUser(this.userM.getUserId(userToadd));
                    this.updateSessionUnUsers(allUserInfo, USER_ADDED);
                    this.notifyUserForVORegistration(userToadd, allUserInfo.getEmail());
                }
                catch (UserManagementSystemException e) {
                    throw new GroupAssignmentException(e.getMessage(), e.getCause());
                }
                catch (GroupRetrievalFault e) {
                    throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
                }
                catch (UserManagementPortalException e) {
                    throw new GroupAssignmentException(e.getMessage(), e.getCause());
                }
            }
            catch (UserRetrievalFault e) {
                logger.error((Object)("Failed to add the user with username: " + userToadd + " to the current VO"), (Throwable)e);
                throw new UserInfoRetrievalException(e.getMessage(), e.getCause());
            }
        }
        return ret;
    }

    private ArrayList<String> getUserRolesForCurrentGroup(String username) throws RolesRetrievalException, CurrentGroupRetrievalException, UserInfoRetrievalException {
        List usersRolesByGroup;
        ArrayList<String> roles = new ArrayList<String>();
        try {
            usersRolesByGroup = this.roleM.listRolesByUserAndGroup(this.getCurrentGroupID(), this.userM.getUserId(username));
        }
        catch (UserManagementSystemException e) {
            throw new RolesRetrievalException(e.getMessage());
        }
        catch (UserRetrievalFault e) {
            throw new UserInfoRetrievalException(e.getMessage(), e.getCause());
        }
        catch (GroupRetrievalFault e) {
            throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
        }
        for (RoleModel userRole : usersRolesByGroup) {
            roles.add(userRole.getRoleName());
        }
        return roles;
    }

    private ArrayList<String> getVREManagersEmailsForCurrentGroup() {
        ArrayList<String> managersEmails = new ArrayList<String>();
        HashMap usersAndRoles = null;
        try {
            usersAndRoles = this.userM.listUsersAndRolesByGroup(this.getCurrentGroupID());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Set users = usersAndRoles.keySet();
        block2: for (UserModel usr : users) {
            List roles = (List)usersAndRoles.get(usr);
            for (int i = 0; i < roles.size(); ++i) {
                if (!((RoleModel)roles.get(i)).getRoleName().equals("VRE-Manager")) continue;
                managersEmails.add(usr.getEmail());
                logger.debug((Object)("VRE Manager email -> " + usr.getEmail()));
                continue block2;
            }
        }
        return managersEmails;
    }

    public Boolean addNewUsersToVO(ArrayList<String> users) throws CurrentGroupRetrievalException {
        logger.debug((Object)"Adding new users to the VO. Go check for their state.");
        Boolean ret = true;
        for (String user : users) {
            try {
                this.userM.assignUserToGroup(this.getCurrentGroupID(), this.userM.getUserId(user));
                this.updateSessionUnUsers(this.userM.getUser(this.userM.getUserId(user)), USER_ADDED);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to add the user to the current group ID.", (Throwable)e);
            }
        }
        return ret;
    }

    public String updateUserRoles(String username, String[][] rolesAndValues) {
        logger.debug((Object)("Going to update roles for the user --> " + username));
        for (int i = 0; i < rolesAndValues.length; ++i) {
            if (rolesAndValues[i][1].toLowerCase().equals("true")) {
                logger.debug((Object)("assign new role.... name --> " + rolesAndValues[i][0]));
                try {
                    this.roleM.assignRoleToUser(this.getCurrentGroupID(), this.roleM.getRoleId(rolesAndValues[i][0], this.getASLsession().getGroupName()), this.userM.getUserId(username));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to assign the new roles to the user. An exception was thrown.", (Throwable)e);
                    return "edit_failed";
                }
            }
            logger.debug((Object)("dismiss role.... name --> " + rolesAndValues[i][0]));
            try {
                this.roleM.dismissRoleFromUser(this.getCurrentGroupID(), this.roleM.getRoleId(rolesAndValues[i][0], this.getASLsession().getGroupName()), this.userM.getUserId(username));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to dismiss the roles from the user. An exception was thrown.", (Throwable)e);
                return "edit_failed";
            }
        }
        return "edit_ok";
    }

    public ArrayList<UserInfo> getUsersRequests() throws PendingUsersRetrievalException {
        try {
            String currentGroupID = this.getCurrentGroupID();
            List pendingVOMSUsers = this.userM.listPendingUsersByGroup(currentGroupID);
            ArrayList<UserInfo> pendingUsers = new ArrayList<UserInfo>();
            logger.debug((Object)("Users that have requested membership for the: " + currentGroupID + " are"));
            for (UserModel pendingUser : pendingVOMSUsers) {
                String username = pendingUser.getScreenName();
                String uCom = this.userM.getMembershipRequestComment(this.userM.getUserId(username), currentGroupID);
                UserInfo ui = new UserInfo(username, pendingUser.getFullname(), pendingUser.getEmail(), null, uCom, null);
                logger.debug((Object)username);
                pendingUsers.add(ui);
            }
            return pendingUsers;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve the pending users for the current VO/VRE. An exception was thrown", (Throwable)e);
            throw new PendingUsersRetrievalException(e.getMessage(), e.getCause());
        }
    }

    private void notifyUserForVORegistration(String username, String userEmail) throws UserInfoRetrievalException {
        String subject = "[PORTAL-iMarine] - Registration";
        String[] rec = new String[]{userEmail};
        HttpServletRequest request = this.getThreadLocalRequest();
        String portalURL = request.getScheme() + "://" + request.getServerName();
        portalURL = portalURL + (request.getServerPort() == 80 ? "" : ":" + request.getServerPort());
        try {
            GroupModel group = this.groupM.getGroup(this.getCurrentGroupID());
            Boolean isVO = this.groupM.isVO(group.getGroupId());
            UserModel managerUserInfo = this.userM.getUser(this.userM.getUserId(this.getASLsession().getUsername()));
            UserModel registeredUser = this.userM.getUser(this.userM.getUserId(username));
            UserRegistrationEmailMessageTemplate msgTemp = new UserRegistrationEmailMessageTemplate(registeredUser, managerUserInfo, group, isVO, portalURL);
            EmailNotification emailNot = new EmailNotification(null, rec, this.getVREManagersEmailsForCurrentGroup(), subject, msgTemp.createBodyMessage(), "to", false, false);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send the email to the user: " + username + " .Failed to get his email address. An exception was thrown."), (Throwable)e);
            throw new UserInfoRetrievalException(e.getMessage(), e.getCause());
        }
    }

    private void notifyUserForVORejection(String username, String userEmail) throws UserInfoRetrievalException {
        String subject = "[PORTAL-iMarine] - Registration";
        String[] rec = new String[]{userEmail};
        try {
            UserModel managerUserInfo = this.userM.getUser(this.userM.getUserId(this.getASLsession().getUsername()));
            String managerEmail = managerUserInfo.getEmail();
            UserRejectionEmailMessageTemplate msgTemp = new UserRejectionEmailMessageTemplate(this.getASLsession().getScopeName(), username, managerEmail);
            EmailNotification emailNot = new EmailNotification(null, rec, this.getVREManagersEmailsForCurrentGroup(), subject, msgTemp.createBodyMessage(), "to", false, false);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to send the email to the user: " + username + " .Failed to get his email address. An exception was thrown."), (Throwable)e);
            throw new UserInfoRetrievalException(e.getMessage(), e.getCause());
        }
    }

    public void sendEmailToRegisteredUsers(String subject, String body) throws CurrentGroupRetrievalException, RegisteredUsersRetrievalException, UserInfoRetrievalException {
        List registeredUsers = new ArrayList();
        try {
            registeredUsers = this.userM.listUsersByGroup(this.getCurrentGroupID());
            String[] recipients = new String[registeredUsers.size()];
            int i = 0;
            for (UserModel u : registeredUsers) {
                recipients[i] = u.getEmail();
                ++i;
            }
            EmailNotification emailNot = new EmailNotification(null, recipients, null, subject, body, "bcc", false, true);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the user's email. An exception was thrown", (Throwable)e);
            throw new UserInfoRetrievalException(e.getMessage(), e.getCause());
        }
    }

    public void sendEmailWithErrorToSupport(Throwable caught) {
        String subject = "[PORTAL-iMarine] Users Management Portlet - Error Notification";
        String[] rec = new String[]{"support_team@d4science.org"};
        try {
            ErrorNotificationEmailMessageTemplate msgTemp = new ErrorNotificationEmailMessageTemplate(caught, this.getASLsession().getUsername());
            EmailNotification emailNot = new EmailNotification(null, rec, null, subject, msgTemp.createBodyMessage(), "to", false, false);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to send the email to the support team.", (Throwable)e);
        }
    }

    public Integer getNumberOfUserThatReceiveNots() throws RegisteredUsersRetrievalException {
        List registeredUsers = new ArrayList();
        try {
            registeredUsers = this.userM.listUsersByGroup(this.getCurrentGroupID());
            int numOfUsers = registeredUsers.size();
            return numOfUsers;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get the number of registered users. An exception was thrown", (Throwable)e);
            throw new RegisteredUsersRetrievalException(e.getMessage(), e.getCause());
        }
    }

    private void updateSessionUnUsers(UserModel user, String status) throws RolesRetrievalException, CurrentGroupRetrievalException, UserInfoRetrievalException {
        ASLSession session = this.getASLsession();
        ArrayList sessionUnUsers = (ArrayList)session.getAttribute(SESSION_VOMS_UNREGISTERED_USERS + session.getScopeName());
        if (sessionUnUsers != null) {
            if (status.equals(USER_ADDED)) {
                logger.debug((Object)"A new user has been added to the VO. Going to update the session UnUsers attribute");
                int index = -1;
                int i = 0;
                for (UserInfo unUser : sessionUnUsers) {
                    if (unUser.getUsername().equals(user.getScreenName())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                sessionUnUsers.remove(index);
                logger.debug((Object)"User has been removed from the UnUsers session attribute");
            } else {
                logger.debug((Object)"A user has been removed from the VO. Going to update the session UnUsers attribute");
                UserInfo removedUser = new UserInfo(user.getScreenName(), user.getFullname(), user.getEmail(), this.getUserRolesForCurrentGroup(user.getScreenName()), null, null);
                sessionUnUsers.add(removedUser);
                Collections.sort(sessionUnUsers);
                logger.debug((Object)"User has been added to the UnUsers session attribute");
            }
            session.setAttribute(SESSION_VOMS_UNREGISTERED_USERS + session.getScopeName(), (Object)sessionUnUsers);
        }
    }
}

