/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.rolesmanagementportlet.gwt.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import org.gcube.portlets.user.gcubewidgets.client.popup.GCubeDialog;

public class ExceptionAlertWindow
extends GCubeDialog
implements ClickHandler {
    private String friendlyErrorMessage;

    public ExceptionAlertWindow(String userMessage, boolean autoHide) {
        super(autoHide);
        this.friendlyErrorMessage = userMessage;
        this.setText("Error Information");
    }

    public void onClick(ClickEvent event) {
        this.hide();
    }

    public void addDock(Throwable caught) {
        this.clear();
        Button emailBtn = new Button("[Email support team]");
        emailBtn.setStyleName("popup-button");
        String msg = caught.getMessage() != null ? caught.getMessage() : "An unexpected error occured. Please try again.";
        String cause = caught.getCause() != null ? (caught.getCause().getMessage() != null ? caught.getCause().getMessage() : "") : "";
        this.add((Widget)this.createDockForErrorMessage(msg, cause, emailBtn));
        this.setWidth("450px");
        emailBtn.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private FlexTable createDockForErrorMessage(String errorMsg, String errorCause, Button b) {
        FlexTable infoTable = new FlexTable();
        infoTable.setWidget(0, 0, (Widget)new HTML("<center><span style=\"color:red\">" + this.friendlyErrorMessage + "</span></center>"));
        infoTable.getFlexCellFormatter().setColSpan(0, 0, 4);
        infoTable.getFlexCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        infoTable.setWidget(1, 0, (Widget)new HTML("<b>Error message:</b>"));
        infoTable.setText(1, 1, errorMsg);
        infoTable.getFlexCellFormatter().setColSpan(1, 1, 3);
        infoTable.getFlexCellFormatter().setAlignment(1, 1, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_MIDDLE);
        infoTable.setWidget(2, 0, (Widget)new HTML("<br>"));
        infoTable.setWidget(3, 0, (Widget)new HTML("<b>Error cause:</b>"));
        infoTable.setText(3, 1, errorCause);
        infoTable.getFlexCellFormatter().setColSpan(3, 1, 3);
        infoTable.getFlexCellFormatter().setAlignment(3, 1, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_MIDDLE);
        infoTable.setWidget(4, 0, (Widget)new HTML("<br><br>"));
        infoTable.getFlexCellFormatter().setColSpan(4, 0, 4);
        infoTable.setWidget(5, 3, (Widget)b);
        infoTable.getFlexCellFormatter().setAlignment(5, 3, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_BOTTOM);
        infoTable.setCellSpacing(3);
        infoTable.setCellPadding(2);
        infoTable.setBorderWidth(0);
        infoTable.setWidth("450px");
        return infoTable;
    }
}

