/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.rolesmanagementportlet.gwt.server;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;

public class EmailNotification {
    private String emailSender;
    private String[] emailrecipients;
    private boolean notifySupportTeam = false;
    private static final String supportTeamEmailAddress = "support_team@d4science.org";
    private String recipientType;
    private String emailSubject;
    private String emailBody;
    private static Logger logger = Logger.getLogger(EmailNotification.class);

    public EmailNotification(String sender, String[] recipients, String subject, String body, String copyVisibility, boolean notifySupportTeam) {
        if (sender == null) {
            ScopeHelper.getSupportMainlingListAddr();
        } else {
            this.emailSender = sender;
        }
        this.emailrecipients = recipients;
        this.emailSubject = subject;
        this.emailBody = body;
        this.recipientType = copyVisibility;
        this.notifySupportTeam = notifySupportTeam;
    }

    public void sendEmail() {
        Properties props = System.getProperties();
        String mailServiceHost = "localhost";
        props.put("mail.smtp.host", mailServiceHost);
        String mailServicePort = "25";
        props.put("mail.smtp.port", mailServicePort);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(true);
        MimeMessage mimeMessage = new MimeMessage(session);
        try {
            InternetAddress from = new InternetAddress(this.emailSender);
            mimeMessage.setFrom((Address)from);
            if (this.notifySupportTeam) {
                InternetAddress address = new InternetAddress(supportTeamEmailAddress);
                mimeMessage.addRecipient(Message.RecipientType.TO, (Address)address);
            }
            Message.RecipientType recipientTypeValue = Message.RecipientType.BCC;
            if (this.recipientType.equals("to")) {
                recipientTypeValue = Message.RecipientType.TO;
            } else if (this.recipientType.equals("cc")) {
                recipientTypeValue = Message.RecipientType.CC;
            }
            for (int i = 0; i < this.emailrecipients.length; ++i) {
                InternetAddress address = new InternetAddress(this.emailrecipients[i]);
                mimeMessage.addRecipient(recipientTypeValue, (Address)address);
            }
            mimeMessage.setSubject(this.emailSubject);
            mimeMessage.setContent((Object)this.emailBody, "text/html");
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"Failed to send the email message.", (Throwable)e);
        }
    }
}

