/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.rolesmanagementportlet.gwt.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.client.exceptions.CurrentGroupRetrievalException;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.client.exceptions.RetrieveAllowedRolesException;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.client.exceptions.RoleCreationException;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.client.exceptions.RoleUpdateException;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.client.exceptions.RolesRetrievalException;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.client.interfaces.RolesManagementService;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.server.EmailNotification;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.server.ErrorNotificationEmailMessageTemplate;
import org.gcube.portlets.admin.rolesmanagementportlet.gwt.shared.RoleInfo;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementFileNotFoundException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementIOException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.model.RoleModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolesManagementServlet
extends RemoteServiceServlet
implements RolesManagementService {
    private static Logger logger = Logger.getLogger(RolesManagementServlet.class);
    private static final long serialVersionUID = 1L;
    private RoleManager rolesManager = new LiferayRoleManager();
    private GroupManager groupM = new LiferayGroupManager();

    public RolesManagementServlet() {
        try {
        }
        catch (ServletException e) {
            logger.error((Object)"Servlet failed to initialize");
        }
    }

    private ASLSession getASLsession() {
        HttpSession httpSession = this.getThreadLocalRequest().getSession();
        String username = httpSession.getAttribute("username").toString();
        ASLSession session = SessionManager.getInstance().getASLSession(httpSession.getId(), username);
        return session;
    }

    private String getCurrentGroupID() throws UserManagementSystemException, CurrentGroupRetrievalException {
        ASLSession session = this.getASLsession();
        logger.debug((Object)("The current group NAME is --> " + session.getGroupName()));
        logger.debug((Object)("The current groupID is --> " + session.getGroupId()));
        try {
            return this.groupM.getGroupId(session.getGroupName());
        }
        catch (GroupRetrievalFault e) {
            logger.error((Object)"Failed to get the current group's ID. An exception was thrown", (Throwable)e);
            throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
        }
    }

    public ArrayList<RoleInfo> listAllowedRoles() throws CurrentGroupRetrievalException, RetrieveAllowedRolesException {
        ArrayList<RoleInfo> allowedRoles = new ArrayList<RoleInfo>();
        try {
            HashMap aRoles = this.rolesManager.listAllowedRoles(this.getASLsession().getGroupName());
            for (String roleName : aRoles.keySet()) {
                String roleDesc = (String)aRoles.get(roleName);
                RoleInfo ri = new RoleInfo(roleName, roleDesc);
                allowedRoles.add(ri);
            }
        }
        catch (UserManagementSystemException e) {
            logger.error((Object)"Failed to list the allowed roles for the current VO/VRE. An exception was thrown", (Throwable)e);
            throw new RetrieveAllowedRolesException(e.getMessage(), e.getCause());
        }
        catch (GroupRetrievalFault e) {
            throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
        }
        catch (UserManagementFileNotFoundException e) {
            logger.error((Object)"Failed to list the allowed roles for the current VO/VRE. An exception was thrown", (Throwable)e);
            throw new RetrieveAllowedRolesException(e.getMessage(), e.getCause());
        }
        catch (UserManagementIOException e) {
            logger.error((Object)"Failed to list the allowed roles for the current VO/VRE. An exception was thrown", (Throwable)e);
            throw new RetrieveAllowedRolesException(e.getMessage(), e.getCause());
        }
        return allowedRoles;
    }

    public ArrayList<RoleInfo> getAvailableRoles() throws RolesRetrievalException, CurrentGroupRetrievalException {
        List roles;
        ArrayList<RoleInfo> allRoles = new ArrayList<RoleInfo>();
        try {
            roles = this.rolesManager.listRolesByGroup(this.getCurrentGroupID());
        }
        catch (UserManagementSystemException e) {
            throw new RolesRetrievalException(e.getMessage(), e.getCause());
        }
        catch (GroupRetrievalFault e) {
            throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
        }
        catch (UserManagementFileNotFoundException e) {
            throw new RolesRetrievalException(e.getMessage(), e.getCause());
        }
        catch (UserManagementIOException e) {
            throw new RolesRetrievalException(e.getMessage(), e.getCause());
        }
        if (roles != null && roles.size() > 0) {
            logger.debug((Object)"Printing the available roles for the current group...");
            for (int i = 0; i < roles.size(); ++i) {
                String roleName = ((RoleModel)roles.get(i)).getRoleName();
                String roleDesc = ((RoleModel)roles.get(i)).getDescription();
                logger.debug((Object)("Role Name --> " + roleName + " Role Desc --> " + roleDesc));
                RoleInfo ri = new RoleInfo(roleName, roleDesc);
                allRoles.add(ri);
            }
            return allRoles;
        }
        return null;
    }

    public Boolean deleteRoles(ArrayList<String> roleNames) {
        Boolean ret = true;
        int rolesDeleted = 0;
        logger.info((Object)"Deleting roles........");
        if (roleNames != null && roleNames.size() > 0) {
            for (String roleName : roleNames) {
                try {
                    this.rolesManager.deleteRole(roleName, this.getASLsession().getGroupName());
                    logger.info((Object)("Role with name --> " + roleName + " deleted."));
                    ++rolesDeleted;
                }
                catch (UserManagementSystemException e) {
                    logger.error((Object)("Failed to delete the role with id --> " + roleName));
                }
                catch (RoleRetrievalFault e) {
                    logger.error((Object)("Failed to delete the role with id --> " + roleName));
                }
            }
            if (rolesDeleted == roleNames.size()) {
                logger.info((Object)"All roles have been deleted");
            } else {
                logger.info((Object)"Some roles were not deleted due to unexpected errors. An exception was thrown");
                ret = false;
            }
        }
        return ret;
    }

    public Boolean createNewRole(String roleName, String roleDesc) throws RoleCreationException {
        Boolean ret = true;
        try {
            ret = this.rolesManager.createRole(roleName, roleDesc, this.getASLsession().getGroupName());
            logger.debug((Object)("The returned value of the createRole method is: " + ret));
            logger.info((Object)("A new role has been created with name --> " + roleName));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to create the role. An exception was thrown", (Throwable)e);
            throw new RoleCreationException(e.getMessage(), e.getCause());
        }
        return ret;
    }

    public Boolean updateRole(String roleName, String newRoleName, String newRoleDescription) throws RoleUpdateException, RolesRetrievalException, CurrentGroupRetrievalException {
        Boolean ret = true;
        try {
            logger.debug((Object)("Trying to update role with initial name --> " + roleName));
            logger.debug((Object)("new name: " + newRoleName));
            logger.debug((Object)("new Desc: " + newRoleDescription));
            this.rolesManager.updateRole(roleName, newRoleName, newRoleDescription, this.getASLsession().getGroupName());
            return ret;
        }
        catch (UserManagementSystemException e) {
            logger.error((Object)"Failed to update the Role. An exception was thrown", (Throwable)e);
            throw new RoleUpdateException(e.getMessage(), e.getCause());
        }
        catch (GroupRetrievalFault e) {
            logger.error((Object)"Failed to get the current group's ID. An exception was thrown", (Throwable)e);
            throw new CurrentGroupRetrievalException(e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            logger.error((Object)"Failed to retrieve the role that needs update", (Throwable)e);
            throw new RolesRetrievalException(e.getMessage(), e.getCause());
        }
    }

    public void sendEmailWithErrorToSupport(Throwable caught) {
        String subject = "[PORTAL-iMarine] Roles Management Portlet - Error Notification";
        String[] rec = new String[]{"support_team@d4science.org"};
        try {
            ErrorNotificationEmailMessageTemplate msgTemp = new ErrorNotificationEmailMessageTemplate(caught, this.getASLsession().getUsername());
            EmailNotification emailNot = new EmailNotification(null, rec, subject, msgTemp.createBodyMessage(), "to", false);
            emailNot.sendEmail();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to send the email to the support team.", (Throwable)e);
        }
    }
}

