package org.gcube.portal.wssynclibrary.shared.thredds;

import java.io.Serializable;

import org.gcube.usecases.ws.thredds.model.StepReport;

/**
 * The Class ThSyncElementInfo.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         May 13, 2021
 */
public class ThSyncElementInfo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 6248465200945019743L;

	private Sync_Status syncStatus;

	private StepReport.Status lastSynchronizationStatus;

	private String lastupdateTime;

	/**
	 * Instantiates a new th sync element info.
	 */
	public ThSyncElementInfo() {

	}

	/**
	 * Instantiates a new th sync element info.
	 *
	 * @param syncStatus the sync status
	 */
	public ThSyncElementInfo(Sync_Status syncStatus) {
		super();
		this.syncStatus = syncStatus;
	}

	/**
	 * Gets the sync status.
	 *
	 * @return the sync status
	 */
	public Sync_Status getSyncStatus() {
		return syncStatus;
	}

	/**
	 * Sets the sync status.
	 *
	 * @param syncStatus the new sync status
	 */
	public void setSyncStatus(Sync_Status syncStatus) {
		this.syncStatus = syncStatus;
	}

	/**
	 * Gets the last synchronization status.
	 *
	 * @return the last synchronization status
	 */
	public StepReport.Status getLastSynchronizationStatus() {
		return lastSynchronizationStatus;
	}

	/**
	 * Sets the last synchronization status.
	 *
	 * @param lastSynchronizationStatus the new last synchronization status
	 */
	public void setLastSynchronizationStatus(StepReport.Status lastSynchronizationStatus) {
		this.lastSynchronizationStatus = lastSynchronizationStatus;
	}

	/**
	 * Gets the lastupdate time.
	 *
	 * @return the lastupdate time
	 */
	public String getLastupdateTime() {
		return lastupdateTime;
	}

	/**
	 * Sets the lastupdate time.
	 *
	 * @param lastupdateTime the new lastupdate time
	 */
	public void setLastupdateTime(String lastupdateTime) {
		this.lastupdateTime = lastupdateTime;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ThSyncElementInfo [syncStatus=");
		builder.append(syncStatus);
		builder.append("]");
		return builder.toString();
	}

}
