/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.local;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.gcube.portlets.user.warmanagementwidget.server.csv.ImportSession;
import org.gcube.portlets.user.warmanagementwidget.server.csv.ImportSessionManager;
import org.gcube.portlets.user.warmanagementwidget.server.csv.ImportStatus;
import org.gcube.portlets.user.warmanagementwidget.server.util.Util;


/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class WarUploadServlet extends HttpServlet {

	protected static Logger logger = Logger.getLogger(WarUploadServlet.class);

	/**
	 * 
	 */
	private static final long serialVersionUID = -4197748678713054285L;

	@SuppressWarnings("rawtypes")
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

		logger.trace("Post");

		String sessionId = (String) request.getParameter("sessionId");

		logger.trace("sessionId: "+sessionId);

		FileItemFactory factory = new DiskFileItemFactory();
		ServletFileUpload upload = new ServletFileUpload(factory);

		ImportSession importSession = ImportSessionManager.getInstance().getSession(sessionId);

		if (importSession == null)
		{
			logger.error("Error getting the upload session, no session found for id "+sessionId);
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "ERROR-Error getting the user session, no session found for id "+sessionId);
			return ;
		}

		importSession.setStatus(ImportStatus.UPLOADING);
		
		UploadListener uploadListener = new UploadListener(importSession.getUploadProgress());
		upload.setProgressListener(uploadListener);

		FileItem uploadItem = null;

		try {
			List items = upload.parseRequest(request);
			Iterator it = items.iterator();
			while (it.hasNext()) {
				FileItem item = (FileItem) it.next();
				if (!item.isFormField()	&& "uploadFormElement".equals(item.getFieldName())) {
					uploadItem = item;
				}
			}
		} catch (FileUploadException e) {
			importSession.setUploadFailed("An error occured elaborating the HTTP request", Util.exceptionDetailMessage(e));
			logger.error("Error processing request in upload servlet", e);
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "ERROR-Error during request processing: "+e.getMessage());
			return;
		}

		if (uploadItem == null) {
			importSession.setUploadFailed("An error occured elaborating the HTTP request: No file found", "Upload request without file");
			logger.error("Error processing request in upload servlet: No file to upload");
			response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "No file to upload");
			return;
		}

		String contentType = uploadItem.getContentType();

		logger.trace("ContentType: "+contentType);

		//TODO check is a war, check is a zip?

		File warTmp = File.createTempFile("import", "war");
		warTmp.deleteOnExit();

		importSession.setWarFile(warTmp);

		importSession.setWarName(uploadItem.getName());
		IOUtils.copy(uploadItem.getInputStream(), new FileOutputStream(warTmp));
		logger.trace("upload completed");

		logger.trace("changing state");
		importSession.setUploadComplete();

		uploadItem.delete();

		response.getWriter().write("OK");
	}

}
