/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.util;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class Util {
	
	protected static Logger logger = Logger.getLogger(Util.class);
	
	static {
		logger.setLevel(Level.ALL);
	}
	
	private static final String VERSION_SEPARATOR = ".";
	
	public static String getVersion(WarProfile profile)
	{
		return getVersion(profile.getMajorVersion(), profile.getMinorVersion(), profile.getAgeVersion());
	}
	
	public static String getVersion(int majorVersionNumber, int minorVersionNumber, int ageVersionNumber)
	{
		StringBuilder version = new StringBuilder();
		version.append(majorVersionNumber);
		version.append(VERSION_SEPARATOR);
		version.append(minorVersionNumber);
		version.append(VERSION_SEPARATOR);
		version.append(ageVersionNumber);
		return version.toString();
	}
	
	public static String exceptionDetailMessage(Throwable t)
	{
		StringWriter out = new StringWriter();
		PrintWriter writer = new PrintWriter(out);
		t.printStackTrace(writer);
		
		StringBuilder message = new StringBuilder("Error message:\n");
		message.append(out.toString());
		
		return message.toString();
	}
	
	
	public static String reportDetailMessage(Throwable t, String report)
	{
		String xml = tryToFormatAndEscape(report);
		StringBuilder message = new StringBuilder();
		String exceptionMessage = exceptionDetailMessage(t);
		message.append(exceptionMessage);
		message.append("\nReport:\n");
		message.append(xml);
		return message.toString();
	}
	
	public static String reportDetailMessage(String report)
	{
		String xml = tryToFormatAndEscape(report);
		StringBuilder message = new StringBuilder("Report:\n");
		message.append(xml);
		return message.toString();
	}

	public static String tryToFormatAndEscape(String xml)
	{
		String formattedXML = xml;
		try {
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			InputSource is = new InputSource(new StringReader(xml));
			Document doc =  db.parse(is);
			DOMImplementationLS impl = (DOMImplementationLS)findDomImpl();
			LSSerializer writer = impl.createLSSerializer();
			DOMConfiguration configuration = writer.getDomConfig();
			if (configuration.canSetParameter("format-pretty-print", Boolean.TRUE)) configuration.setParameter("format-pretty-print", Boolean.TRUE);
			if (configuration.canSetParameter("format-pretty-print", "yes")) configuration.setParameter("format-pretty-print", "yes");
			
			LSOutput output = impl.createLSOutput();
			StringWriter out = new StringWriter();
			output.setCharacterStream(out);
			writer.write(doc, output);

			formattedXML = out.toString();
		} catch (Exception e)
		{
			logger.warn("An error occured formatting the report", e);
		}
		
		return StringEscapeUtils.escapeHtml(formattedXML);
	}
	
	protected static DOMImplementation findDomImpl() throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException
	{
		logger.trace("Retrieving the dom impl");
		DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
		DOMImplementationList impList = registry.getDOMImplementationList("");
		logger.trace("found "+impList.getLength()+" impls");
		
		for (int i = 0; i<impList.getLength(); i++) {
			DOMImplementation domImplementation = impList.item(i);
			logger.trace("Checking "+domImplementation);
			if (domImplementation instanceof DOMImplementationLS) {
				DOMImplementationLS impl = (DOMImplementationLS)domImplementation;
				LSSerializer writer = impl.createLSSerializer();
				DOMConfiguration configuration = writer.getDomConfig();
				
				if (configuration.canSetParameter("format-pretty-print", Boolean.TRUE)) return domImplementation; 
				DOMStringList parameters = configuration.getParameterNames();
				for (int l = 0; l<parameters.getLength(); l++) {
					if (parameters.item(l).equals("format-pretty-print")) return domImplementation;
				}
			}
		}
		
		return registry.getDOMImplementation("LS");
	}


}
