/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.management;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class SAPublisher {

	protected static SAPublisher instance;
	
	public static SAPublisher getInstance()
	{
		if (instance == null) instance = new SAPublisher();
		return instance;
	}
	
	protected Map<String, File> publishedSAs = new LinkedHashMap<String, File>();
	
	public void publishSA(String sessionId, File saFile)
	{
		publishedSAs.put(sessionId, saFile);
	}
	
	public File getSAFile(String sessionId)
	{
		return publishedSAs.get(sessionId);
	}
	
	public void deleteSAFile(String sessionId)
	{
		File file = getSAFile(sessionId);
		if (file!=null) file.delete();
	}
	
	
}
