/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.server.management;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

import org.apache.log4j.Logger;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBEServiceQuery;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.progress.OperationProgress;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class GCubeServiceInterface implements ServiceInterface {

	protected Logger logger = Logger.getLogger(GCubeServiceInterface.class);

	protected Executor executor = Executors.newFixedThreadPool(5);

	protected ISClient client;

	protected ISClient getClient() throws Exception
	{
		if (client == null) client = GHNContext.getImplementation(ISClient.class);

		return client;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public WarProfile getProfile(GCUBEScope scope, GCUBESecurityManager securityManager, String warId) throws Exception {

		ISClient client = getClient();

		GCUBEServiceQuery query = client.getQuery(GCUBEServiceQuery.class);
		query.addAtomicConditions(new AtomicCondition("/Profile/Class", "WebApp"));
		query.addAtomicConditions(new AtomicCondition("/ID", warId));

		List<GCUBEService> services = client.execute(query, scope);

		if (services.size()!=1) {
			logger.error("Service profile not found or more than one found: "+services.size());
			throw new Exception("War Profile not found for id "+warId);
		}

		GCUBEService service = services.get(0);

		Software software = (Software)service.getPackages().get(0);
		String version = software.getVersion();
		System.out.println("VERSION: "+version);
		String[] versionTokens = version.split("\\.");
		System.out.println("TOKENS "+Arrays.toString(versionTokens));
		int majorVersion = Integer.parseInt(versionTokens[0]);
		int minorVersion = (versionTokens.length>1)?Integer.parseInt(versionTokens[1]):0;
		int ageVersion = (versionTokens.length>2)?Integer.parseInt(versionTokens[2]):0;


		WarProfile profile = new WarProfile(service.getID(), "", service.getServiceName(), service.getDescription(), software.getName(), software.getDescription(), 
				majorVersion, minorVersion, ageVersion, new ArrayList<String>(software.getEntrypoints()));

		return profile;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public OperationProgress uploadWar(String user, GCUBEScope scope, GCUBESecurityManager securityManager, final String sessionId, final WarProfile profile, final File warFile, String baseUrl) throws Exception {
		logger.info("createWar profile: "+profile+" warFile: "+warFile);

		OperationProgress operationProgress = new OperationProgress();
		GCubeWarUploader uploader = new GCubeWarUploader(operationProgress, user, scope, securityManager, sessionId, warFile, profile, baseUrl);
		executor.execute(uploader);

		return operationProgress;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public OperationProgress deleteWar(String user, GCUBEScope scope, GCUBESecurityManager securityManager, String warId) throws Exception {
		logger.info("deleteWar warId: "+warId);

		OperationProgress operationProgress = new OperationProgress();
		GCubeWarDeleter deleter = new GCubeWarDeleter(operationProgress, user, scope, securityManager, warId);
		executor.execute(deleter);

		return operationProgress;
	}



}
