/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload;

import java.util.ArrayList;

import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.rpc.WarManagementService;
import org.gcube.portlets.user.warmanagementwidget.client.upload.source.WarSource;
import org.gcube.portlets.user.warmanagementwidget.client.upload.source.local.LocalSource;
import org.gcube.portlets.user.warmanagementwidget.client.wizard.WizardCard;
import org.gcube.portlets.user.warmanagementwidget.client.wizard.WizardWindow;

import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.event.WindowListener;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.client.Scheduler.ScheduledCommand;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * The war import window.
 * @author Federico De Faveri defaveri@isti.cnr.it
 */
public class WarUploadWizard extends WizardWindow {

	protected WarImportSession importSession;
	protected String warId;

	public WarUploadWizard()
	{
		this(null);
	}
	
	public WarUploadWizard(final String warId)
	{
		super("WAR upload wizard");
		setWidth(600);
		setHeight(600);
		
		setMinHeight(400);
		setMinWidth(400);
		
		this.warId = warId;
		
		ArrayList<WarSource> sources = new ArrayList<WarSource>();
		sources.add(new LocalSource());

		importSession = new WarImportSession();

		WizardCard sourceSelectionCard = new SourceSelectionCard(importSession, sources);
		addCard(sourceSelectionCard);
		
		WizardCard uploadCard = new UploadCard(importSession, sources);
		addCard(uploadCard);

		WizardCard warConfiguration = new WarConfigCard(importSession);
		addCard(warConfiguration);
		
		WizardCard warCreation = new WarStoreCard(importSession);
		addCard(warCreation);
		
		addWindowListener(new WindowListener(){

			@Override
			public void windowShow(WindowEvent we) {
				mask("Initializing...");
				
				Scheduler.get().scheduleDeferred(new ScheduledCommand() {
					
					@Override
					public void execute() {
						loadSessionAndWarProfile();
					}
				});
				
			}
		});
	}
	
	
	protected void loadSessionAndWarProfile()
	{
		WarManagementService.Util.getInstance().createWarSessionId(new AsyncCallback<String>() {
			
			@Override
			public void onSuccess(String result) {
				importSession.setId(result);
				GWT.log("Retrieved sessionId "+result);
				
				if (warId!=null) {
					GWT.log("Retrieving profile for warId: "+warId);
					WarManagementService.Util.getInstance().getWarProfile(warId, new AsyncCallback<WarProfile>() {

						@Override
						public void onFailure(Throwable caught) {
							showErrorAndHide("Error retriving War profile for id "+warId, "An error occurred retrieving the War profile ("+caught.getMessage()+").");
						}

						@Override
						public void onSuccess(WarProfile result) {
							importSession.setProfile(result);
							unmask();
						}
					});
				} else unmask();
			}
			
			@Override
			public void onFailure(Throwable caught) {
				showErrorAndHide("Error initializing the wizard", "An error occurred initializing the wizard ("+caught.getMessage()+").");
			}
		});
	}
}
