/**
 * 
 */
package org.gcube.portlets.user.warmanagementwidget.client.upload;

import java.io.Serializable;

import org.gcube.portlets.user.warmanagementwidget.client.data.WarProfile;
import org.gcube.portlets.user.warmanagementwidget.client.upload.source.WarSource;

/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 *
 */
public class WarImportSession implements Serializable {
	
	private static final long serialVersionUID = 8335993560069738899L;

	protected String id;
	protected WizardState state;
	protected WarSource source;
	protected WarProfile profile;		
	
	
	/**
	 * Creates a new import session.
	 */
	public WarImportSession()
	{
		state = WizardState.SOURCE_SELECTION;
	}
	
	/**
	 * Returns the session id.
	 * @return the session id.
	 */
	public String getId() {
		return id;
	}

	/**
	 * Set the session id.
	 * @param id the session id.
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * Returns the current {@link WarSource}.
	 * @return the csvSource.
	 */
	public WarSource getSource() {
		return source;
	}

	/**
	 * Sets the {@link WarSource}.
	 * @param source the csvSource to set
	 */
	public void setSource(WarSource source) {
		this.source = source;
	}

	/**
	 * @return the profile
	 */
	public WarProfile getProfile() {
		return profile;
	}

	/**
	 * @param profile the profile to set
	 */
	public void setProfile(WarProfile profile) {
		this.profile = profile;
	}

}
