/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.threadlocalexec;

import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.portal.oidc.lr62.JWTTokenUtil;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.gcube.portal.oidc.lr62.OIDCTokenCacheProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartGearsPortalValve
extends ValveBase {
    private static final Logger _log = LoggerFactory.getLogger(SmartGearsPortalValve.class);
    private static final String DEFAULT_ROLE = "OrganizationMember";
    private static final String LIFERAY_POLLER_CONTEXT = "poller/receive";

    public void invoke(Request req, Response resp) throws IOException, ServletException {
        SecurityTokenProvider.instance.reset();
        ScopeProvider.instance.reset();
        AuthorizationProvider.instance.reset();
        UmaJWTProvider.instance.reset();
        if (req instanceof HttpServletRequest) {
            Request request = req;
            if (!req.getRequestURL().toString().endsWith(LIFERAY_POLLER_CONTEXT)) {
                PortalContext context = PortalContext.getConfiguration();
                String scope = context.getCurrentScope((HttpServletRequest)request);
                String username = SmartGearsPortalValve.getCurrentUsername((HttpServletRequest)request);
                if (scope != null && username != null && SmartGearsPortalValve.validateContext(scope)) {
                    String userToken = null;
                    try {
                        ScopeProvider.instance.set(scope);
                        userToken = Constants.authorizationService().resolveTokenByUserAndContext(username, scope);
                        SecurityTokenProvider.instance.set(userToken);
                    }
                    catch (ObjectNotFound ex) {
                        userToken = SmartGearsPortalValve.generateAuthorizationToken(username, scope);
                        SecurityTokenProvider.instance.set(userToken);
                        _log.debug("generateAuthorizationToken OK for " + username + " in scope " + scope);
                    }
                    catch (Exception e) {
                        _log.error("Something went wrong in generating token for " + username + " in scope " + scope);
                        e.printStackTrace();
                    }
                    this.checkUMATicket((HttpServletRequest)request, scope);
                }
            }
        }
        this.getNext().invoke(req, resp);
    }

    private void checkUMATicket(HttpServletRequest request, String scope) {
        JWTToken umaToken;
        HttpSession session = request.getSession(false);
        if (session == null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Session is null");
            }
            return;
        }
        if (_log.isTraceEnabled()) {
            _log.trace("Session details: id=" + session.getId() + ", instance=" + session);
        }
        String urlEncodedScope = null;
        try {
            urlEncodedScope = URLEncoder.encode(scope, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            _log.error("Cannot URL encode scope", (Throwable)e);
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("URL encoded scope is: " + urlEncodedScope);
            _log.debug("Getting UMA token from session");
        }
        if ((umaToken = JWTTokenUtil.getUMAFromSession((HttpSession)session)) == null) {
            User user;
            if (_log.isDebugEnabled()) {
                _log.debug("UMA token not found in session");
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Getting current user");
            }
            if ((user = SmartGearsPortalValve.getCurrentUser(request)) == null) {
                _log.error("Current user not found, cannot continue");
                return;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Trying to get UMA token from cache proxy");
            }
            if ((umaToken = OIDCTokenCacheProxy.getInstance().getUMAToken(user, session)) == null || !umaToken.getAud().contains(urlEncodedScope)) {
                JWTToken authToken;
                if (umaToken == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("UMA token is null. Getting new one...");
                    }
                } else {
                    _log.info("UMA token for another scope (" + umaToken.getAud() + "). Getting new one for scope: " + urlEncodedScope);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug("Getting OIDC token from session");
                }
                if ((authToken = JWTTokenUtil.getOIDCFromSession((HttpSession)session)) == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug("OIDC token not found in session. Trying to get it from cache proxy");
                    }
                    if ((authToken = this.getOIDCTokeFromProxyAndSetInSession(user, request, session)) == null) {
                        _log.error("OIDC token is null, cannot continue");
                        return;
                    }
                    if (_log.isDebugEnabled()) {
                        _log.debug("OIDC token found in cache proxy");
                    }
                }
                _log.info("Getting UMA token from OIDC endpoint for scope: " + urlEncodedScope);
                LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration((HttpServletRequest)request);
                try {
                    umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)configuration.getTokenURL(), (String)authToken.getAsBearer(), (String)urlEncodedScope, null);
                }
                catch (Exception e) {
                    _log.error("Getting UMA token from server", (Throwable)e);
                    return;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug("Setting UMA token in cache proxy");
                }
                OIDCTokenCacheProxy.getInstance().setRPTToken(user, session, umaToken);
                if (_log.isDebugEnabled()) {
                    _log.debug("Setting UMA token in session");
                }
                JWTTokenUtil.putUMAInSession((JWTToken)umaToken, (HttpSession)session);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Setting UMA token in UMA JWT provider");
        }
        UmaJWTProvider.instance.set(umaToken.getRaw());
    }

    private JWTToken getOIDCTokeFromProxyAndSetInSession(User user, HttpServletRequest request, HttpSession session) {
        JWTToken token = OIDCTokenCacheProxy.getInstance().getOIDCToken(user, session);
        if (token == null) {
            _log.warn("OIDC token is null also in cache proxy!");
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug("Setting OIDC token took from cache proxy in session");
            }
            JWTTokenUtil.putOIDCInSession((JWTToken)token, (HttpSession)session);
        }
        return token;
    }

    private static boolean validateContext(String context) {
        String separator = "/";
        if (!context.matches("\\S+")) {
            return false;
        }
        String[] components = context.split(separator);
        return components.length >= 2 && components.length <= 4;
    }

    private static String generateAuthorizationToken(String username, String scope) {
        String token;
        ArrayList<String> userRoles = new ArrayList<String>();
        userRoles.add(DEFAULT_ROLE);
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(username, userRoles), scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return token;
    }

    public static String getCurrentUsername(HttpServletRequest httpServletRequest) {
        User user = SmartGearsPortalValve.getCurrentUser(httpServletRequest);
        return user != null ? user.getScreenName() : null;
    }

    public static User getCurrentUser(HttpServletRequest httpServletRequest) {
        String userIdNo = httpServletRequest.getHeader("gcube-userId");
        if (userIdNo != null && userIdNo.compareTo("undefined") != 0) {
            long userId = -1L;
            try {
                userId = Long.parseLong(userIdNo);
                return UserLocalServiceUtil.getUser((long)userId);
            }
            catch (NumberFormatException e) {
                _log.error("The userId is not a number -> " + userIdNo);
                return null;
            }
            catch (Exception e) {
                _log.error("The userId does not belong to any user -> " + userIdNo);
                return null;
            }
        }
        return null;
    }
}

