package org.gcube.portal.snl.model.input;

import java.io.Serializable;
import java.util.ArrayList;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Generic input bean for methods that allow to write messages
 * @author Costantino Perciante at ISTI-CNR
 */
@JsonIgnoreProperties(ignoreUnknown = true) // ignore in serialization/deserialization
public class MessageInputBean implements Serializable {

	private static final long serialVersionUID = -1317811686036127456L;

	/*@JsonProperty("sender")
	@ApiModelProperty( 
			example="andrea.rossi", 
			required=false, 
			hidden=true, // do not show this information
			value="The sender of the message. If not specified is the gcube-token's owner")
	private String sender;*/

	@JsonProperty("body")
	@NotNull(message="body cannot be missing")
	@Size(min=1, message="body cannot be empty")
	private String body;

	@JsonProperty("subject")
	@NotNull(message="subject cannot be missing")
	@Size(min=1, message="subject cannot be empty")
	private String subject;

	@JsonProperty("recipients")
	@NotNull(message="recipients cannot be missing")
	@Size(min=1, message="at least a recipient is needed")
	@Valid // validate recursively
	private ArrayList<Recipient> recipients;

	public MessageInputBean() {
		super();
	}

	public MessageInputBean(String sender, String body, String subject,
			ArrayList<Recipient> recipients) {
		super();
		//this.sender = sender;
		this.body = body;
		this.subject = subject;
		this.recipients = recipients;
	}

	public String getBody() {
		return body;
	}
	public void setBody(String body) {
		this.body = body;
	}
	public String getSubject() {
		return subject;
	}
	public void setSubject(String subject) {
		this.subject = subject;
	}
	public ArrayList<Recipient> getRecipients() {
		return recipients;
	}
	public void setRecipients(ArrayList<Recipient> recipients) {
		this.recipients = recipients;
	}

	@Override
	public String toString() {
		return "MessageInputBean ["
				+ (body != null ? "body=" + body + ", " : "")
				+ (subject != null ? "subject=" + subject + ", " : "")
				+ (recipients != null ? "recipients=" + recipients : "") + "]";
	}

}
