/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.secrets.Secret;
import org.gcube.portal.databook.server.CassandraClusterConnection;
import org.gcube.portal.databook.shared.ex.TooManyRunningClustersException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningCluster
implements Serializable {
    private static final String GCubePortalConstants_INFRASTRUCTURE_NAME = "infrastructure";
    private static final String PortalContext_CONFIGURATION_FOLDER = "conf";
    private static final String PortalContext_INFRA_PROPERTY_FILENAME = "infrastructure.properties";
    private static final Logger _log = LoggerFactory.getLogger(RunningCluster.class);
    private static final String HOST_PROPERTY = "host";
    private static final String HOST_PORT_PROPERTY = "port";
    private static final String DATACENTER_NAME_PROPERTY = "datacenter";
    private static final String KEY_SPACE_NAME_PROPERTY = "keyspace";
    private static final String RUNTIME_RESOURCE_NAME = "SocialDB";
    private static final String PLATFORM_NAME = "Cassandra";
    private static final String DEFAULT_CONFIGURATION = "/org/gcube/portal/databook/server/resources/databook.properties";
    private static RunningCluster singleton;
    private String host;
    private String datacenterName;
    private String keyspaceName;

    public static synchronized RunningCluster getInstance(String infrastructureName) {
        if (singleton == null) {
            singleton = new RunningCluster(infrastructureName);
        }
        return singleton;
    }

    private RunningCluster(String infrastructureName) {
        try {
            List<ServiceEndpoint> resources = this.getConfigurationFromIS(infrastructureName);
            if (resources.size() > 1) {
                _log.error("Too many Runtime Resource having name SocialDB in this scope ");
                throw new TooManyRunningClustersException("There exist more than 1 Runtime Resource in this scope having name SocialDB and Platform Cassandra. Only one allowed per infrasrtucture.");
            }
            if (resources.size() == 0) {
                _log.error("There is no Runtime Resource having name SocialDB and Platform Cassandra in this scope. Using default configuration properties: /org/gcube/portal/databook/server/resources/databook.properties");
                this.loadDefaultConfiguration();
            } else {
                for (ServiceEndpoint res : resources) {
                    ServiceEndpoint.AccessPoint found = (ServiceEndpoint.AccessPoint)res.profile().accessPoints().iterator().next();
                    this.host = found.address();
                    this.datacenterName = found.description();
                    this.keyspaceName = found.name();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private List<ServiceEndpoint> getConfigurationFromIS(String infrastructureName) throws Throwable {
        _log.debug("getConfigurationFromIS infrastructureName=" + infrastructureName);
        Object scope = "/";
        if (infrastructureName != null && !infrastructureName.isEmpty()) {
            scope = (String)scope + infrastructureName;
        } else {
            scope = (String)scope + this.readInfrastructureName();
            _log.debug("infrastrucute name is null, setting root scope=" + (String)scope);
        }
        Secret infraSecret = ContextProvider.get().container().authorizationProvider().getSecretForContext((String)scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'SocialDB'");
        query.addCondition("$resource/Profile/Platform/Name/text() eq 'Cassandra'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = (List)AuthorizedTasks.executeSafely(() -> RunningCluster.lambda$getConfigurationFromIS$0(client, (SimpleQuery)query), (Secret)infraSecret);
        return toReturn;
    }

    private String readInfrastructureName() {
        Properties props = new Properties();
        try {
            StringBuilder sb = new StringBuilder(RunningCluster.getCatalinaHome());
            sb.append(File.separator).append(PortalContext_CONFIGURATION_FOLDER).append(File.separator).append(PortalContext_INFRA_PROPERTY_FILENAME);
            String propertyfile = sb.toString();
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            return props.getProperty(GCubePortalConstants_INFRASTRUCTURE_NAME);
        }
        catch (IOException e) {
            _log.error("infrastructure.properties file not found under $CATALINA_HOME/conf/ dir, setting default infrastructure Name gcube");
            return "gcube";
        }
    }

    private void loadDefaultConfiguration() {
        Properties props = new Properties();
        try {
            props.load(CassandraClusterConnection.class.getResourceAsStream(DEFAULT_CONFIGURATION));
            this.host = props.getProperty(HOST_PROPERTY) + ":" + props.getProperty(HOST_PORT_PROPERTY);
            this.datacenterName = props.getProperty(DATACENTER_NAME_PROPERTY);
            this.keyspaceName = props.getProperty(KEY_SPACE_NAME_PROPERTY);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    public String toString() {
        return "RunningCluster [host=" + this.host + ", datacenterName=" + this.datacenterName + ", keyspaceName=" + this.keyspaceName + "]";
    }

    private static String getCatalinaHome() {
        return System.getenv("CATALINA_HOME").endsWith("/") ? System.getenv("CATALINA_HOME") : System.getenv("CATALINA_HOME") + "/";
    }

    public void setDatacenterName(String datacenterName) {
        this.datacenterName = datacenterName;
    }

    public String getDatacenterName() {
        return this.datacenterName;
    }

    public List<InetSocketAddress> getHosts() {
        String[] ips;
        ArrayList<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
        for (String ip : ips = this.host.split(", ")) {
            String[] ip_port = ip.split(":");
            hosts.add(new InetSocketAddress(ip_port[0], Integer.parseInt(ip_port[1])));
        }
        return hosts;
    }

    private static /* synthetic */ List lambda$getConfigurationFromIS$0(DiscoveryClient client, SimpleQuery query) throws Exception {
        return client.submit((Query)query);
    }
}

