/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang.NullArgumentException;
import org.gcube.portal.databook.server.CassandraClusterConnection;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteOperationResult;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.PostType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.RangeFeeds;
import org.gcube.portal.databook.shared.RangePosts;
import org.gcube.portal.databook.shared.ex.ColumnNameNotFoundException;
import org.gcube.portal.databook.shared.ex.CommentIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.databook.shared.ex.FeedTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteIDNotFoundException;
import org.gcube.portal.databook.shared.ex.InviteStatusNotFoundException;
import org.gcube.portal.databook.shared.ex.LikeIDNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationChannelTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationIDNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.PrivacyLevelTypeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBCassandraAstyanaxImpl
implements DatabookStore {
    private static final Logger _log = LoggerFactory.getLogger(DBCassandraAstyanaxImpl.class);
    private CassandraClusterConnection conn;

    protected CassandraClusterConnection getConnection() {
        return this.conn;
    }

    protected DBCassandraAstyanaxImpl(boolean dropSchema) {
        try {
            this.conn = new CassandraClusterConnection(dropSchema);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DBCassandraAstyanaxImpl() {
        try {
            this.conn = new CassandraClusterConnection(false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DBCassandraAstyanaxImpl(String infrastructureName) {
        try {
            this.conn = new CassandraClusterConnection(false, infrastructureName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean existRecordbyId(CqlSession session, String id, String tableName, String colName) {
        PreparedStatement stmt = session.prepare(((Select)QueryBuilder.selectFrom((String)tableName).column(colName).whereColumn(colName).isEqualTo((Term)QueryBuilder.bindMarker())).build());
        return session.execute((Statement)stmt.bind(new Object[]{id})).getAvailableWithoutFetching() > 0;
    }

    private static boolean existRecordbyCompId(CqlSession session, String col1, String col2, String id1, String id2, String tableName) {
        PreparedStatement stmt = session.prepare(((Select)((Select)QueryBuilder.selectFrom((String)tableName).all().whereColumn(col1).isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn(col2).isEqualTo((Term)QueryBuilder.bindMarker())).build());
        return session.execute((Statement)stmt.bind(new Object[]{id1, id2})).getAvailableWithoutFetching() > 0;
    }

    private static PreparedStatement updatePostEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Posts").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static Optional<Post> findPostById(String postid, CqlSession session) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException {
        PreparedStatement stmtFindPost = session.prepare(((Select)QueryBuilder.selectFrom((String)"Posts").all().whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet rs = session.execute((Statement)stmtFindPost.bind(new Object[]{UUID.fromString(postid)}));
        Row record = (Row)rs.one();
        return null != record ? Optional.of(DBCassandraAstyanaxImpl.readPostFromRow(record)) : Optional.empty();
    }

    private static Attachment readAttachmentFromRow(Row record) {
        Attachment a = new Attachment();
        a.setId(Objects.requireNonNull(record.getUuid("attachid")).toString());
        a.setUri(record.getString("uri"));
        a.setName(record.getString("name"));
        a.setDescription(record.getString("description"));
        a.setThumbnailURL(record.getString("urithumbnail"));
        a.setMimeType(record.getString("mimetype"));
        return a;
    }

    private static Notification readNotificationFromRow(Row record) throws NotificationTypeNotFoundException {
        Notification a = new Notification();
        a.setKey(Objects.requireNonNull(record.getUuid("notid")).toString());
        a.setType(DBCassandraAstyanaxImpl.getNotificationType(Objects.requireNonNull(record.getString("type"))));
        a.setUserid(record.getString("userid"));
        a.setSubjectid(record.getString("subjectid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setUri(record.getString("uri"));
        a.setDescription(record.getString("description"));
        a.setRead(record.getBoolean("isread"));
        a.setSenderid(record.getString("senderid"));
        a.setSenderFullName(record.getString("senderfullname"));
        a.setSenderThumbnail(record.getString("senderthumbnailurl"));
        return a;
    }

    private static Post readPostFromRow(Row record) throws FeedTypeNotFoundException, PrivacyLevelTypeNotFoundException {
        Post a = new Post();
        a.setKey(Objects.requireNonNull(record.getUuid("postid")).toString());
        a.setType(DBCassandraAstyanaxImpl.getPostType(Objects.requireNonNull(record.getString("type"))));
        a.setEntityId(record.getString("entityid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setVreid(record.getString("vreid"));
        a.setUri(record.getString("uri"));
        a.setUriThumbnail(record.getString("urithumbnail"));
        a.setDescription(record.getString("description"));
        a.setPrivacy(DBCassandraAstyanaxImpl.getPrivacyLevel(Objects.requireNonNull(record.getString("privacy"))));
        a.setFullName(record.getString("fullname"));
        a.setEmail(record.getString("email"));
        a.setThumbnailURL(record.getString("thumbnailurl"));
        a.setCommentsNo(String.valueOf(record.getLong("commentsno")));
        a.setLikesNo(String.valueOf(record.getLong("likesno")));
        a.setLinkDescription(record.getString("linkdescription"));
        a.setLinkTitle(record.getString("linktitle"));
        a.setLinkHost(record.getString("linkhost"));
        a.setApplicationFeed(record.getBoolean("isapplicationpost"));
        a.setMultiFileUpload(record.getBoolean("multifileupload"));
        return a;
    }

    private static Like readLikeFromRow(Row record) {
        Like a = new Like();
        a.setKey(Objects.requireNonNull(record.getUuid("likeid")).toString());
        a.setUserid(record.getString("userid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setFeedid(Objects.requireNonNull(record.getUuid("postid")).toString());
        a.setFullName(record.getString("fullname"));
        a.setThumbnailURL(record.getString("thumbnailurl"));
        return a;
    }

    private static Comment readCommentFromRow(Row record) {
        Comment a = new Comment();
        a.setKey(Objects.requireNonNull(record.getUuid("commentid")).toString());
        a.setUserid(record.getString("userid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setFeedid(Objects.requireNonNull(record.getUuid("postid")).toString());
        a.setFullName(record.getString("fullname"));
        a.setThumbnailURL(record.getString("thumbnailurl"));
        a.setText(record.getString("comment"));
        a.setEdit(!record.isNull("isedit") && record.getBoolean("isedit"));
        a.setLastEditTime(record.isNull("lastedittime") ? null : Date.from(Objects.requireNonNull(record.getInstant("lastedittime"))));
        return a;
    }

    private static Invite readAInviteFromRow(Row record) throws InviteStatusNotFoundException {
        Invite a = new Invite();
        a.setKey(Objects.requireNonNull(record.getUuid("inviteid")).toString());
        a.setSenderUserId(record.getString("senderuserid"));
        a.setVreid(record.getString("vreid"));
        a.setInvitedEmail(record.getString("email"));
        a.setControlCode(record.getString("controlcode"));
        a.setStatus(DBCassandraAstyanaxImpl.getInviteStatusType(Objects.requireNonNull(record.getString("status"))));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setSenderFullName(record.getString("senderfullname"));
        return a;
    }

    private static Feed readFeedFromRow(Row record) throws FeedTypeNotFoundException, PrivacyLevelTypeNotFoundException {
        Feed a = new Feed();
        a.setKey(Objects.requireNonNull(record.getUuid("postid")).toString());
        a.setType(DBCassandraAstyanaxImpl.getFeedType(Objects.requireNonNull(record.getString("type"))));
        a.setEntityId(record.getString("entityid"));
        a.setTime(Date.from(Objects.requireNonNull(record.getInstant("timestamp"))));
        a.setVreid(record.getString("vreid"));
        a.setUri(record.getString("uri"));
        a.setUriThumbnail(record.getString("urithumbnail"));
        a.setDescription(record.getString("description"));
        a.setPrivacy(DBCassandraAstyanaxImpl.getPrivacyLevel(Objects.requireNonNull(record.getString("privacy"))));
        a.setFullName(record.getString("fullname"));
        a.setEmail(record.getString("email"));
        a.setThumbnailURL(record.getString("thumbnailurl"));
        a.setCommentsNo(String.valueOf(record.getLong("commentsno")));
        a.setLikesNo(String.valueOf(record.getLong("likesno")));
        a.setLinkDescription(record.getString("linkdescription"));
        a.setLinkTitle(record.getString("linktitle"));
        a.setLinkHost(record.getString("linkhost"));
        a.setApplicationFeed(record.getBoolean("isapplicationpost"));
        a.setMultiFileUpload(record.getBoolean("multifileupload"));
        return a;
    }

    private static Optional<Feed> findFeedById(String postid, CqlSession session) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException {
        PreparedStatement stmtFindPost = session.prepare(((Select)QueryBuilder.selectFrom((String)"Posts").all().whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet rs = session.execute((Statement)stmtFindPost.bind(new Object[]{UUID.fromString(postid)}));
        Row record = (Row)rs.one();
        return null != record ? Optional.of(DBCassandraAstyanaxImpl.readFeedFromRow(record)) : Optional.empty();
    }

    private static Optional<Notification> findNotById(String notid, CqlSession session) throws NotificationTypeNotFoundException {
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Notifications").all().whereColumn("notid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet rs = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(notid)}));
        Row record = (Row)rs.one();
        return null != record ? Optional.of(DBCassandraAstyanaxImpl.readNotificationFromRow(record)) : Optional.empty();
    }

    private static PreparedStatement updateInviteEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Invites").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("inviteid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement updateVreInviteEntry(CqlSession session, String colName) {
        return session.prepare(((Update)((Update)QueryBuilder.update((String)"VREInvites").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("inviteid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteHashtagEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"HashtaggedPosts").whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteHashtagCommentEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"HashtaggedComments").whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteLikeEntry(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"Likes").whereColumn("likeid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteUserLikeEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"UserLikes").whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("likeid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement updateCommentEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Comments").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteCommentEntry(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"Comments").whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement updateNotificationEntry(CqlSession session, String colName) {
        return session.prepare(((Update)QueryBuilder.update((String)"Notifications").setColumn(colName, (Term)QueryBuilder.bindMarker()).whereColumn("notid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static PreparedStatement deleteUnreadNotEntry(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"UserUnreadNotifications").whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("timestamp").isEqualTo((Term)QueryBuilder.bindMarker())).build());
    }

    private static BatchStatement getBatch() {
        return BatchStatement.builder((BatchType)BatchType.LOGGED).build();
    }

    private static PreparedStatement createPostEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linkhost", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).value("likesno", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).value("linkdescription", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).value("isapplicationpost", (Term)QueryBuilder.bindMarker()).value("entityid", (Term)QueryBuilder.bindMarker()).value("privacy", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).value("multifileupload", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).value("commentsno", (Term)QueryBuilder.bindMarker()).value("linktitle", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createUserTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserTimeline").value("userid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createVreTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"VRETimeline").value("vreid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createAppTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"AppTimeline").value("appid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNotificationEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).value("subjectid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).value("senderid", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).value("senderthumbnailurl", (Term)QueryBuilder.bindMarker()).value("isread", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createUserNotificationsEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserNotifications").value("userid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("notid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createUnreadNotificationEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserUnreadNotifications").value("userid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("notid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNotificationPreferenceEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserNotificationsPreferences").value("userid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).value("preference", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewCommentEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).value("comment", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("isedit", (Term)QueryBuilder.bindMarker()).value("lastedittime", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewLikeEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewUserLikesEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"UserLikes").value("userid", (Term)QueryBuilder.bindMarker()).value("likeid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewHashtagTimelineEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"HashtaggedPosts").value("hashtag", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewHashtagCommentEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"HashtaggedComments").value("hashtag", (Term)QueryBuilder.bindMarker()).value("commentid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewEmailInviteEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"EmailInvites").value("email", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).value("inviteid", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewInviteEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("senderuserid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).value("controlcode", (Term)QueryBuilder.bindMarker()).value("status", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewVreInviteEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"VREInvites").value("vreid", (Term)QueryBuilder.bindMarker()).value("inviteid", (Term)QueryBuilder.bindMarker()).value("status", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewaAttachEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).value("name", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).value("mimetype", (Term)QueryBuilder.bindMarker()).build());
    }

    private static PreparedStatement createNewUHashtagCounterEntry(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"HashtagsCounter").value("vreid", (Term)QueryBuilder.bindMarker()).value("hashtag", (Term)QueryBuilder.bindMarker()).value("count", (Term)QueryBuilder.bindMarker()).build());
    }

    @Override
    public boolean requestFriendship(String from, String to) {
        return true;
    }

    @Override
    public boolean approveFriendship(String from, String to) {
        return true;
    }

    @Override
    public boolean denyFriendship(String from, String to) {
        return true;
    }

    @Override
    public List<String> getFriends(String userid) {
        ArrayList<String> toReturn = new ArrayList<String>();
        return toReturn;
    }

    @Override
    public List<String> getPendingFriendRequests(String userid) {
        ArrayList<String> toReturn = new ArrayList<String>();
        return toReturn;
    }

    private static Post feed2post(Feed feed) {
        Post post = new Post();
        if (feed.getKey() != null) {
            post.setKey(feed.getKey());
        }
        if (feed.getType() != null) {
            post.setType(PostType.valueOf((String)feed.getType().toString()));
        }
        if (feed.getEntityId() != null) {
            post.setEntityId(feed.getEntityId());
        }
        if (feed.getTime() != null) {
            post.setTime(feed.getTime());
        }
        if (feed.getVreid() != null) {
            post.setVreid(feed.getVreid());
        }
        if (feed.getUri() != null) {
            post.setUri(feed.getUri());
        }
        if (feed.getUriThumbnail() != null) {
            post.setUriThumbnail(feed.getUriThumbnail());
        }
        if (feed.getDescription() != null) {
            post.setDescription(feed.getDescription());
        }
        if (feed.getPrivacy() != null) {
            post.setPrivacy(feed.getPrivacy());
        }
        if (feed.getFullName() != null) {
            post.setFullName(feed.getFullName());
        }
        if (feed.getEmail() != null) {
            post.setEmail(feed.getEmail());
        }
        if (feed.getThumbnailURL() != null) {
            post.setThumbnailURL(feed.getThumbnailURL());
        }
        if (feed.getCommentsNo() != null) {
            post.setCommentsNo(feed.getCommentsNo());
        }
        if (feed.getLikesNo() != null) {
            post.setLikesNo(feed.getLikesNo());
        }
        if (feed.getLinkTitle() != null) {
            post.setLinkTitle(feed.getLinkTitle());
        }
        if (feed.getLinkDescription() != null) {
            post.setLinkDescription(feed.getLinkDescription());
        }
        if (feed.getLinkHost() != null) {
            post.setLinkHost(feed.getLinkHost());
        }
        post.setApplicationFeed(feed.isApplicationFeed());
        post.setMultiFileUpload(feed.isMultiFileUpload());
        return post;
    }

    private static Feed post2feed(Post post) {
        Feed feed = new Feed();
        if (post.getKey() != null) {
            feed.setKey(post.getKey());
        }
        if (post.getType() != null) {
            feed.setType(FeedType.valueOf((String)post.getType().toString()));
        }
        if (post.getEntityId() != null) {
            feed.setEntityId(post.getEntityId());
        }
        if (post.getTime() != null) {
            feed.setTime(post.getTime());
        }
        if (post.getVreid() != null) {
            feed.setVreid(post.getVreid());
        }
        if (post.getUri() != null) {
            feed.setUri(post.getUri());
        }
        if (post.getUriThumbnail() != null) {
            feed.setUriThumbnail(post.getUriThumbnail());
        }
        if (post.getDescription() != null) {
            feed.setDescription(post.getDescription());
        }
        if (post.getPrivacy() != null) {
            feed.setPrivacy(post.getPrivacy());
        }
        if (post.getFullName() != null) {
            feed.setFullName(post.getFullName());
        }
        if (post.getEmail() != null) {
            feed.setEmail(post.getEmail());
        }
        if (post.getThumbnailURL() != null) {
            feed.setThumbnailURL(post.getThumbnailURL());
        }
        if (post.getCommentsNo() != null) {
            feed.setCommentsNo(post.getCommentsNo());
        }
        if (post.getLikesNo() != null) {
            feed.setLikesNo(post.getLikesNo());
        }
        if (post.getLinkTitle() != null) {
            feed.setLinkTitle(post.getLinkTitle());
        }
        if (post.getLinkDescription() != null) {
            feed.setLinkDescription(post.getLinkDescription());
        }
        if (post.getLinkHost() != null) {
            feed.setLinkHost(post.getLinkHost());
        }
        feed.setApplicationFeed(post.isApplicationFeed());
        feed.setMultiFileUpload(post.isMultiFileUpload());
        return feed;
    }

    private List<BoundStatement> insertIntoPosts(CqlSession session, Post post) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linkhost", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("likesno", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linkdescription", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt8 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt9 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("isapplicationpost", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt10 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("entityid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt11 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("privacy", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt12 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt13 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt14 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt15 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("multifileupload", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt16 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt17 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("commentsno", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt18 = session.prepare(QueryBuilder.insertInto((String)"Posts").value("postid", (Term)QueryBuilder.bindMarker()).value("linktitle", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (post.getLinkHost() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(post.getKey()), post.getLinkHost()}));
        }
        if (post.getDescription() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(post.getKey()), post.getDescription()}));
        }
        if (post.getEmail() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(post.getKey()), post.getEmail()}));
        }
        if (post.getLikesNo() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(post.getKey()), Long.parseLong(post.getLikesNo())}));
        }
        if (post.getThumbnailURL() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(post.getKey()), post.getThumbnailURL()}));
        }
        if (post.getLinkDescription() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(post.getKey()), post.getLinkDescription()}));
        }
        if (post.getTime() != null) {
            boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(post.getKey()), post.getTime().toInstant()}));
        }
        if (post.getUri() != null) {
            boundStatements.add(prepStmt8.bind(new Object[]{UUID.fromString(post.getKey()), post.getUri()}));
        }
        boundStatements.add(prepStmt9.bind(new Object[]{UUID.fromString(post.getKey()), post.isApplicationFeed()}));
        if (post.getEntityId() != null) {
            boundStatements.add(prepStmt10.bind(new Object[]{UUID.fromString(post.getKey()), post.getEntityId()}));
        }
        if (post.getPrivacy() != null) {
            boundStatements.add(prepStmt11.bind(new Object[]{UUID.fromString(post.getKey()), post.getPrivacy().toString()}));
        }
        if (post.getType() != null) {
            boundStatements.add(prepStmt12.bind(new Object[]{UUID.fromString(post.getKey()), post.getType().toString()}));
        }
        if (post.getUriThumbnail() != null) {
            boundStatements.add(prepStmt13.bind(new Object[]{UUID.fromString(post.getKey()), post.getUriThumbnail()}));
        }
        if (post.getVreid() != null) {
            boundStatements.add(prepStmt14.bind(new Object[]{UUID.fromString(post.getKey()), post.getVreid()}));
        }
        boundStatements.add(prepStmt15.bind(new Object[]{UUID.fromString(post.getKey()), post.isMultiFileUpload()}));
        if (post.getFullName() != null) {
            boundStatements.add(prepStmt16.bind(new Object[]{UUID.fromString(post.getKey()), post.getFullName()}));
        }
        if (post.getCommentsNo() != null) {
            boundStatements.add(prepStmt17.bind(new Object[]{UUID.fromString(post.getKey()), Long.parseLong(post.getCommentsNo())}));
        }
        if (post.getLinkTitle() != null) {
            boundStatements.add(prepStmt18.bind(new Object[]{UUID.fromString(post.getKey()), post.getLinkTitle()}));
        }
        return boundStatements;
    }

    @Override
    @Deprecated
    public boolean saveUserFeed(Feed post) {
        BatchStatement writeBatch;
        Boolean result;
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoPosts(session, DBCassandraAstyanaxImpl.feed2post(post));
        BoundStatement stmt2 = DBCassandraAstyanaxImpl.createUserTimelineEntry(session).bind(new Object[]{post.getEntityId(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
        boundStatements.add(stmt2);
        if (post.getVreid() != null && post.getVreid().compareTo("") != 0) {
            BoundStatement stmt3 = DBCassandraAstyanaxImpl.createVreTimelineEntry(session).bind(new Object[]{post.getVreid(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
            boundStatements.add(stmt3);
        }
        if ((result = Boolean.valueOf(session.execute((Statement)(writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements))).wasApplied())).booleanValue()) {
            _log.debug("Wrote user post with id " + post.getKey());
        }
        return result;
    }

    @Override
    public boolean saveUserPost(Post post) {
        BatchStatement writeBatch;
        Boolean result;
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoPosts(session, post);
        BoundStatement stmt2 = DBCassandraAstyanaxImpl.createUserTimelineEntry(session).bind(new Object[]{post.getEntityId(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
        boundStatements.add(stmt2);
        if (post.getVreid() != null && post.getVreid().compareTo("") != 0) {
            BoundStatement stmt3 = DBCassandraAstyanaxImpl.createVreTimelineEntry(session).bind(new Object[]{post.getVreid(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
            boundStatements.add(stmt3);
        }
        if ((result = Boolean.valueOf(session.execute((Statement)(writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements))).wasApplied())).booleanValue()) {
            _log.debug("Wrote user post with id " + post.getKey());
        }
        return result;
    }

    @Override
    @Deprecated
    public boolean saveUserFeed(Feed feed, List<Attachment> attachments) {
        boolean saveFeedResult;
        if (attachments != null && !attachments.isEmpty()) {
            feed.setMultiFileUpload(true);
        }
        if (saveFeedResult = this.saveUserFeed(feed)) {
            String feedKey = feed.getKey();
            for (Attachment attachment : attachments) {
                boolean attachSaveResult = this.saveAttachmentEntry(feedKey, attachment);
                if (attachSaveResult) continue;
                _log.warn("Some of the attachments failed to me saved: " + attachment.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean saveUserPost(Post post, List<Attachment> attachments) {
        boolean savePostResult;
        if (attachments != null && !attachments.isEmpty()) {
            post.setMultiFileUpload(true);
        }
        if (savePostResult = this.saveUserPost(post)) {
            _log.debug("Post has been saved");
            String postkey = post.getKey();
            for (Attachment attachment : attachments) {
                boolean attachSaveResult = this.saveAttachmentEntry(postkey, attachment);
                if (attachSaveResult) continue;
                _log.info("Some of the attachments failed to be saved: " + attachment.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean saveAppFeed(Feed post) {
        BatchStatement writeBatch;
        boolean result;
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoPosts(session, DBCassandraAstyanaxImpl.feed2post(post));
        BoundStatement stmt2 = DBCassandraAstyanaxImpl.createAppTimelineEntry(session).bind(new Object[]{post.getEntityId(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
        boundStatements.add(stmt2);
        if (post.getVreid() != null && post.getVreid().compareTo("") != 0) {
            BoundStatement stmt3 = DBCassandraAstyanaxImpl.createVreTimelineEntry(session).bind(new Object[]{post.getVreid(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
            boundStatements.add(stmt3);
        }
        if (result = session.execute((Statement)(writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements))).wasApplied()) {
            _log.debug("Wrote app post with id " + post.getKey());
        }
        return result;
    }

    @Override
    public boolean saveAppPost(Post post) {
        BatchStatement writeBatch;
        boolean result;
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoPosts(session, post);
        BoundStatement stmt2 = DBCassandraAstyanaxImpl.createAppTimelineEntry(session).bind(new Object[]{post.getEntityId(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
        boundStatements.add(stmt2);
        if (post.getVreid() != null && post.getVreid().compareTo("") != 0) {
            BoundStatement stmt3 = DBCassandraAstyanaxImpl.createVreTimelineEntry(session).bind(new Object[]{post.getVreid(), post.getTime().toInstant(), UUID.fromString(post.getKey())});
            boundStatements.add(stmt3);
        }
        if (result = session.execute((Statement)(writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements))).wasApplied()) {
            _log.debug("Wrote app post with id " + post.getKey());
        }
        return result;
    }

    @Override
    @Deprecated
    public boolean saveAppFeed(Feed feed, List<Attachment> attachments) {
        boolean saveFeedResult;
        if (attachments != null && !attachments.isEmpty()) {
            feed.setMultiFileUpload(true);
        }
        if (saveFeedResult = this.saveAppFeed(feed)) {
            String feedKey = feed.getKey();
            for (Attachment attachment : attachments) {
                boolean attachSaveResult = this.saveAttachmentEntry(feedKey, attachment);
                if (attachSaveResult) continue;
                _log.warn("Some of the attachments failed to me saved: " + attachment.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean saveAppPost(Post post, List<Attachment> attachments) {
        boolean saveFeedResult;
        if (attachments != null && !attachments.isEmpty()) {
            post.setMultiFileUpload(true);
        }
        if (saveFeedResult = this.saveAppPost(post)) {
            String feedKey = post.getKey();
            for (Attachment attachment : attachments) {
                boolean attachSaveResult = this.saveAttachmentEntry(feedKey, attachment);
                if (attachSaveResult) continue;
                _log.warn("Some of the attachments failed to be saved: " + attachment.getName());
            }
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean saveFeedToVRETimeline(String feedKey, String vreid) throws FeedIDNotFoundException {
        Feed toCheck;
        try {
            toCheck = this.readFeed(feedKey);
            if (toCheck == null) {
                throw new FeedIDNotFoundException("Could not find Post with id " + feedKey, feedKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.createVreTimelineEntry(session).bind(new Object[]{vreid, toCheck.getTime().toInstant(), UUID.fromString(toCheck.getKey())}));
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean savePostToVRETimeline(String postKey, String vreid) throws FeedIDNotFoundException {
        Post toCheck;
        try {
            toCheck = this.readPost(postKey);
            if (toCheck == null) {
                throw new FeedIDNotFoundException("Could not find Post with id " + postKey, postKey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.createVreTimelineEntry(session).bind(new Object[]{vreid, toCheck.getTime().toInstant(), UUID.fromString(toCheck.getKey())}));
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    @Deprecated
    public Feed readFeed(String feedid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        Feed post;
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            post = DBCassandraAstyanaxImpl.findFeedById(feedid, session).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return post;
    }

    @Override
    public Post readPost(String postid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        Post post;
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            post = DBCassandraAstyanaxImpl.findPostById(postid, session).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return post;
    }

    @Override
    @Deprecated
    public List<Feed> getRecentFeedsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        ResultSet result = null;
        try {
            CqlSession session = this.conn.getKeyspaceSession();
            PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserTimeline").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        List rows = result.all();
        for (Row row : rows) {
            Instant postTime = row.getInstant("timestamp");
            if (Date.from(postTime).getTime() <= timeInMillis) continue;
            try {
                Feed toCheck = this.readFeed(row.getUuid("postid").toString());
                if (toCheck.getType() == FeedType.DISABLED) continue;
                toReturn.add(toCheck);
            }
            catch (ColumnNameNotFoundException | FeedIDNotFoundException | FeedTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    @Override
    public List<Post> getRecentPostsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        ResultSet result = null;
        try {
            CqlSession session = this.conn.getKeyspaceSession();
            PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserTimeline").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<Post> toReturn = new ArrayList<Post>();
        for (Row row : rows) {
            Instant postTime = row.getInstant("timestamp");
            if (Date.from(postTime).getTime() <= timeInMillis) continue;
            try {
                Post toCheck = this.readPost(row.getUuid("postid").toString());
                if (toCheck.getType() == PostType.DISABLED) continue;
                toReturn.add(toCheck);
            }
            catch (ColumnNameNotFoundException | FeedIDNotFoundException | FeedTypeNotFoundException | PrivacyLevelTypeNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    @Override
    @Deprecated
    public boolean deleteFeed(String feedId) throws FeedIDNotFoundException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException {
        Feed toDelete = this.readFeed(feedId);
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.updatePostEntry(session, "type").bind(new Object[]{FeedType.DISABLED.toString(), UUID.fromString(toDelete.getKey())}));
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            _log.error("Delete Post ERROR for postid " + feedId);
            return false;
        }
        _log.debug("Delete Post OK");
        return true;
    }

    @Override
    public boolean deletePost(String postid) throws FeedIDNotFoundException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException {
        Post toDelete = this.readPost(postid);
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.updatePostEntry(session, "type").bind(new Object[]{PostType.DISABLED.toString(), UUID.fromString(toDelete.getKey())}));
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            _log.error("Delete Post ERROR for postid " + postid);
            return false;
        }
        _log.debug("Delete Post OK");
        return true;
    }

    @Override
    @Deprecated
    public List<Feed> getAllFeedsByUser(String userid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return this.getFeedsByIds(this.getUserFeedIds(userid));
    }

    @Override
    public List<Post> getAllPostsByUser(String userid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return this.getPostsByIds(this.getUserPostIds(userid));
    }

    @Override
    public List<Feed> getAllFeedsByApp(String appid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return this.getFeedsByIds(this.getAppFeedIds(appid));
    }

    @Override
    public List<Post> getAllPostsByApp(String appid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return this.getPostsByIds(this.getAppPostIds(appid));
    }

    @Override
    @Deprecated
    public List<Feed> getRecentCommentedFeedsByUserAndDate(String userid, long timeInMillis) throws Exception {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<Comment> lastComments = this.getRecentCommentsByUserAndDateBody(userid, timeInMillis, false);
        HashSet<String> postIds = new HashSet<String>();
        for (Comment comment : lastComments) {
            String postId = comment.getFeedid();
            try {
                if (postIds.contains(postId)) continue;
                postIds.add(postId);
                toReturn.add(this.readFeed(postId));
            }
            catch (Exception e) {
                _log.error("Unable to retrieve feed with id " + postId, (Throwable)e);
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    @Override
    public List<Post> getRecentCommentedPostsByUserAndDate(String userid, long timeInMillis) throws Exception {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<Comment> lastComments = this.getRecentCommentsByUserAndDateBody(userid, timeInMillis, false);
        HashSet<String> postIds = new HashSet<String>();
        for (Comment comment : lastComments) {
            String postId = comment.getFeedid();
            try {
                if (postIds.contains(postId)) continue;
                postIds.add(postId);
                toReturn.add(this.readPost(postId));
            }
            catch (Exception e) {
                _log.error("Unable to retrieve feed with id " + postId, (Throwable)e);
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    private List<Feed> getFeedsByIds(List<String> feedIds) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        for (String feedid : feedIds) {
            Feed toAdd = this.readFeed(feedid);
            if (toAdd.getType() != FeedType.TWEET && toAdd.getType() != FeedType.SHARE && toAdd.getType() != FeedType.PUBLISH) continue;
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    private List<Post> getPostsByIds(List<String> postIds) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        for (String feedid : postIds) {
            Post toAdd = this.readPost(feedid);
            if (toAdd.getType() != PostType.TWEET && toAdd.getType() != PostType.SHARE && toAdd.getType() != PostType.PUBLISH) continue;
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    @Deprecated
    private ArrayList<String> getUserFeedIds(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserTimeline").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private ArrayList<String> getUserPostIds(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserTimeline").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private boolean isPostLiked(String userid, String postid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserLikes").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            if (!row.getUuid("postid").toString().equals(postid)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private ArrayList<String> getAppFeedIds(String appid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"AppTimeline").all().whereColumn("appid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{appid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private ArrayList<String> getAppPostIds(String appid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"AppTimeline").all().whereColumn("appid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{appid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    @Override
    @Deprecated
    public List<Feed> getAllPortalPrivacyLevelFeeds() throws FeedTypeNotFoundException, ColumnNameNotFoundException, PrivacyLevelTypeNotFoundException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Posts").all().whereColumn("privacy").isEqualTo((Term)QueryBuilder.bindMarker())).limit(20).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{PrivacyLevel.PORTAL.toString()}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            Feed toAdd = DBCassandraAstyanaxImpl.readFeedFromRow(row);
            if (toAdd.getType() != FeedType.TWEET && toAdd.getType() != FeedType.SHARE && toAdd.getType() != FeedType.PUBLISH) continue;
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    @Override
    public List<Post> getAllPortalPrivacyLevelPosts() throws FeedTypeNotFoundException, ColumnNameNotFoundException, PrivacyLevelTypeNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Posts").all().whereColumn("privacy").isEqualTo((Term)QueryBuilder.bindMarker())).limit(20).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{PrivacyLevel.PORTAL.toString()}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            Post toAdd = DBCassandraAstyanaxImpl.readPostFromRow(row);
            if (toAdd.getType() != PostType.TWEET && toAdd.getType() != PostType.SHARE && toAdd.getType() != PostType.PUBLISH) continue;
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    @Override
    @Deprecated
    public List<Feed> getRecentFeedsByUser(String userid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        ArrayList<String> feedIDs = this.getUserFeedIds(userid);
        quantity = quantity > feedIDs.size() ? feedIDs.size() : quantity;
        for (int i = feedIDs.size() - 1; i >= feedIDs.size() - quantity; --i) {
            Feed toAdd = this.readFeed(feedIDs.get(i));
            if (toAdd.getType() == FeedType.TWEET || toAdd.getType() == FeedType.SHARE || toAdd.getType() == FeedType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent feed: " + feedIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped feed: " + feedIDs.get(i) + " (Removed Feed)");
            quantity = ++quantity > feedIDs.size() ? feedIDs.size() : quantity;
        }
        return toReturn;
    }

    @Override
    public List<Post> getRecentPostsByUser(String userid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        ArrayList<String> postIDs = this.getUserPostIds(userid);
        quantity = quantity > postIDs.size() ? postIDs.size() : quantity;
        for (int i = postIDs.size() - 1; i >= postIDs.size() - quantity; --i) {
            Post toAdd = this.readPost(postIDs.get(i));
            if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent post: " + postIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped post: " + postIDs.get(i) + " (Removed Post)");
            quantity = ++quantity > postIDs.size() ? postIDs.size() : quantity;
        }
        return toReturn;
    }

    @Override
    @Deprecated
    public List<Feed> getAllFeedsByVRE(String vreid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return this.getFeedsByIds(this.getVREFeedIds(vreid));
    }

    @Override
    public List<Post> getAllPostsByVRE(String vreid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        return this.getPostsByIds(this.getVREPostIds(vreid));
    }

    @Override
    @Deprecated
    public List<Feed> getRecentFeedsByVRE(String vreid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        ArrayList<String> feedIDs = this.getVREFeedIds(vreid);
        quantity = quantity > feedIDs.size() ? feedIDs.size() : quantity;
        for (int i = feedIDs.size() - 1; i >= feedIDs.size() - quantity; --i) {
            Feed toAdd = this.readFeed(feedIDs.get(i));
            if (toAdd.getType() == FeedType.TWEET || toAdd.getType() == FeedType.SHARE || toAdd.getType() == FeedType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent feed: " + feedIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped feed: " + feedIDs.get(i) + " (Removed Feed) .");
            quantity = ++quantity > feedIDs.size() ? feedIDs.size() : quantity;
        }
        return toReturn;
    }

    @Override
    public List<Post> getRecentPostsByVRE(String vreid, int quantity) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        ArrayList<String> postIDs = this.getVREPostIds(vreid);
        quantity = quantity > postIDs.size() ? postIDs.size() : quantity;
        for (int i = postIDs.size() - 1; i >= postIDs.size() - quantity; --i) {
            Post toAdd = this.readPost(postIDs.get(i));
            if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent Post: " + postIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped Post: " + postIDs.get(i) + " (Removed Post) .");
            quantity = ++quantity > postIDs.size() ? postIDs.size() : quantity;
        }
        return toReturn;
    }

    @Override
    public RangeFeeds getRecentFeedsByVREAndRange(String vreid, int from, int quantity) throws IllegalArgumentException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        if (from < 1) {
            throw new IllegalArgumentException("From must be greather than 0");
        }
        ArrayList<Feed> feedsToReturn = new ArrayList<Feed>();
        ArrayList<String> feedIDs = this.getVREFeedIds(vreid);
        if (from >= feedIDs.size()) {
            _log.warn("The starting point of the range is greather than the total number of feeds for this timeline: " + from + " >= " + feedIDs.size());
            return new RangeFeeds();
        }
        int rangeStart = feedIDs.size() - from;
        int rangeEnd = rangeStart - quantity;
        if (rangeEnd < 1) {
            rangeEnd = 0;
        }
        _log.debug("BEFORE starting Point=" + rangeStart + " rangeEnd= " + rangeEnd);
        int howMany = from;
        for (int i = rangeStart; i > rangeEnd; --i) {
            Feed toAdd = this.readFeed(feedIDs.get(i));
            if (toAdd.getType() == FeedType.TWEET || toAdd.getType() == FeedType.SHARE || toAdd.getType() == FeedType.PUBLISH) {
                feedsToReturn.add(toAdd);
                _log.trace("Read recent post, i=" + i + " id= " + feedIDs.get(i));
            } else {
                _log.trace("Read and skipped post, i=" + i + " id=: " + feedIDs.get(i) + " (Removed post) .");
                rangeEnd = --rangeEnd > 0 ? rangeEnd : 0;
            }
            ++howMany;
        }
        _log.debug("AFTER: starting Point==" + rangeStart + " rangeEnd= " + rangeEnd);
        return new RangeFeeds(howMany + 1, feedsToReturn);
    }

    @Override
    public RangePosts getRecentPostsByVREAndRange(String vreid, int from, int quantity) throws IllegalArgumentException, PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        if (from < 1) {
            throw new IllegalArgumentException("From must be greather than 0");
        }
        ArrayList<Post> feedsToReturn = new ArrayList<Post>();
        ArrayList<String> feedIDs = this.getVREPostIds(vreid);
        if (from >= feedIDs.size()) {
            _log.warn("The starting point of the range is greather than the total number of feeds for this timeline: " + from + " >= " + feedIDs.size());
            return new RangePosts();
        }
        int rangeStart = feedIDs.size() - from;
        int rangeEnd = rangeStart - quantity;
        if (rangeEnd < 1) {
            rangeEnd = 0;
        }
        _log.debug("BEFORE starting Point=" + rangeStart + " rangeEnd= " + rangeEnd);
        int howMany = from;
        for (int i = rangeStart; i > rangeEnd; --i) {
            Post toAdd = this.readPost(feedIDs.get(i));
            if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                feedsToReturn.add(toAdd);
                _log.trace("Read recent post, i=" + i + " id= " + feedIDs.get(i));
            } else {
                _log.trace("Read and skipped post, i=" + i + " id=: " + feedIDs.get(i) + " (Removed post) .");
                rangeEnd = --rangeEnd > 0 ? rangeEnd : 0;
            }
            ++howMany;
        }
        _log.debug("AFTER: starting Point==" + rangeStart + " rangeEnd= " + rangeEnd);
        return new RangePosts(howMany + 1, feedsToReturn);
    }

    private ArrayList<String> getVREFeedIds(String vreid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"VRETimeline").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private ArrayList<String> getVREPostIds(String vreid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"VRETimeline").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : rows) {
            try {
                String postid = row.getUuid("postid").toString();
                toReturn.add(postid);
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
        return toReturn;
    }

    private List<BoundStatement> insertIntoNotifications(CqlSession session, Notification notification) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("type", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("subjectid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("senderid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt8 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt9 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("senderthumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt10 = session.prepare(QueryBuilder.insertInto((String)"Notifications").value("notid", (Term)QueryBuilder.bindMarker()).value("isread", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (notification.getType() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getType().toString()}));
        }
        if (notification.getUserid() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getUserid()}));
        }
        if (notification.getSubjectid() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSubjectid()}));
        }
        if (notification.getTime() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getTime().toInstant()}));
        }
        if (notification.getDescription() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getDescription()}));
        }
        if (notification.getUri() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getUri()}));
        }
        if (notification.getSenderid() != null) {
            boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSenderid()}));
        }
        if (notification.getSenderFullName() != null) {
            boundStatements.add(prepStmt8.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSenderFullName()}));
        }
        if (notification.getSenderThumbnail() != null) {
            boundStatements.add(prepStmt9.bind(new Object[]{UUID.fromString(notification.getKey()), notification.getSenderThumbnail()}));
        }
        boundStatements.add(prepStmt10.bind(new Object[]{UUID.fromString(notification.getKey()), notification.isRead()}));
        return boundStatements;
    }

    @Override
    public boolean saveNotification(Notification n) {
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoNotifications(session, n);
        BoundStatement stmt2 = DBCassandraAstyanaxImpl.createUserNotificationsEntry(session).bind(new Object[]{n.getUserid(), n.getTime().toInstant(), UUID.fromString(n.getKey())});
        boundStatements.add(stmt2);
        BoundStatement stmt3 = DBCassandraAstyanaxImpl.createUnreadNotificationEntry(session).bind(new Object[]{n.getUserid(), n.getTime().toInstant(), UUID.fromString(n.getKey())});
        boundStatements.add(stmt3);
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements);
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Notification readNotification(String notificationid) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        Notification toReturn = new Notification();
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            toReturn = DBCassandraAstyanaxImpl.findNotById(notificationid, session).get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public boolean setNotificationRead(String notificationidToSet) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        Notification toSet = this.readNotification(notificationidToSet);
        if (toSet == null) {
            throw new NotificationIDNotFoundException("The specified notification to set Read with id: " + notificationidToSet + " does not exist");
        }
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.updateNotificationEntry(session, "isread").bind(new Object[]{true, UUID.fromString(notificationidToSet)})).add((BatchableStatement)DBCassandraAstyanaxImpl.deleteUnreadNotEntry(session).bind(new Object[]{toSet.getUserid(), toSet.getTime().toInstant()}));
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            return res;
        }
        catch (Exception e) {
            _log.error("ERROR while setting Notification " + notificationidToSet + " to read.");
            return false;
        }
    }

    private ArrayList<String> getUserNotificationsIds(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserNotifications").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            toReturn.add(row.getUuid("notid").toString());
        }
        return toReturn;
    }

    private ArrayList<String> getUnreadUserNotificationsIds(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserUnreadNotifications").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            toReturn.add(row.getUuid("notid").toString());
        }
        return toReturn;
    }

    @Override
    public List<Notification> getAllNotificationByUser(String userid, int limit) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<Notification> toReturn = new ArrayList<Notification>();
        ArrayList<String> notificationsIDs = this.getUserNotificationsIds(userid);
        limit = limit > notificationsIDs.size() ? notificationsIDs.size() : limit;
        for (int i = notificationsIDs.size() - 1; i >= notificationsIDs.size() - limit; --i) {
            Notification toAdd = null;
            try {
                toAdd = this.readNotification(notificationsIDs.get(i));
                toReturn.add(toAdd);
                continue;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Notification not found id=" + notificationsIDs.get(i));
            }
        }
        return toReturn;
    }

    @Override
    public List<Notification> getUnreadNotificationsByUser(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException {
        ArrayList<Notification> toReturn = new ArrayList<Notification>();
        ArrayList<String> notificationsIDs = this.getUnreadUserNotificationsIds(userid);
        for (int i = notificationsIDs.size() - 1; i >= 0; --i) {
            try {
                toReturn.add(this.readNotification(notificationsIDs.get(i)));
                continue;
            }
            catch (Exception e) {
                _log.error("Unable to read notification with key " + notificationsIDs.get(i));
            }
        }
        return toReturn;
    }

    @Override
    public List<Notification> getRangeNotificationsByUser(String userid, int from, int quantity) throws NotificationTypeNotFoundException, ColumnNameNotFoundException, NotificationIDNotFoundException {
        if (from < 1) {
            throw new IllegalArgumentException("From must be greather than 0");
        }
        ArrayList<Notification> toReturn = new ArrayList<Notification>();
        ArrayList<String> notificationsIDs = this.getUserNotificationsIds(userid);
        if (from >= notificationsIDs.size()) {
            _log.warn("The starting point of the range is greather than the total number of feeds for this timeline: " + from + " >= " + notificationsIDs.size());
            return new ArrayList<Notification>();
        }
        int rangeStart = notificationsIDs.size() - from;
        int rangeEnd = rangeStart - quantity;
        if (rangeEnd < 1) {
            rangeEnd = 0;
        }
        _log.debug("BEFORE starting Point=" + rangeStart + " rangeEnd= " + rangeEnd);
        for (int i = rangeStart; i > rangeEnd; --i) {
            Notification toAdd = this.readNotification(notificationsIDs.get(i));
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    @Override
    public boolean setAllNotificationReadByUser(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<String> notificationsIDs = this.getUnreadUserNotificationsIds(userid);
        for (int i = notificationsIDs.size() - 1; i >= 0; --i) {
            try {
                this.setNotificationRead(notificationsIDs.get(i));
                continue;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Could not set read notification with id =" + notificationsIDs.get(i));
            }
        }
        return true;
    }

    @Override
    public boolean checkUnreadNotifications(String userid) throws NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<String> unreadNotifications = this.getUnreadUserNotificationsIds(userid);
        for (int i = unreadNotifications.size() - 1; i >= 0; --i) {
            try {
                Notification toAdd = this.readNotification(unreadNotifications.get(i));
                if (toAdd.getType() == NotificationType.MESSAGE) continue;
                return true;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Notification not found with id = " + unreadNotifications.get(i));
            }
        }
        return false;
    }

    @Override
    public boolean checkUnreadMessagesNotifications(String userid) throws NotificationIDNotFoundException, NotificationTypeNotFoundException, ColumnNameNotFoundException {
        ArrayList<String> unreadNotifications = this.getUnreadUserNotificationsIds(userid);
        for (int i = unreadNotifications.size() - 1; i >= 0; --i) {
            try {
                Notification toAdd = this.readNotification(unreadNotifications.get(i));
                if (toAdd.getType() != NotificationType.MESSAGE) continue;
                return true;
            }
            catch (NotificationIDNotFoundException e) {
                _log.error("Notification not found with id = " + unreadNotifications.get(i));
            }
        }
        return false;
    }

    @Override
    public List<NotificationChannelType> getUserNotificationChannels(String userid, NotificationType notificationType) throws NotificationChannelTypeNotFoundException, NotificationTypeNotFoundException {
        _log.debug("Asking for Single Notification preference of  " + userid + " Type: " + String.valueOf(notificationType));
        ArrayList<NotificationChannelType> toReturn = new ArrayList<NotificationChannelType>();
        Map<NotificationType, NotificationChannelType[]> userNotPref = this.getUserNotificationPreferences(userid);
        if (userNotPref == null || !userNotPref.containsKey(notificationType) || userNotPref.get(notificationType) == null) {
            _log.debug("Single Notification preference of  " + userid + " Type: " + String.valueOf(notificationType) + " not existing ... creating default");
            return this.createNewNotificationType(userid, notificationType);
        }
        NotificationChannelType[] toProcess = userNotPref.get(notificationType);
        if (toProcess.length == 0) {
            _log.debug("size of user notification preferences 0");
            return toReturn;
        }
        _log.debug("size of user notification preferences " + toProcess.length);
        for (int i = 0; i < toProcess.length; ++i) {
            toReturn.add(toProcess[i]);
        }
        return toReturn;
    }

    private List<NotificationChannelType> createNewNotificationType(String userid, NotificationType notificationType) {
        ArrayList<NotificationChannelType> toReturn = new ArrayList<NotificationChannelType>();
        _log.debug("Create new notification type");
        CqlSession session = this.conn.getKeyspaceSession();
        Object valueToInsert = "";
        NotificationChannelType[] wpTypes = NotificationChannelType.values();
        if (notificationType.toString().startsWith("WP_")) {
            valueToInsert = (String)valueToInsert + String.valueOf(NotificationChannelType.PORTAL);
            toReturn.add(NotificationChannelType.PORTAL);
        } else {
            for (int i = 0; i < wpTypes.length; ++i) {
                valueToInsert = (String)valueToInsert + String.valueOf(wpTypes[i]);
                if (i < wpTypes.length - 1) {
                    valueToInsert = (String)valueToInsert + ",";
                }
                toReturn.add(wpTypes[i]);
            }
        }
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.createNotificationPreferenceEntry(session).bind(new Object[]{userid, notificationType.toString(), valueToInsert}));
        boolean res = false;
        try {
            res = session.execute((Statement)writeBatch).wasApplied();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res) {
            _log.debug("Set New Notification Setting for " + userid + " OK");
            _log.debug("toreturn:" + ((Object)toReturn).toString());
            return toReturn;
        }
        _log.debug("empty list");
        return new ArrayList<NotificationChannelType>();
    }

    @Override
    public boolean setUserNotificationPreferences(String userid, Map<NotificationType, NotificationChannelType[]> enabledChannels) {
        CqlSession session = this.conn.getKeyspaceSession();
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        for (NotificationType nType : enabledChannels.keySet()) {
            Object valueToInsert = "";
            _log.debug("Type: " + nType.toString());
            int channelsNo = enabledChannels.get(nType) != null ? enabledChannels.get(nType).length : 0;
            for (int i = 0; i < channelsNo; ++i) {
                _log.debug(enabledChannels.get(nType)[i].toString());
                valueToInsert = (String)valueToInsert + String.valueOf(NotificationChannelType.valueOf((String)enabledChannels.get(nType)[i].toString()));
                if (i >= channelsNo - 1) continue;
                valueToInsert = (String)valueToInsert + ",";
            }
            if (channelsNo == 0) {
                valueToInsert = "";
                _log.trace("No Channels selected for " + String.valueOf(nType) + " by " + userid);
            }
            boundStatements.add(DBCassandraAstyanaxImpl.createNotificationPreferenceEntry(session).bind(new Object[]{userid, nType.toString(), valueToInsert}));
        }
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements);
        boolean overAllresult = session.execute((Statement)writeBatch).wasApplied();
        if (overAllresult) {
            _log.debug("Set Notification Map for " + userid + " OK");
        } else {
            _log.debug("Set Notification Map for " + userid + " FAILED");
        }
        return overAllresult;
    }

    @Override
    public Map<NotificationType, NotificationChannelType[]> getUserNotificationPreferences(String userid) throws NotificationTypeNotFoundException, NotificationChannelTypeNotFoundException {
        _log.debug("Asking for Notification preferences of  " + userid);
        HashMap<NotificationType, NotificationChannelType[]> toReturn = new HashMap<NotificationType, NotificationChannelType[]>();
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserNotificationsPreferences").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List results = new ArrayList();
        if (result != null) {
            results = result.all();
        }
        if (results.size() != NotificationType.values().length) {
            _log.debug("Userid " + userid + " settings incomplete, initiating missing preferences...");
            HashMap<NotificationType, NotificationChannelType[]> toCreate = new HashMap<NotificationType, NotificationChannelType[]>();
            for (NotificationType notificationType : NotificationType.values()) {
                boolean found = false;
                for (Row row : results) {
                    if (!DBCassandraAstyanaxImpl.getNotificationType(row.getString("type")).equals((Object)notificationType)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                _log.debug("Missing preference for " + String.valueOf(notificationType) + ", setting default.");
                NotificationChannelType[] defaultChannels = notificationType.toString().startsWith("WP_") ? new NotificationChannelType[]{NotificationChannelType.PORTAL} : NotificationChannelType.values();
                toCreate.put(notificationType, defaultChannels);
            }
            if (!toCreate.isEmpty()) {
                this.setUserNotificationPreferences(userid, toCreate);
            }
            results = (result = session.execute((Statement)stmtFind.bind(new Object[]{userid}))) != null ? result.all() : new ArrayList();
        }
        _log.debug("Notification preferences Found for  " + userid + " : " + results.size());
        for (Row row : results) {
            String[] channels = row.getString("preference").split(",");
            if (channels != null && channels.length == 1 && channels[0].toString().equals("")) {
                toReturn.put(DBCassandraAstyanaxImpl.getNotificationType(row.getString("type")), new NotificationChannelType[0]);
                continue;
            }
            NotificationChannelType[] toAdd = new NotificationChannelType[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                if (channels[i].compareTo("") == 0) continue;
                toAdd[i] = this.getChannelType(channels[i]);
            }
            toReturn.put(DBCassandraAstyanaxImpl.getNotificationType(row.getString("type")), toAdd);
        }
        _log.debug("Returning:" + toReturn.size());
        return toReturn;
    }

    private List<BoundStatement> insertIntoComments(CqlSession session, Comment comment) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("comment", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("isedit", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt8 = session.prepare(QueryBuilder.insertInto((String)"Comments").value("commentid", (Term)QueryBuilder.bindMarker()).value("lastedittime", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (comment.getUserid() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getUserid()}));
        }
        if (comment.getFullName() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getFullName()}));
        }
        if (comment.getThumbnailURL() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getThumbnailURL()}));
        }
        if (comment.getText() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getText()}));
        }
        if (comment.getFeedid() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(comment.getKey()), UUID.fromString(comment.getFeedid())}));
        }
        if (comment.getTime() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getTime().toInstant()}));
        }
        boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(comment.getKey()), comment.isEdit()}));
        if (comment.getLastEditTime() != null) {
            boundStatements.add(prepStmt8.bind(new Object[]{UUID.fromString(comment.getKey()), comment.getLastEditTime().toInstant()}));
        }
        return boundStatements;
    }

    @Override
    public boolean addComment(Comment comment) throws FeedIDNotFoundException {
        Feed toComment = null;
        if (comment == null) {
            throw new NullArgumentException("Comment must be not null");
        }
        if (comment.getFeedid() == null) {
            throw new NullArgumentException("Comment feed id must be not null");
        }
        String postid = comment.getFeedid();
        try {
            toComment = this.readFeed(postid);
            if (toComment == null) {
                throw new FeedIDNotFoundException("Could not find Feed with id " + postid + " to associate this comment", postid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        _log.debug("Writing comment : {}", (Object)comment.toString());
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoComments(session, comment);
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements);
        try {
            ResultSet res = session.execute((Statement)writeBatch);
            for (ExecutionInfo ex : res.getExecutionInfos()) {
                _log.debug("Writing comment result errors: {}", (Object)ex.getErrors());
                _log.debug("Writing comment result payload: {}", (Object)ex.getIncomingPayload());
            }
            _log.debug("Writing comment result executed?: {}", (Object)res.wasApplied());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        boolean updateCommentNoResult = this.updateFeedCommentsCount(toComment, true);
        return updateCommentNoResult;
    }

    @Override
    public Comment readCommentById(String commentId) throws CommentIDNotFoundException {
        Comment toReturn = null;
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Comments").all().whereColumn("commentid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(commentId)}));
            toReturn = DBCassandraAstyanaxImpl.readCommentFromRow((Row)result.one());
            if (toReturn == null) {
                throw new CommentIDNotFoundException("The requested commentId: " + commentId + " is not existing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    @Deprecated
    public List<Comment> getAllCommentByFeed(String feedid) {
        return this.getAllCommentByPost(feedid);
    }

    @Override
    public List<Comment> getAllCommentByPost(String postid) {
        ArrayList<Comment> toReturn = new ArrayList<Comment>();
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare("SELECT * FROM comments WHERE postid=?");
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(postid)}));
            List rows = result.all();
            for (Row row : rows) {
                Comment toAdd = DBCassandraAstyanaxImpl.readCommentFromRow(row);
                toReturn.add(toAdd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<Comment> getRecentCommentsByUserAndDate(String userid, long timeInMillis) throws Exception {
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<Comment> commentsByUser = this.getRecentCommentsByUserAndDateBody(userid, timeInMillis, true);
        return commentsByUser;
    }

    private List<Comment> getRecentCommentsByUserAndDateBody(String userid, long timeInMillis, boolean sort) {
        ArrayList<Comment> commentsByUser = new ArrayList<Comment>();
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(QueryBuilder.selectFrom((String)"Comments").all().build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[0]));
            List results = result.all();
            if (!results.isEmpty()) {
                results.parallelStream().forEach(row -> {
                    if (row.getString("userid").equals(userid)) {
                        try {
                            Comment c = this.readCommentById(row.getUuid("commentid").toString());
                            Post p = this.readPost(c.getFeedid());
                            if (c.getTime().getTime() >= timeInMillis && (p.getType() == PostType.TWEET || p.getType() == PostType.SHARE || p.getType() == PostType.PUBLISH)) {
                                commentsByUser.add(c);
                            }
                        }
                        catch (Exception e) {
                            _log.error("Unable to read comment with id" + row.getString("commentid"), (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sort) {
            Collections.sort(commentsByUser, Collections.reverseOrder());
        }
        return commentsByUser;
    }

    @Override
    public boolean editComment(Comment comment2Edit) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, FeedIDNotFoundException {
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.updateCommentEntry(session, "comment").bind(new Object[]{comment2Edit.getText(), UUID.fromString(comment2Edit.getKey())})).add((BatchableStatement)DBCassandraAstyanaxImpl.updateCommentEntry(session, "isedit").bind(new Object[]{true, UUID.fromString(comment2Edit.getKey())})).add((BatchableStatement)DBCassandraAstyanaxImpl.updateCommentEntry(session, "lastedittime").bind(new Object[]{new Date().toInstant(), UUID.fromString(comment2Edit.getKey())}));
        try {
            boolean res = session.execute((Statement)writeBatch).wasApplied();
            _log.debug("Comments update OK to: " + comment2Edit.getText());
            return res;
        }
        catch (Exception e) {
            _log.error("Comments update NOT OK ");
            return false;
        }
    }

    @Override
    public boolean deleteComment(String commentid, String feedid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, CommentIDNotFoundException, FeedIDNotFoundException {
        Feed toUpdate = this.readFeed(feedid);
        boolean updateCommentNoResult = false;
        updateCommentNoResult = this.updateFeedCommentsCount(toUpdate, false);
        if (updateCommentNoResult) {
            CqlSession session = this.conn.getKeyspaceSession();
            BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.deleteCommentEntry(session).bind(new Object[]{UUID.fromString(commentid)}));
            try {
                session.execute((Statement)writeBatch);
            }
            catch (Exception e) {
                _log.error("Comment Delete FAILED for " + commentid + " from Feed " + feedid);
                e.printStackTrace();
            }
            _log.trace("Comment Deleted " + commentid + " from Feed " + feedid);
        }
        return updateCommentNoResult;
    }

    private List<BoundStatement> insertIntoLikes(CqlSession session, Like like) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("userid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("fullname", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("thumbnailurl", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Likes").value("likeid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (like.getUserid() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(like.getKey()), like.getUserid()}));
        }
        if (like.getFullName() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(like.getKey()), like.getFullName()}));
        }
        if (like.getThumbnailURL() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(like.getKey()), like.getThumbnailURL()}));
        }
        if (like.getFeedid() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(like.getKey()), UUID.fromString(like.getFeedid())}));
        }
        if (like.getTime() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(like.getKey()), like.getTime().toInstant()}));
        }
        return boundStatements;
    }

    @Override
    public boolean like(Like like) throws FeedIDNotFoundException {
        Feed toLike = null;
        if (like == null) {
            throw new NullArgumentException("Like must be not null");
        }
        if (like.getFeedid() == null) {
            throw new NullArgumentException("Like feed id must be not null");
        }
        String feedId = like.getFeedid();
        try {
            toLike = this.readFeed(feedId);
            if (toLike == null) {
                throw new FeedIDNotFoundException("Could not find Feed with id " + feedId + " to associate this like", feedId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (this.isPostLiked(like.getUserid(), feedId)) {
            _log.debug("User " + like.getUserid() + " already liked Feed " + feedId);
            return true;
        }
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.insertIntoLikes(session, like);
        BoundStatement stmt2 = DBCassandraAstyanaxImpl.createNewUserLikesEntry(session).bind(new Object[]{like.getUserid(), UUID.fromString(like.getKey()), UUID.fromString(like.getFeedid())});
        boundStatements.add(stmt2);
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements);
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return this.updateFeedLikesCount(toLike, true);
    }

    @Override
    public boolean unlike(String userid, String likeid, String feedid) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, LikeIDNotFoundException, FeedIDNotFoundException {
        Feed toUpdate = this.readFeed(feedid);
        boolean updateLikeNoResult = false;
        updateLikeNoResult = this.updateFeedLikesCount(toUpdate, false);
        if (updateLikeNoResult) {
            CqlSession session = this.conn.getKeyspaceSession();
            BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.deleteLikeEntry(session).bind(new Object[]{UUID.fromString(likeid)})).add((BatchableStatement)DBCassandraAstyanaxImpl.deleteUserLikeEntry(session).bind(new Object[]{userid, UUID.fromString(likeid)}));
            try {
                session.execute((Statement)writeBatch);
            }
            catch (Exception e) {
                _log.error("Like Delete FAILED for " + likeid + " from Feed " + feedid);
                e.printStackTrace();
            }
            _log.trace("Unlike ok for " + likeid + " from Feed " + feedid);
        }
        return updateLikeNoResult;
    }

    @Override
    @Deprecated
    public List<String> getAllLikedFeedIdsByUser(String userid) {
        return this.getAllLikedPostIdsByUser(userid);
    }

    @Override
    public List<String> getAllLikedPostIdsByUser(String userid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"UserLikes").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{userid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Row row : result) {
            toReturn.add(row.getUuid("postid").toString());
        }
        return toReturn;
    }

    @Override
    public List<Feed> getAllLikedFeedsByUser(String userid, int limit) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        List<String> likedPostIDs = this.getAllLikedPostIdsByUser(userid);
        limit = limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
        for (int i = likedPostIDs.size() - 1; i >= likedPostIDs.size() - limit; --i) {
            Feed toAdd = this.readFeed(likedPostIDs.get(i));
            if (toAdd.getType() == FeedType.TWEET || toAdd.getType() == FeedType.SHARE || toAdd.getType() == FeedType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent post: " + likedPostIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped post: " + likedPostIDs.get(i) + " (Removed post)");
            limit = ++limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
        }
        return toReturn;
    }

    @Override
    public List<Post> getAllLikedPostsByUser(String userid, int limit) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, ColumnNameNotFoundException, FeedIDNotFoundException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        List<String> likedPostIDs = this.getAllLikedPostIdsByUser(userid);
        limit = limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
        for (int i = likedPostIDs.size() - 1; i >= likedPostIDs.size() - limit; --i) {
            Post toAdd = this.readPost(likedPostIDs.get(i));
            if (toAdd.getType() == PostType.TWEET || toAdd.getType() == PostType.SHARE || toAdd.getType() == PostType.PUBLISH) {
                toReturn.add(toAdd);
                _log.trace("Read recent post: " + likedPostIDs.get(i));
                continue;
            }
            _log.trace("Read and skipped post: " + likedPostIDs.get(i) + " (Removed post)");
            limit = ++limit > likedPostIDs.size() ? likedPostIDs.size() : limit;
        }
        return toReturn;
    }

    @Override
    public List<Feed> getRecentLikedFeedsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        ArrayList<Feed> toReturn = new ArrayList<Feed>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<String> likedPostsIdsByUser = this.getAllLikedFeedIdsByUser(userid);
        if (likedPostsIdsByUser != null && !likedPostsIdsByUser.isEmpty()) {
            for (int i = likedPostsIdsByUser.size() - 1; i >= 0; --i) {
                String postid = likedPostsIdsByUser.get(i);
                try {
                    boolean isPostOk;
                    Feed toCheck = this.readFeed(postid);
                    boolean bl = isPostOk = toCheck.getType() == FeedType.TWEET || toCheck.getType() == FeedType.SHARE || toCheck.getType() == FeedType.PUBLISH;
                    if (!isPostOk) continue;
                    List<Like> likes = this.getAllLikesByFeed(postid);
                    for (Like like : likes) {
                        if (like.getTime().getTime() < timeInMillis || !like.getUserid().equals(userid)) continue;
                        toReturn.add(toCheck);
                    }
                    continue;
                }
                catch (Exception e) {
                    _log.error("Skipped post with id " + postid, (Throwable)e);
                }
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    @Override
    public List<Post> getRecentLikedPostsByUserAndDate(String userid, long timeInMillis) throws IllegalArgumentException {
        ArrayList<Post> toReturn = new ArrayList<Post>();
        Date now = new Date();
        if (timeInMillis > now.getTime()) {
            throw new IllegalArgumentException("the timeInMillis must be before today");
        }
        if (userid == null || userid.isEmpty()) {
            throw new IllegalArgumentException("the userId parameter cannot be null/empty");
        }
        List<String> likedPostsIdsByUser = this.getAllLikedPostIdsByUser(userid);
        if (likedPostsIdsByUser != null && !likedPostsIdsByUser.isEmpty()) {
            for (int i = likedPostsIdsByUser.size() - 1; i >= 0; --i) {
                String postid = likedPostsIdsByUser.get(i);
                try {
                    boolean isPostOk;
                    Post toCheck = this.readPost(postid);
                    boolean bl = isPostOk = toCheck.getType() == PostType.TWEET || toCheck.getType() == PostType.SHARE || toCheck.getType() == PostType.PUBLISH;
                    if (!isPostOk) continue;
                    List<Like> likes = this.getAllLikesByPost(postid);
                    for (Like like : likes) {
                        if (like.getTime().getTime() < timeInMillis || !like.getUserid().equals(userid)) continue;
                        toReturn.add(toCheck);
                    }
                    continue;
                }
                catch (Exception e) {
                    _log.error("Skipped post with id " + postid, (Throwable)e);
                }
            }
        }
        Collections.sort(toReturn, Collections.reverseOrder());
        return toReturn;
    }

    @Override
    @Deprecated
    public List<Like> getAllLikesByFeed(String feedid) {
        return this.getAllLikesByPost(feedid);
    }

    @Override
    public List<Like> getAllLikesByPost(String postid) {
        ArrayList<Like> toReturn = new ArrayList<Like>();
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Likes").all().whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(postid)}));
            for (Row row : result) {
                Like toAdd = DBCassandraAstyanaxImpl.readLikeFromRow(row);
                toReturn.add(toAdd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public boolean saveHashTags(String feedid, String vreid, List<String> hashtags) throws FeedIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstInsert = session.execute((Statement)DBCassandraAstyanaxImpl.createNewHashtagTimelineEntry(session).bind(new Object[]{lowerCaseHashtag, UUID.fromString(feedid), vreid})).wasApplied();
            boolean secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, true);
            if (firstInsert && secondInsert) continue;
            _log.error("saveHashTags: Could not save the hashtag(s)");
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteHashTags(String feedid, String vreid, List<String> hashtags) throws FeedIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstDelete = session.execute((Statement)DBCassandraAstyanaxImpl.deleteHashtagEntry(session).bind(new Object[]{lowerCaseHashtag, UUID.fromString(feedid)})).wasApplied();
            boolean secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, false);
            if (firstDelete && secondInsert) continue;
            _log.error("deleteHashTags: Could not delete the hashtag(s)");
            return false;
        }
        return true;
    }

    @Override
    public boolean saveHashTagsComment(String commentId, String vreid, List<String> hashtags) throws CommentIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstInsert = session.execute((Statement)DBCassandraAstyanaxImpl.createNewHashtagCommentEntry(session).bind(new Object[]{hashtag, UUID.fromString(commentId), vreid})).wasApplied();
            boolean secondInsert = false;
            if (firstInsert) {
                secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, true);
            }
            if (firstInsert && secondInsert) continue;
            _log.error("saveHashTags: Could not save the hashtag(s)");
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteHashTagsComment(String commentId, String vreid, List<String> hashtags) throws CommentIDNotFoundException {
        HashSet<String> noduplicatesHashtags = null;
        if (hashtags != null && !hashtags.isEmpty()) {
            noduplicatesHashtags = new HashSet<String>(hashtags);
        }
        CqlSession session = this.conn.getKeyspaceSession();
        for (String hashtag : noduplicatesHashtags) {
            String lowerCaseHashtag = hashtag.toLowerCase();
            boolean firstDelete = session.execute((Statement)DBCassandraAstyanaxImpl.deleteHashtagCommentEntry(session).bind(new Object[]{lowerCaseHashtag, UUID.fromString(commentId)})).wasApplied();
            if (firstDelete) {
                boolean secondInsert = this.updateVREHashtagCount(vreid, lowerCaseHashtag, false);
                if (firstDelete && secondInsert) continue;
                _log.error("deleteHashTags: Could not delete the hashtag(s)");
                return false;
            }
            _log.error("deleteHashTags: Could not delete the hashtag(s)");
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Integer> getVREHashtagsWithOccurrence(String vreid) {
        ResultSet result = null;
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtagsCounter").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        List rows = result.all();
        for (Row row : rows) {
            Integer curValue = (int)row.getLong("count");
            if (curValue <= 0) continue;
            toReturn.put(row.getString("hashtag"), curValue);
        }
        return toReturn;
    }

    @Override
    public Map<String, Integer> getVREHashtagsWithOccurrenceFilteredByTime(String vreid, long timestamp) {
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtagsCounter").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        List rows = result.all();
        for (Row row : rows) {
            int curValue;
            List<Post> feeds = null;
            try {
                feeds = this.getVREPostsByHashtag(vreid, row.getString("hashtag"));
            }
            catch (Exception e) {
                _log.error("Unable to retrieve the list of feeds for hashtag" + row.getString("hashtag") + " in vre " + vreid);
                continue;
            }
            if (feeds.isEmpty()) {
                _log.debug("There are no feeds containing hashtag " + row.getString("hashtag") + " in  vre " + vreid);
                continue;
            }
            Collections.sort(feeds, Collections.reverseOrder());
            if (feeds.get(0).getTime().getTime() < timestamp || (curValue = (int)row.getLong("count")) <= 0) continue;
            toReturn.put(row.getString("hashtag"), curValue);
        }
        return toReturn;
    }

    @Override
    public List<Feed> getVREFeedsByHashtag(String vreid, String hashtag) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        ArrayList<Feed> toReturn = new ArrayList();
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet resultPost = null;
        PreparedStatement stmtFind1 = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtaggedPosts").all().whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            resultPost = session.execute((Statement)stmtFind1.bind(new Object[]{hashtag}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PreparedStatement stmtFind2 = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtaggedComments").all().whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet resultComment = null;
        try {
            resultComment = session.execute((Statement)stmtFind2.bind(new Object[]{hashtag}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashSet<String> postIds = new HashSet<String>();
        List rowsPost = resultPost.all();
        for (Row row : rowsPost) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            postIds.add(row.getUuid("postid").toString());
        }
        List rowsComment = resultComment.all();
        for (Row row : rowsComment) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            try {
                Comment c = this.readCommentById(row.getUuid("commentid").toString());
                postIds.add(c.getFeedid());
            }
            catch (CommentIDNotFoundException e) {
                _log.warn("Failed to fetch comment with id " + row.getString("commentid"));
            }
        }
        toReturn = this.getFeedsByIds(new ArrayList<String>(postIds));
        return toReturn;
    }

    @Override
    public List<Post> getVREPostsByHashtag(String vreid, String hashtag) throws PrivacyLevelTypeNotFoundException, FeedTypeNotFoundException, FeedIDNotFoundException, ColumnNameNotFoundException {
        ArrayList<Post> toReturn = new ArrayList();
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet resultPost = null;
        PreparedStatement stmtFind1 = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtaggedPosts").all().whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            resultPost = session.execute((Statement)stmtFind1.bind(new Object[]{hashtag}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PreparedStatement stmtFind2 = session.prepare(((Select)QueryBuilder.selectFrom((String)"HashtaggedComments").all().whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet resultComment = null;
        try {
            resultComment = session.execute((Statement)stmtFind2.bind(new Object[]{hashtag}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashSet<String> postIds = new HashSet<String>();
        List rowsPost = resultPost.all();
        for (Row row : rowsPost) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            postIds.add(row.getUuid("postid").toString());
        }
        List rowsComment = resultComment.all();
        for (Row row : rowsComment) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            try {
                Comment c = this.readCommentById(row.getUuid("commentid").toString());
                postIds.add(c.getFeedid());
            }
            catch (CommentIDNotFoundException e) {
                _log.warn("Failed to fetch comment with id " + row.getString("commentid"));
            }
        }
        toReturn = this.getPostsByIds(new ArrayList<String>(postIds));
        return toReturn;
    }

    private List<BoundStatement> insertIntoInvites(CqlSession session, Invite invite) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("senderuserid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("vreid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("email", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("controlcode", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("status", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("timestamp", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt7 = session.prepare(QueryBuilder.insertInto((String)"Invites").value("inviteid", (Term)QueryBuilder.bindMarker()).value("senderfullname", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        if (invite.getSenderUserId() != null) {
            boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getSenderUserId()}));
        }
        if (invite.getVreid() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getVreid()}));
        }
        if (invite.getInvitedEmail() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getInvitedEmail()}));
        }
        if (invite.getControlCode() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getControlCode()}));
        }
        if (invite.getStatus() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getStatus().toString()}));
        }
        if (invite.getTime() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getTime().toInstant()}));
        }
        if (invite.getSenderFullName() != null) {
            boundStatements.add(prepStmt7.bind(new Object[]{UUID.fromString(invite.getKey()), invite.getSenderFullName()}));
        }
        return boundStatements;
    }

    private List<BoundStatement> initSaveInvite(Invite invite, CqlSession session) {
        List<BoundStatement> boundStatements = this.insertIntoInvites(session, invite);
        if (invite == null) {
            throw new NullArgumentException("Invite instance is null");
        }
        return boundStatements;
    }

    @Override
    public String isExistingInvite(String vreid, String email) {
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind1 = session.prepare(((Select)QueryBuilder.selectFrom((String)"EmailInvites").all().whereColumn("email").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind1.bind(new Object[]{email}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            if (row.getString("vreid").compareTo(vreid) != 0) continue;
            return row.getUuid("inviteid").toString();
        }
        return null;
    }

    @Override
    public InviteOperationResult saveInvite(Invite invite) throws AddressException {
        if (invite == null) {
            throw new NullArgumentException("Invite instance is null");
        }
        String email = invite.getInvitedEmail();
        if (!this.verifyEmail(email)) {
            throw new AddressException("Email is not valid ->" + email);
        }
        if (invite.getVreid() == null || invite.getVreid().equals("")) {
            throw new NullArgumentException("VREId is null or empty");
        }
        _log.debug("isExistingInvite? " + invite.getInvitedEmail() + " in " + invite.getVreid());
        if (this.isExistingInvite(invite.getVreid(), invite.getInvitedEmail()) != null) {
            return InviteOperationResult.ALREADY_INVITED;
        }
        _log.debug("Invite not found, proceed to save it ...");
        CqlSession session = this.conn.getKeyspaceSession();
        List<BoundStatement> boundStatements = this.initSaveInvite(invite, session);
        boundStatements.add(DBCassandraAstyanaxImpl.createNewVreInviteEntry(session).bind(new Object[]{invite.getVreid(), UUID.fromString(invite.getKey()), InviteStatus.PENDING.toString()}));
        boundStatements.add(DBCassandraAstyanaxImpl.createNewEmailInviteEntry(session).bind(new Object[]{email, invite.getVreid(), UUID.fromString(invite.getKey())}));
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements);
        boolean result = session.execute((Statement)writeBatch).wasApplied();
        return result ? InviteOperationResult.SUCCESS : InviteOperationResult.FAILED;
    }

    @Override
    public Invite readInvite(String inviteid) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        Invite toReturn = null;
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Invites").all().whereColumn("inviteid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(inviteid)}));
            toReturn = DBCassandraAstyanaxImpl.readAInviteFromRow((Row)result.one());
            if (toReturn == null) {
                throw new InviteStatusNotFoundException("The requested inviteid: " + inviteid + " is not existing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private List<Invite> getInvitesById(List<String> inviteIds) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        ArrayList<Invite> toReturn = new ArrayList<Invite>();
        for (String inviteid : inviteIds) {
            toReturn.add(this.readInvite(inviteid));
        }
        return toReturn;
    }

    @Override
    public boolean setInviteStatus(String vreid, String email, InviteStatus status) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        String inviteid = this.isExistingInvite(vreid, email);
        Invite toSet = this.readInvite(inviteid);
        if (toSet == null) {
            throw new InviteIDNotFoundException("The specified invite to set with id: " + inviteid + " does not exist");
        }
        CqlSession session = this.conn.getKeyspaceSession();
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)DBCassandraAstyanaxImpl.updateInviteEntry(session, "status").bind(new Object[]{status.toString(), UUID.fromString(inviteid)})).add((BatchableStatement)DBCassandraAstyanaxImpl.updateVreInviteEntry(session, "status").bind(new Object[]{status.toString(), vreid, UUID.fromString(inviteid)}));
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            _log.error("ERROR while setting Invite " + inviteid + " to " + status.toString());
            return false;
        }
        _log.trace("Invite Status Set to " + status.toString() + " OK");
        return true;
    }

    @Override
    public List<Invite> getInvitedEmailsByVRE(String vreid, InviteStatus ... status) throws InviteIDNotFoundException, InviteStatusNotFoundException {
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"VREInvites").all().whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{vreid}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> invitesIds = new ArrayList<String>();
        List rows = result.all();
        for (Row row : rows) {
            if (status != null) {
                for (int i = 0; i < status.length; ++i) {
                    if (row.getString("status").compareTo(status[i].toString()) != 0) continue;
                    invitesIds.add(row.getUuid("inviteid").toString());
                }
                continue;
            }
            invitesIds.add(row.getUuid("inviteid").toString());
        }
        return this.getInvitesById(invitesIds);
    }

    @Override
    public List<Attachment> getAttachmentsByFeedId(String feedId) throws FeedIDNotFoundException {
        Post toCheck = null;
        try {
            toCheck = this.readPost(feedId);
            if (toCheck == null) {
                throw new FeedIDNotFoundException("Could not find Feed with id " + feedId, feedId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<Attachment> toReturn = new ArrayList<Attachment>();
        CqlSession session = this.conn.getKeyspaceSession();
        PreparedStatement stmtFind = session.prepare(((Select)QueryBuilder.selectFrom((String)"Attachments").all().whereColumn("postid").isEqualTo((Term)QueryBuilder.bindMarker())).build());
        ResultSet result = null;
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[]{UUID.fromString(feedId)}));
            List rows = result.all();
            for (Row row : rows) {
                _log.trace("Reading attachment if feed=" + row.getUuid("postid").toString());
                Attachment toAdd = DBCassandraAstyanaxImpl.readAttachmentFromRow(row);
                toReturn.add(toAdd);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return toReturn;
    }

    @Override
    public void closeConnection() {
        this.conn.closeConnection();
    }

    private List<BoundStatement> insertIntoAttachments(CqlSession session, Attachment attachment, String feedId) {
        PreparedStatement prepStmt1 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("postid", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt2 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("uri", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt3 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("name", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt4 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("description", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt5 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("urithumbnail", (Term)QueryBuilder.bindMarker()).build());
        PreparedStatement prepStmt6 = session.prepare(QueryBuilder.insertInto((String)"Attachments").value("attachid", (Term)QueryBuilder.bindMarker()).value("mimetype", (Term)QueryBuilder.bindMarker()).build());
        ArrayList<BoundStatement> boundStatements = new ArrayList<BoundStatement>();
        boundStatements.add(prepStmt1.bind(new Object[]{UUID.fromString(attachment.getId()), UUID.fromString(feedId)}));
        if (attachment.getUri() != null) {
            boundStatements.add(prepStmt2.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getUri()}));
        }
        if (attachment.getName() != null) {
            boundStatements.add(prepStmt3.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getName()}));
        }
        if (attachment.getDescription() != null) {
            boundStatements.add(prepStmt4.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getDescription()}));
        }
        if (attachment.getThumbnailURL() != null) {
            boundStatements.add(prepStmt5.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getThumbnailURL()}));
        }
        if (attachment.getMimeType() != null) {
            boundStatements.add(prepStmt6.bind(new Object[]{UUID.fromString(attachment.getId()), attachment.getMimeType()}));
        }
        return boundStatements;
    }

    @Override
    public boolean saveAttachmentEntry(String feedId, Attachment toSave) {
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            List<BoundStatement> boundStatements = this.insertIntoAttachments(session, toSave, feedId);
            BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().addAll(boundStatements);
            ResultSet res = session.execute((Statement)writeBatch);
            _log.debug(res.getExecutionInfos().toString());
            _log.debug("" + res.wasApplied());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private NotificationChannelType getChannelType(String channelName) throws NotificationChannelTypeNotFoundException {
        if (channelName.compareTo("PORTAL") == 0) {
            return NotificationChannelType.PORTAL;
        }
        if (channelName.compareTo("EMAIL") == 0) {
            return NotificationChannelType.EMAIL;
        }
        if (channelName.compareTo("TWITTER") == 0) {
            return NotificationChannelType.TWITTER;
        }
        throw new NotificationChannelTypeNotFoundException("The Notification Channel Type was not recognized should be one of " + String.valueOf(NotificationChannelType.values()) + " asked for: " + channelName);
    }

    private static PrivacyLevel getPrivacyLevel(String privacyLevel) throws PrivacyLevelTypeNotFoundException {
        if (privacyLevel.compareTo("CONNECTION") == 0) {
            return PrivacyLevel.CONNECTION;
        }
        if (privacyLevel.compareTo("PRIVATE") == 0) {
            return PrivacyLevel.PRIVATE;
        }
        if (privacyLevel.compareTo("PUBLIC") == 0) {
            return PrivacyLevel.PUBLIC;
        }
        if (privacyLevel.compareTo("VRES") == 0) {
            return PrivacyLevel.VRES;
        }
        if (privacyLevel.compareTo("SINGLE_VRE") == 0) {
            return PrivacyLevel.SINGLE_VRE;
        }
        if (privacyLevel.compareTo("PORTAL") == 0) {
            return PrivacyLevel.PORTAL;
        }
        throw new PrivacyLevelTypeNotFoundException("The Privacy Level was not recognized should be one of " + String.valueOf(PrivacyLevel.values()) + " asked for: " + privacyLevel);
    }

    private static FeedType getFeedType(String type) throws FeedTypeNotFoundException {
        if (type.compareTo("TWEET") == 0) {
            return FeedType.TWEET;
        }
        if (type.compareTo("JOIN") == 0) {
            return FeedType.JOIN;
        }
        if (type.compareTo("PUBLISH") == 0) {
            return FeedType.PUBLISH;
        }
        if (type.compareTo("SHARE") == 0) {
            return FeedType.SHARE;
        }
        if (type.compareTo("ACCOUNTING") == 0) {
            return FeedType.ACCOUNTING;
        }
        if (type.compareTo("DISABLED") == 0) {
            return FeedType.DISABLED;
        }
        throw new FeedTypeNotFoundException("The Feed Type was not recognized should be one of " + String.valueOf(FeedType.values()) + " asked for: " + type);
    }

    private static PostType getPostType(String type) throws FeedTypeNotFoundException {
        if (type.compareTo("TWEET") == 0) {
            return PostType.TWEET;
        }
        if (type.compareTo("JOIN") == 0) {
            return PostType.JOIN;
        }
        if (type.compareTo("PUBLISH") == 0) {
            return PostType.PUBLISH;
        }
        if (type.compareTo("SHARE") == 0) {
            return PostType.SHARE;
        }
        if (type.compareTo("ACCOUNTING") == 0) {
            return PostType.ACCOUNTING;
        }
        if (type.compareTo("DISABLED") == 0) {
            return PostType.DISABLED;
        }
        throw new FeedTypeNotFoundException("The Feed Type was not recognized should be one of " + String.valueOf(PostType.values()) + " asked for: " + type);
    }

    private static InviteStatus getInviteStatusType(String type) throws InviteStatusNotFoundException {
        switch (type) {
            case "PENDING": {
                return InviteStatus.PENDING;
            }
            case "ACCEPTED": {
                return InviteStatus.ACCEPTED;
            }
            case "REJECTED": {
                return InviteStatus.REJECTED;
            }
            case "RETRACTED": {
                return InviteStatus.RETRACTED;
            }
        }
        throw new InviteStatusNotFoundException("The Invite Status was not recognized should be one of " + String.valueOf(InviteStatus.values()) + " asked for: " + type);
    }

    private static NotificationType getNotificationType(String type) throws NotificationTypeNotFoundException {
        if (type.compareTo("WP_FOLDER_SHARE") == 0) {
            return NotificationType.WP_FOLDER_SHARE;
        }
        if (type.compareTo("WP_FOLDER_UNSHARE") == 0) {
            return NotificationType.WP_FOLDER_UNSHARE;
        }
        if (type.compareTo("WP_ADMIN_UPGRADE") == 0) {
            return NotificationType.WP_ADMIN_UPGRADE;
        }
        if (type.compareTo("WP_ADMIN_DOWNGRADE") == 0) {
            return NotificationType.WP_ADMIN_DOWNGRADE;
        }
        if (type.compareTo("WP_FOLDER_RENAMED") == 0) {
            return NotificationType.WP_FOLDER_RENAMED;
        }
        if (type.compareTo("WP_FOLDER_ADDEDUSER") == 0) {
            return NotificationType.WP_FOLDER_ADDEDUSER;
        }
        if (type.compareTo("WP_FOLDER_REMOVEDUSER") == 0) {
            return NotificationType.WP_FOLDER_REMOVEDUSER;
        }
        if (type.compareTo("WP_ITEM_DELETE") == 0) {
            return NotificationType.WP_ITEM_DELETE;
        }
        if (type.compareTo("WP_ITEM_UPDATED") == 0) {
            return NotificationType.WP_ITEM_UPDATED;
        }
        if (type.compareTo("WP_ITEM_NEW") == 0) {
            return NotificationType.WP_ITEM_NEW;
        }
        if (type.compareTo("WP_ITEM_RENAMED") == 0) {
            return NotificationType.WP_ITEM_RENAMED;
        }
        if (type.compareTo("OWN_COMMENT") == 0) {
            return NotificationType.OWN_COMMENT;
        }
        if (type.compareTo("COMMENT") == 0) {
            return NotificationType.COMMENT;
        }
        if (type.compareTo("MENTION") == 0) {
            return NotificationType.MENTION;
        }
        if (type.compareTo("LIKE") == 0) {
            return NotificationType.LIKE;
        }
        if (type.compareTo("CALENDAR_ADDED_EVENT") == 0) {
            return NotificationType.CALENDAR_ADDED_EVENT;
        }
        if (type.compareTo("CALENDAR_UPDATED_EVENT") == 0) {
            return NotificationType.CALENDAR_UPDATED_EVENT;
        }
        if (type.compareTo("CALENDAR_DELETED_EVENT") == 0) {
            return NotificationType.CALENDAR_DELETED_EVENT;
        }
        if (type.compareTo("CALENDAR_ADDED_EVENT") == 0) {
            return NotificationType.CALENDAR_ADDED_EVENT;
        }
        if (type.compareTo("CALENDAR_UPDATED_EVENT") == 0) {
            return NotificationType.CALENDAR_UPDATED_EVENT;
        }
        if (type.compareTo("CALENDAR_DELETED_EVENT") == 0) {
            return NotificationType.CALENDAR_DELETED_EVENT;
        }
        if (type.compareTo("MESSAGE") == 0) {
            return NotificationType.MESSAGE;
        }
        if (type.compareTo("POST_ALERT") == 0) {
            return NotificationType.POST_ALERT;
        }
        if (type.compareTo("REQUEST_CONNECTION") == 0) {
            return NotificationType.REQUEST_CONNECTION;
        }
        if (type.compareTo("JOB_COMPLETED_NOK") == 0) {
            return NotificationType.JOB_COMPLETED_NOK;
        }
        if (type.compareTo("JOB_COMPLETED_OK") == 0) {
            return NotificationType.JOB_COMPLETED_OK;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_EDIT") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_EDIT;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_VIEW") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_VIEW;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_FORWARD_STEP_COMPLETED_OWNER") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_FORWARD_STEP_COMPLETED_OWNER;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_STEP_FORWARD_PEER") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_STEP_FORWARD_PEER;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_STEP_REQUEST_TASK") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_STEP_REQUEST_TASK;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_USER_FORWARD_TO_OWNER") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_USER_FORWARD_TO_OWNER;
        }
        if (type.compareTo("DOCUMENT_WORKFLOW_FIRST_STEP_REQUEST_INVOLVMENT") == 0) {
            return NotificationType.DOCUMENT_WORKFLOW_FIRST_STEP_REQUEST_INVOLVMENT;
        }
        if (type.compareTo("TDM_TAB_RESOURCE_SHARE") == 0) {
            return NotificationType.TDM_TAB_RESOURCE_SHARE;
        }
        if (type.compareTo("TDM_RULE_SHARE") == 0) {
            return NotificationType.TDM_RULE_SHARE;
        }
        if (type.compareTo("TDM_TEMPLATE_SHARE") == 0) {
            return NotificationType.TDM_TEMPLATE_SHARE;
        }
        if (type.compareTo("CAT_ITEM_SUBMITTED") == 0) {
            return NotificationType.CAT_ITEM_SUBMITTED;
        }
        if (type.compareTo("CAT_ITEM_REJECTED") == 0) {
            return NotificationType.CAT_ITEM_REJECTED;
        }
        if (type.compareTo("CAT_ITEM_PUBLISHED") == 0) {
            return NotificationType.CAT_ITEM_PUBLISHED;
        }
        if (type.compareTo("CAT_ITEM_UPDATED") == 0) {
            return NotificationType.CAT_ITEM_UPDATED;
        }
        if (type.compareTo("CAT_ITEM_DELETE") == 0) {
            return NotificationType.CAT_ITEM_DELETE;
        }
        if (type.compareTo("GENERIC") == 0) {
            return NotificationType.GENERIC;
        }
        throw new NotificationTypeNotFoundException("The Notification Type was not recognized should be one of " + String.valueOf(NotificationType.values()) + " asked for: " + type);
    }

    private Date getDateFromTimeInMillis(String time) {
        Long timeInMillis = Long.parseLong(time);
        Calendar toSet = Calendar.getInstance();
        toSet.setTimeInMillis(timeInMillis);
        return toSet.getTime();
    }

    private boolean updateFeedCommentsCount(Feed toUpdate, boolean increment) {
        int newCount = 0;
        try {
            int current = Integer.parseInt(toUpdate.getCommentsNo());
            newCount = increment ? current + 1 : current - 1;
        }
        catch (NumberFormatException e) {
            _log.error("Comments Number found is not a number: " + toUpdate.getCommentsNo());
        }
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            session.execute((Statement)DBCassandraAstyanaxImpl.updatePostEntry(session, "commentsno").bind(new Object[]{(long)newCount, UUID.fromString(toUpdate.getKey())}));
        }
        catch (Exception e) {
            _log.error("CommentsNo update NOT OK ");
            return false;
        }
        _log.debug("CommentsNo update OK to: " + newCount);
        return true;
    }

    private boolean updateFeedLikesCount(Feed toUpdate, boolean increment) {
        int newCount = 0;
        try {
            int current = Integer.parseInt(toUpdate.getLikesNo());
            newCount = increment ? current + 1 : current - 1;
        }
        catch (NumberFormatException e) {
            _log.error("Likes Number found is not a number: " + toUpdate.getLikesNo());
        }
        CqlSession session = this.conn.getKeyspaceSession();
        try {
            session.execute((Statement)DBCassandraAstyanaxImpl.updatePostEntry(session, "likesno").bind(new Object[]{(long)newCount, UUID.fromString(toUpdate.getKey())}));
        }
        catch (Exception e) {
            _log.error("LikesNo update NOT OK ");
            return false;
        }
        _log.debug("LikesNo update OK to: " + newCount);
        return true;
    }

    private boolean updateVREHashtagCount(String vreid, String hashtag, boolean increment) {
        Map<String, Integer> vreHashtags = this.getVREHashtagsWithOccurrence(vreid);
        int newCount = 0;
        if (!vreHashtags.containsKey(hashtag)) {
            newCount = 1;
        } else {
            try {
                int current = vreHashtags.get(hashtag);
                newCount = increment ? current + 1 : current - 1;
            }
            catch (NumberFormatException e) {
                _log.error("Hashtag Number found is not a number: " + newCount);
            }
        }
        _log.debug("Updating counter for " + hashtag + " to " + newCount);
        CqlSession session = this.conn.getKeyspaceSession();
        BoundStatement stmt = DBCassandraAstyanaxImpl.existRecordbyCompId(session, "hashtag", "vreid", hashtag, vreid, "HashtagsCounter") ? session.prepare(((Update)((Update)QueryBuilder.update((String)"HashtagsCounter").setColumn("count", (Term)QueryBuilder.bindMarker()).whereColumn("hashtag").isEqualTo((Term)QueryBuilder.bindMarker())).whereColumn("vreid").isEqualTo((Term)QueryBuilder.bindMarker())).build()).bind(new Object[]{(long)newCount, hashtag, vreid}) : DBCassandraAstyanaxImpl.createNewUHashtagCounterEntry(session).bind(new Object[]{vreid, hashtag, (long)newCount});
        BatchStatement writeBatch = DBCassandraAstyanaxImpl.getBatch().add((BatchableStatement)stmt);
        try {
            session.execute((Statement)writeBatch);
        }
        catch (Exception e) {
            _log.error("Hashtag Count update NOT OK ");
            return false;
        }
        _log.debug("Hashtag Count update OK to: " + newCount);
        return true;
    }

    private boolean verifyEmail(String email) {
        boolean isValid = false;
        try {
            InternetAddress internetAddress = new InternetAddress(email);
            internetAddress.validate();
            isValid = true;
        }
        catch (AddressException e) {
            _log.error("Validation Exception Occurred for email: " + email);
        }
        return isValid;
    }

    @Override
    public List<String> getAllVREIds() {
        HashSet<String> ids = new HashSet<String>();
        CqlSession session = this.conn.getKeyspaceSession();
        ResultSet result = null;
        PreparedStatement stmtFind = session.prepare(QueryBuilder.selectFrom((String)"VRETimeline").column("vreid").all().build());
        try {
            result = session.execute((Statement)stmtFind.bind(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List rows = result.all();
        for (Row row : rows) {
            ids.add(row.getString("vreid"));
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.addAll(ids);
        _log.debug("VRE ids are " + String.valueOf(ids));
        return toReturn;
    }
}

