package org.gcube.portal.databook.shared;

import java.util.Date;
import java.util.List;

public class MessageSent extends Message {
    protected boolean read;
    protected boolean opened;
    protected String recipientid;

    protected boolean deleted;

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public MessageSent(String id, String userid, String user_name, List<String> addresses, String subject,
            String body,
            Date timestamp, boolean with_attachments, boolean read, boolean opened, boolean deleted) {
        super(id, userid, user_name, addresses, subject, body, timestamp, with_attachments);
        this.deleted = deleted;
        this.read = read;
        this.opened = opened;
    }

    public MessageSent(Message message, boolean read, boolean opened, boolean deleted) {
        super(message.getId(), message.getUser_id(), message.getUser_name(), message.getAddresses(),
                message.getSubject(), message.getBody(), message.getCreation_time(), message.isWith_attachments());
        this.deleted = deleted;
        this.read = read;
        this.opened = opened;
    }

    @Override
    public String toString() {
        return "SentMessage [id=" + id + ", user_id=" + user_id + ", creation_time=" + creation_time
                + ", addresses=" + addresses + ", subject=" + subject + ", body="
                + body + ", with_attachments=" + with_attachments + ", read="
                + read + ", opened=" + opened + ", deleted=" + deleted + "]";
    }

    public boolean isRead() {
        return read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isOpened() {
        return opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

}
