/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import java.util.List;
import java.util.Map;
import org.gcube.portal.databook.server.BaseDbTest;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.databook.shared.ex.NotificationChannelTypeNotFoundException;
import org.gcube.portal.databook.shared.ex.NotificationTypeNotFoundException;
import org.junit.Assert;
import org.junit.Test;

public class NotificationsTest
extends BaseDbTest {
    protected String userId = "alfredo.oliviero";

    @Test
    public void baseQuery() throws Exception {
        SimpleStatement test_count;
        CqlSession session = this.getConnection().getKeyspaceSession();
        ResultSet result = session.execute((Statement)(test_count = SimpleStatement.builder((String)"select * from vretimeline limit 1").build()));
        List all = result.all();
        Assert.assertTrue((all.size() == 1 ? 1 : 0) != 0);
        System.out.print("baseTest found" + all.get(0));
    }

    @Test
    public void preferencesNotificatonsConfig() throws NotificationTypeNotFoundException, NotificationChannelTypeNotFoundException, Exception {
        Map preferences = this.getStore().getUserNotificationPreferences(this.userId);
        for (NotificationType type : preferences.keySet()) {
            System.out.println("## preferences type " + type);
            for (NotificationChannelType channelType : (NotificationChannelType[])preferences.get(type)) {
                System.out.println("## -- " + channelType);
            }
        }
    }

    @Test
    public void prefNotificatonChannels() throws NotificationChannelTypeNotFoundException, NotificationTypeNotFoundException, Exception {
        List channels = this.getStore().getUserNotificationChannels(this.userId, NotificationType.CAT_ITEM_PUBLISHED);
        for (NotificationChannelType channel : channels) {
            System.out.println("## -- " + channel);
        }
    }

    @Test
    public void getCatPreferencesQuery() throws Exception {
        Select select = (Select)((Select)QueryBuilder.selectFrom((String)"UserNotificationsPreferences").all().whereColumn("userid").isEqualTo((Term)QueryBuilder.literal((Object)this.userId))).whereColumn("type").in(new Term[]{QueryBuilder.literal((Object)"CAT_ITEM_DELETE"), QueryBuilder.literal((Object)"CAT_ITEM_PUBLISHED"), QueryBuilder.literal((Object)"CAT_ITEM_REJECTED"), QueryBuilder.literal((Object)"CAT_ITEM_SUBMITTED"), QueryBuilder.literal((Object)"CAT_ITEM_UPDATED")});
        SimpleStatement statement = select.build();
        CqlSession session = this.getConnection().getKeyspaceSession();
        ResultSet resultSet = session.execute((Statement)statement);
        for (Row row : resultSet) {
            String userId = row.getString("userid");
            String type = row.getString("type");
            System.out.println("UserId: " + userId + ", Type: " + type);
        }
    }

    @Test
    public void deleteCatPreferencesQuery() throws Exception {
        Delete delete = (Delete)((Delete)QueryBuilder.deleteFrom((String)"UserNotificationsPreferences").whereColumn("userid").isEqualTo((Term)QueryBuilder.literal((Object)this.userId))).whereColumn("type").in(new Term[]{QueryBuilder.literal((Object)"CAT_ITEM_DELETE"), QueryBuilder.literal((Object)"CAT_ITEM_PUBLISHED"), QueryBuilder.literal((Object)"CAT_ITEM_REJECTED"), QueryBuilder.literal((Object)"CAT_ITEM_SUBMITTED"), QueryBuilder.literal((Object)"CAT_ITEM_UPDATED")});
        SimpleStatement statement = delete.build();
        CqlSession session = this.getConnection().getKeyspaceSession();
        ResultSet resultSet = session.execute((Statement)statement);
        for (Row row : resultSet) {
            System.out.println(row.getFormattedContents());
        }
    }
}

