/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gcube.portal.databook.server.BaseDbTest;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Message;
import org.gcube.portal.databook.shared.MessageReceived;
import org.gcube.portal.databook.shared.MessageSent;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.ex.NotificationTypeNotFoundException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessagesTest
extends BaseDbTest {
    private String testFrom;
    private String recipient;
    private String recipient2;
    private String subject;
    private String body;
    private List<String> recipients;

    @Override
    @Before
    public void setUp() throws Exception {
        this.testFrom = "alfredo.oliviero@isti.cnr.it";
        this.recipient = "massimiliano.assante@isti.cnr.it";
        this.recipient2 = "andrea.rossi@isti.cnr.it";
        this.subject = "test subject";
        this.body = "test body";
        this.recipients = Arrays.asList(this.recipient, this.recipient2);
        this.store = this.getStore();
    }

    @Override
    @Test
    public void empty() {
        System.out.print("Testing works");
    }

    @Test
    public void testCreateMessage() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, this.subject, this.body, null);
        Assert.assertNotNull((String)"Message should not be null after creation", (Object)message);
        Assert.assertEquals((String)"User ID does not match", (Object)this.testFrom, (Object)message.getUser_id());
        Assert.assertEquals((String)"Recipient does not match", (Object)this.recipient, message.getAddresses().get(0));
        Assert.assertEquals((String)"Subject does not match", (Object)this.subject, (Object)message.getSubject());
        Assert.assertEquals((String)"Body does not match", (Object)this.body, (Object)message.getBody());
        MessageSent messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        Assert.assertNotNull((String)"Sent message should not be null", (Object)messageSent);
        Assert.assertEquals((String)"User ID of sent message does not match", (Object)this.testFrom, (Object)messageSent.getUser_id());
        Assert.assertEquals((String)"Recipient of sent message does not match", (Object)this.recipient, messageSent.getAddresses().get(0));
        Assert.assertEquals((String)"Subject of sent message does not match", (Object)this.subject, (Object)messageSent.getSubject());
        Assert.assertEquals((String)"Body of sent message does not match", (Object)this.body, (Object)messageSent.getBody());
        MessageReceived messageReceived = this.store.getReceivedMessageById(this.recipient, message.getId());
        Assert.assertNotNull((String)"Received message should not be null", (Object)messageReceived);
        Assert.assertEquals((String)"User ID of received message does not match", (Object)this.testFrom, (Object)messageReceived.getUser_id());
        Assert.assertEquals((String)"Recipient of received message does not match", (Object)this.recipient, (Object)messageReceived.getRecipient_id());
        Assert.assertEquals((String)"Subject of received message does not match", (Object)this.subject, (Object)messageReceived.getSubject());
        Assert.assertEquals((String)"Body of received message does not match", (Object)this.body, (Object)messageReceived.getBody());
        MessageReceived messageReceived2 = this.store.getReceivedMessageById(this.recipient2, message.getId());
        Assert.assertNotNull((String)"Received2 message should not be null", (Object)messageReceived2);
        Assert.assertEquals((String)"User ID of received2 message does not match", (Object)this.testFrom, (Object)messageReceived2.getUser_id());
        Assert.assertEquals((String)"Recipient of received2 message does not match", (Object)this.recipient2, (Object)messageReceived2.getRecipient_id());
        Assert.assertEquals((String)"Subject of received2 message does not match", (Object)this.subject, (Object)messageReceived2.getSubject());
        Assert.assertEquals((String)"Body of received2 message does not match", (Object)this.body, (Object)messageReceived2.getBody());
    }

    @Test
    public void testMessagesReceivedByRecipient() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, "testMessagesReceivedByRecipient", this.body, null);
        Assert.assertNotNull((Object)message);
        List receiveds = this.store.getReceivedMessagesByRecipient(this.recipient, null, null);
        MessageReceived received = (MessageReceived)receiveds.get(0);
        Assert.assertNotNull((Object)received);
    }

    @Test
    public void testUnreadMessagesReceivedByRecipient() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, "testUnreadMessagesReceivedByRecipient", this.body, null);
        Assert.assertNotNull((Object)message);
        List receiveds = this.store.getReceivedMessagesByRecipient(this.recipient, null, null, Integer.valueOf(1), Boolean.valueOf(false), Boolean.valueOf(false), null);
        MessageReceived received = (MessageReceived)receiveds.get(0);
        Assert.assertFalse((boolean)received.isRead());
        Assert.assertNotNull((Object)received);
    }

    @Test
    public void testMessageReceivedById() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, "testMessageReceivedById", this.body, null);
        String msg_id = message.getId();
        MessageReceived received = this.store.getReceivedMessageById(this.recipient, msg_id);
        Assert.assertNotNull((Object)received);
        Assert.assertEquals((Object)received.getId(), (Object)msg_id);
    }

    @Test
    public void testSetSentMessageReadUnread() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, "testSetSentMessageReadUnread", this.body, null);
        Assert.assertNotNull((Object)message);
        String recipient = this.recipients.get(0);
        String recipient1 = this.recipients.get(1);
        MessageSent messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        MessageReceived messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        MessageReceived messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageSent);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        MessageSent sentMessageUpdate = this.store.setSentMessageRead(this.testFrom, message.getId(), true);
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)sentMessageUpdate);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertTrue((boolean)messageSent.isRead());
        Assert.assertTrue((boolean)sentMessageUpdate.isRead());
        Assert.assertFalse((boolean)messageReceived.isRead());
        Assert.assertFalse((boolean)messageReceived1.isRead());
        sentMessageUpdate = this.store.setSentMessageRead(this.testFrom, message.getId(), false);
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)sentMessageUpdate);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertFalse((boolean)messageSent.isRead());
        Assert.assertFalse((boolean)sentMessageUpdate.isRead());
        Assert.assertFalse((boolean)messageReceived.isRead());
        Assert.assertFalse((boolean)messageReceived1.isRead());
        sentMessageUpdate = this.store.setSentMessageRead(this.testFrom, message.getId(), true);
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)sentMessageUpdate);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertTrue((boolean)messageSent.isRead());
        Assert.assertTrue((boolean)sentMessageUpdate.isRead());
        Assert.assertFalse((boolean)messageReceived.isRead());
        Assert.assertFalse((boolean)messageReceived1.isRead());
    }

    @Test
    public void testSetReceivedMessageReadUnread() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, "testSetReceivedMessageReadUnread", this.body, null);
        Assert.assertNotNull((Object)message);
        String recipient = this.recipients.get(0);
        String recipient1 = this.recipients.get(1);
        MessageSent messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        MessageReceived messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        MessageReceived messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageSent);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        MessageReceived messageUpdated = this.store.setReceivedMessageRead(recipient, message.getId(), true);
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageUpdated);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertTrue((boolean)messageReceived.isRead());
        Assert.assertTrue((boolean)messageUpdated.isRead());
        Assert.assertFalse((boolean)messageSent.isRead());
        Assert.assertFalse((boolean)messageReceived1.isRead());
        messageUpdated = this.store.setReceivedMessageRead(recipient, message.getId(), false);
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageUpdated);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertFalse((boolean)messageReceived.isRead());
        Assert.assertFalse((boolean)messageUpdated.isRead());
        Assert.assertFalse((boolean)messageSent.isRead());
        Assert.assertFalse((boolean)messageReceived1.isRead());
        messageUpdated = this.store.setReceivedMessageRead(this.recipient2, message.getId(), true);
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageUpdated);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertTrue((boolean)messageReceived1.isRead());
        Assert.assertTrue((boolean)messageUpdated.isRead());
        Assert.assertFalse((boolean)messageSent.isRead());
        Assert.assertFalse((boolean)messageReceived.isRead());
    }

    @Test
    public void testDeleteSentMessage() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, "testDeleteSentMessage", this.body, null);
        Assert.assertNotNull((Object)message);
        String recipient = this.recipients.get(0);
        String recipient1 = this.recipients.get(1);
        MessageSent messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        MessageReceived messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        MessageReceived messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageSent);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertFalse((boolean)messageSent.isDeleted());
        Assert.assertFalse((boolean)messageReceived.isDeleted());
        Assert.assertFalse((boolean)messageReceived.isDeleted());
        MessageSent deletedMessage = this.store.deleteMessageSent(this.testFrom, message.getId());
        Assert.assertNotNull((Object)deletedMessage);
        Assert.assertTrue((boolean)deletedMessage.isDeleted());
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNull((Object)messageSent);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
    }

    @Test
    public void testDeleteReceivedMessage() throws Exception {
        Message message = this.store.sendMessage(this.testFrom, this.recipients, "testDeleteReceivedMessage", this.body, null);
        Assert.assertNotNull((Object)message);
        String recipient = this.recipients.get(0);
        String recipient1 = this.recipients.get(1);
        MessageSent messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        MessageReceived messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        MessageReceived messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageSent);
        Assert.assertNotNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
        Assert.assertFalse((boolean)messageSent.isDeleted());
        Assert.assertFalse((boolean)messageReceived.isDeleted());
        Assert.assertFalse((boolean)messageReceived.isDeleted());
        MessageReceived deletedMessage = this.store.deleteMessageReceived(recipient, message.getId());
        Assert.assertNotNull((Object)deletedMessage);
        Assert.assertTrue((boolean)deletedMessage.isDeleted());
        messageSent = this.store.getSentMessageById(this.testFrom, message.getId());
        messageReceived = this.store.getReceivedMessageById(recipient, message.getId());
        messageReceived1 = this.store.getReceivedMessageById(recipient1, message.getId());
        Assert.assertNotNull((Object)messageSent);
        Assert.assertNull((Object)messageReceived);
        Assert.assertNotNull((Object)messageReceived1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetInvalidIdMessage() {
        this.store.getSentMessageById(this.testFrom, "not-valid-id");
    }

    @Test
    public void testGetNonExistentMessage() {
        MessageSent messageSent = this.store.getSentMessageById(this.testFrom, "ffffaaaa-9d90-4cc8-a634-bf158c7cc068");
        Assert.assertNull((String)"Expected null for non-existent message", (Object)messageSent);
    }

    @Test
    public void testGetNonExistentFrom() {
        MessageSent messageSent = this.store.getSentMessageById("aaaa", "ffffaaaa-9d90-4cc8-a634-bf158c7cc068");
        Assert.assertNull((String)"Expected null for non-existent message", (Object)messageSent);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSaveNewMessageWithNullUserId() {
        this.store.sendMessage(null, this.recipients, this.subject, this.body, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSaveNewMessageWithNullAddresses() {
        this.store.sendMessage(this.testFrom, null, this.subject, this.body, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSaveNewMessageWithEmptyAddresses() {
        this.store.sendMessage(this.testFrom, Arrays.asList(new String[0]), this.subject, this.body, null);
    }

    @Test
    public void testGetSentMessagesOnlyNonDeleted() throws Exception {
        Message message1 = this.store.sendMessage(this.testFrom, this.recipients, this.subject, this.body, null);
        Message message2 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + " deleted", this.body, null);
        this.store.deleteMessageSent(this.testFrom, message2.getId());
        List sentMessages = this.store.getSentMessagesBySender(this.testFrom, null, Integer.valueOf(10));
        Assert.assertNotNull((String)"Sent messages list should not be null", (Object)sentMessages);
        Assert.assertFalse((String)"Sent messages list should not contain deleted messages", (boolean)sentMessages.stream().anyMatch(m -> m.getId().equals(message2.getId())));
        Assert.assertTrue((String)"Sent messages list should contain non-deleted message", (boolean)sentMessages.stream().anyMatch(m -> m.getId().equals(message1.getId())));
    }

    @Test
    public void testSentMessagesOrderedByTimestampDescending() throws Exception {
        Message message1 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "1", this.body, null);
        Assert.assertNotNull((Object)message1);
        Thread.sleep(1000L);
        Message message2 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "2", this.body, null);
        Assert.assertNotNull((Object)message2);
        Thread.sleep(1000L);
        Message message3 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "3", this.body, null);
        Assert.assertNotNull((Object)message3);
        List sentMessages = this.store.getSentMessagesBySender(this.testFrom, null, Integer.valueOf(10));
        Assert.assertNotNull((String)"Sent messages list should not be null", (Object)sentMessages);
        Assert.assertTrue((String)"Sent messages list should contain at least 3 messages", (sentMessages.size() >= 3 ? 1 : 0) != 0);
        Date timestamp1 = ((MessageSent)sentMessages.get(0)).getCreation_time();
        Date timestamp2 = ((MessageSent)sentMessages.get(1)).getCreation_time();
        Date timestamp3 = ((MessageSent)sentMessages.get(2)).getCreation_time();
        Assert.assertTrue((String)"First message should be newer than second", (boolean)timestamp1.after(timestamp2));
        Assert.assertTrue((String)"Second message should be newer than third", (boolean)timestamp2.after(timestamp3));
    }

    @Test
    public void testReceivedMessagesOrderedByTimestampDescending() throws Exception {
        Message message1 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "1", this.body, null);
        Assert.assertNotNull((Object)message1);
        Thread.sleep(1000L);
        Message message2 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "2", this.body, null);
        Assert.assertNotNull((Object)message2);
        Thread.sleep(1000L);
        Message message3 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "3", this.body, null);
        Assert.assertNotNull((Object)message3);
        List receivedMessages = this.store.getReceivedMessagesByRecipient(this.recipient, null, Integer.valueOf(10));
        Assert.assertNotNull((String)"Received messages list should not be null", (Object)receivedMessages);
        Assert.assertTrue((String)"Received messages list should contain at least 3 messages", (receivedMessages.size() >= 3 ? 1 : 0) != 0);
        Date timestamp1 = ((MessageReceived)receivedMessages.get(0)).getCreation_time();
        Date timestamp2 = ((MessageReceived)receivedMessages.get(1)).getCreation_time();
        Date timestamp3 = ((MessageReceived)receivedMessages.get(2)).getCreation_time();
        Assert.assertTrue((String)"First message should be newer than second", (boolean)timestamp1.after(timestamp2));
        Assert.assertTrue((String)"Second message should be newer than third", (boolean)timestamp2.after(timestamp3));
    }

    @Test
    public void testUnreadMessagesOnlyReturned() throws Exception {
        Message message1 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "1", this.body, null);
        Assert.assertNotNull((Object)message1);
        Message message2 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "2", this.body, null);
        this.store.setReceivedMessageRead(this.recipient, message2.getId(), true);
        List unreadMessages = this.store.getReceivedMessagesByRecipient(this.recipient, null, null, Integer.valueOf(10), Boolean.valueOf(false), Boolean.valueOf(false), null);
        Assert.assertNotNull((String)"Unread messages list should not be null", (Object)unreadMessages);
        Assert.assertTrue((String)"Unread messages list should contain only unread messages", (boolean)unreadMessages.stream().allMatch(m -> !m.isRead()));
    }

    @Test
    public void testMessagesWithLimitAndOrder() throws Exception {
        Message message1 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "1", this.body, null);
        Assert.assertNotNull((Object)message1);
        Thread.sleep(1000L);
        Message message2 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "2", this.body, null);
        Assert.assertNotNull((Object)message2);
        Thread.sleep(1000L);
        Message message3 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "3", this.body, null);
        Assert.assertNotNull((Object)message3);
        List sentMessages = this.store.getSentMessagesBySender(this.testFrom, null, Integer.valueOf(2));
        Assert.assertNotNull((String)"Sent messages list should not be null", (Object)sentMessages);
        Assert.assertEquals((String)"Sent messages list should contain 2 messages", (long)2L, (long)sentMessages.size());
        Date timestamp1 = ((MessageSent)sentMessages.get(0)).getCreation_time();
        Date timestamp2 = ((MessageSent)sentMessages.get(1)).getCreation_time();
        Assert.assertTrue((String)"First message should be newer than second", (boolean)timestamp1.after(timestamp2));
    }

    @Test
    public void testRetrieveMessagesWithLimit() throws Exception {
        int count = 4;
        for (int i = 0; i < count; ++i) {
            this.store.sendMessage(this.testFrom, this.recipients, this.subject + " " + i, this.body, null);
        }
        List sentMessages = this.store.getSentMessagesBySender(this.testFrom, null, Integer.valueOf(2));
        Assert.assertNotNull((String)"Sent messages list should not be null", (Object)sentMessages);
        Assert.assertEquals((String)"Only 2 messages should be returned", (long)2L, (long)sentMessages.size());
    }

    @Test
    public void testGetSentMessagesBySenderWithTimestampFilter() throws Exception {
        Message message1 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "1", this.body, null);
        Thread.sleep(1000L);
        Message message2 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "2", this.body, null);
        Thread.sleep(1000L);
        Message message3 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "3", this.body, null);
        Date filterTimestamp = message2.getCreation_time();
        List sentMessages = this.store.getSentMessagesBySender(this.testFrom, filterTimestamp, Integer.valueOf(10));
        Assert.assertNotNull((String)"Sent messages list should not be null", (Object)sentMessages);
        for (MessageSent message : sentMessages) {
            Assert.assertTrue((String)"Message timestamp should be less than or equal to the filter timestamp", (message.getCreation_time().compareTo(filterTimestamp) <= 0 ? 1 : 0) != 0);
        }
        Assert.assertFalse((String)"Message with timestamp greater than filterTimestamp should not be returned", (boolean)sentMessages.stream().anyMatch(m -> m.getId().equals(message3.getId())));
    }

    @Test
    public void testGetReceivedMessagesByRecipientWithTimestampFilter() throws Exception {
        Message message1 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "1", this.body, null);
        Thread.sleep(1000L);
        Message message2 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "2", this.body, null);
        Thread.sleep(1000L);
        Message message3 = this.store.sendMessage(this.testFrom, this.recipients, this.subject + "3", this.body, null);
        Date filterTimestamp = message2.getCreation_time();
        List receivedMessages = this.store.getReceivedMessagesByRecipient(this.recipient, filterTimestamp, Integer.valueOf(10));
        Assert.assertNotNull((String)"Received messages list should not be null", (Object)receivedMessages);
        for (MessageReceived message : receivedMessages) {
            Assert.assertTrue((String)"Message timestamp should be less than or equal to the filter timestamp", (message.getCreation_time().compareTo(filterTimestamp) <= 0 ? 1 : 0) != 0);
        }
        Assert.assertFalse((String)"Message with timestamp greater than filterTimestamp should not be returned", (boolean)receivedMessages.stream().anyMatch(m -> m.getId().equals(message3.getId())));
    }

    @Test
    public void testGetEmptyAttachmentByMessageId() throws Exception {
        Message msg = this.store.sendMessage(this.testFrom, this.recipients, "testGetAttachmentByMessageId", this.body, null);
        List attachs = this.store.getMessageAttachmentsById(msg.getId());
        Assert.assertEquals((String)"attachs list should be empty", (long)attachs.size(), (long)0L);
    }

    @Test
    public void testGetSingleAttachmentByMessageId() throws Exception {
        Attachment attach = new Attachment();
        String attachId = UUID.randomUUID().toString();
        String filename = "file name";
        String description = "file description";
        String uri = "uri";
        String thumb_url = "thumb url";
        attach.setId(attachId);
        attach.setName(filename);
        attach.setDescription(description);
        attach.setUri(uri);
        attach.setThumbnailURL(thumb_url);
        List<Attachment> attachments = Arrays.asList(attach);
        Message msg = this.store.sendMessage(this.testFrom, this.recipients, "testGetAttachmentByMessageId", this.body, attachments);
        List attachs = this.store.getMessageAttachmentsById(msg.getId());
        Assert.assertEquals((String)"attachs list should have 1 element", (long)1L, (long)attachs.size());
        Attachment obtained_attach = (Attachment)attachs.get(0);
        Assert.assertEquals((String)"attachs list should have 1 element", (Object)attach.getId(), (Object)obtained_attach.getId());
        this.checkEqualAttachments(attach, obtained_attach);
    }

    @Test
    public void testMultiSingleAttachmentByMessageId() throws Exception {
        String filename = "file name";
        String description = "file description";
        String uri = "uri";
        String thumb_url = "thumb url";
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        int count = 10;
        for (int i = 0; i < count; ++i) {
            Attachment attach = new Attachment();
            String attachId = UUID.randomUUID().toString();
            attach.setId(attachId);
            attach.setName(filename + " " + i);
            attach.setDescription(description + " " + i);
            attach.setUri(uri + " " + i);
            attach.setThumbnailURL(thumb_url + " " + i);
            attachments.add(attach);
        }
        Message msg = this.store.sendMessage(this.testFrom, this.recipients, "testGetAttachmentByMessageId", this.body, attachments);
        String msg_id = msg.getId();
        List attachs_by_message_id = this.store.getMessageAttachmentsById(msg_id);
        Assert.assertEquals((String)"attachs list should have  element", (long)count, (long)attachs_by_message_id.size());
        for (Attachment attach : attachments) {
            String attach_id = attach.getId();
            Attachment by_message_id = attachs_by_message_id.stream().filter(c -> c.getId().equals(attach_id)).findFirst().orElse(null);
            Assert.assertNotNull((String)"cannot obtain attach ", (Object)(attach_id + "by msg id " + msg_id));
            this.checkEqualAttachments(attach, by_message_id);
            Attachment by_attach_id = this.store.getMessageAttachmentByIdFilename(msg_id, attach_id);
            Assert.assertNotNull((String)"cannot obtain attach by id", (Object)attach_id);
            this.checkEqualAttachments(attach, by_attach_id);
        }
    }

    private boolean checkEqualAttachments(Attachment attach, Attachment obtained_attach) {
        Assert.assertEquals((String)"wrong attachId", (Object)attach.getId(), (Object)obtained_attach.getId());
        Assert.assertEquals((String)"wrong filename", (Object)attach.getName(), (Object)obtained_attach.getName());
        Assert.assertEquals((String)"wrong description", (Object)attach.getDescription(), (Object)obtained_attach.getDescription());
        Assert.assertEquals((String)"wrong uri", (Object)attach.getUri(), (Object)obtained_attach.getUri());
        Assert.assertEquals((String)"wrong thumb uri", (Object)attach.getThumbnailURL(), (Object)obtained_attach.getThumbnailURL());
        return true;
    }

    @Test
    public void populate_messages() throws NotificationTypeNotFoundException {
        CqlSession session = this.store.getSession();
        Date timestamp = null;
        Integer limit = 10;
        List<String> destinatari = Arrays.asList("alfredo.oliviero", "massimiliano.assante", "andrea.rossi");
        List notifications = this.store.getAllNotifications(timestamp, limit, session);
        for (Notification n : notifications) {
            String sender = n.getSenderid();
            Message m = new Message(Message.generateUUID(), n.getSenderid(), n.getSenderFullName(), destinatari, n.getSubjectid().toString(), n.getDescription(), n.getTime(), true);
            Attachment attach = new Attachment(Message.generateUUID(), n.getUri(), m.getId(), n.getDescription(), n.getSenderThumbnail(), "image/png");
            this.store.sendMessage(m, Arrays.asList(attach), session);
            if (!destinatari.contains(sender)) {
                destinatari.set(0, sender);
            }
            System.out.println("created message " + m);
        }
    }
}

