package org.gcube.portal.databook.shared;

import java.util.Date;
import java.util.List;

public class MessageReceived extends Message {
    protected boolean read;
    protected boolean opened;
    protected String recipient_id;
    protected boolean deleted;

    public boolean isDeleted() {
        return deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public String getRecipient_id() {
        return recipient_id;
    }

    public void setRecipient_id(String recipientid) {
        this.recipient_id = recipientid;
    }

    public MessageReceived(String id, String recipientid, String userid, String user_name, List<String> addresses,
            String subject, String body,
            Date timestamp, boolean with_attachments, boolean read, boolean opened, boolean deleted) {
        super(id, userid, user_name, addresses, subject, body, timestamp, with_attachments);
        this.recipient_id = recipientid;
        this.read = read;
        this.opened = opened;
        this.deleted = deleted;
    }

    public MessageReceived(Message message,
            String recipientid, boolean read, boolean opened, boolean deleted) {
        super(message.getId(), message.getUser_id(), message.getUser_name(), message.getAddresses(),
                message.getSubject(), message.getBody(), message.getCreation_time(), message.isWith_attachments());
        this.recipient_id = recipientid;
        this.read = read;
        this.opened = opened;
        this.deleted = deleted;
    }

    @Override
    public String toString() {
        return "ReceivedMessage [id=" + id + ", user_id=" + user_id + ", creation_time=" + creation_time
                + ", addresses=" + addresses + ", subject=" + subject + ", body="
                + body + ", with_attachments=" + with_attachments +
                ", recipientid=" + recipient_id + ", read=" + read + ", opened=" + opened + ", deleted=" + deleted
                + "]";
    }

    public boolean isRead() {
        return read;
    }

    public void setRead(boolean read) {
        this.read = read;
    }

    public boolean isOpened() {
        return opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

}
