/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.databook.server;

import org.gcube.portal.databook.server.CassandraClusterConnection;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseDbTest {
    protected DBCassandraAstyanaxImpl store;
    protected static String INFRASTRUCTURE = "gcube";
    protected static final String HOST = "127.0.0.1:9042";
    protected static final String DATACENTER = "DC1";
    protected static final String KEYSPACE = "dev_keyspace_1";
    protected static boolean CUSTOM_DB = false;

    @Before
    public void setUp() throws Exception {
        if (CUSTOM_DB) {
            BaseDbTest.setCustomConfig();
        }
        this.store = BaseDbTest.createStore();
    }

    protected static void setCustomConfig() throws Exception {
        BaseDbTest.setCustomConfig(HOST, DATACENTER, KEYSPACE);
    }

    protected static void setCustomConfig(String host, String datacenterName, String keysSpace) throws Exception {
        CassandraClusterConnection.setCustomConfig((String)host, (String)datacenterName, (String)keysSpace);
    }

    public static DBCassandraAstyanaxImpl createStore() throws Exception {
        return new DBCassandraAstyanaxImpl(INFRASTRUCTURE);
    }

    public DBCassandraAstyanaxImpl getStore() throws Exception {
        if (this.store == null) {
            this.store = BaseDbTest.createStore();
        }
        Assert.assertNotNull((Object)this.store);
        return this.store;
    }

    @Test
    public void testStore() throws Exception {
        this.store = this.getStore();
        Assert.assertNotNull((Object)this.store);
    }

    public CassandraClusterConnection getConnection() throws Exception {
        return new CassandraClusterConnection(false, false, null);
    }

    @Test
    public void testConnection() throws Exception {
        System.out.print("starting test createConnection");
        CassandraClusterConnection connection = this.getConnection();
        Assert.assertNotNull((Object)connection);
        System.out.print("connection extablished" + connection);
    }

    @Test
    public void empty() {
        System.out.print("Testing works");
    }
}

