package org.gcube.portal.databook.shared;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.UUID;

/**
 * 
 * @author Alfredo Oliviero, ISTI-CNR
 *
 */
@SuppressWarnings("serial")
public class Message implements Serializable, Comparable<Message> {

	// WORKSPACE
	// public class MessageUser {
	// String user_name;
	// String user_id;
	// }
	// "id": "cb3059b7-24ac-4bf0-8e37-525ce85a2c72",
	// "name": "78b321f9-793b-4474-a440-38c0a38f205f",
	// "path": "/Home/alfredo.oliviero/InBox/78b321f9-793b-4474-a440-38c0a38f205f",
	// "parent_id": "847fa2b2-bcfa-48c1-b513-9267eb215c05",
	// "parent_path": "/Home/alfredo.oliviero/InBox",
	// "primary_type": "nthl:itemSentRequestSH",
	// "with_attachments": false,
	// "sender": {
	// "user_name": "lucio.lelii",
	// "user_id": "lucio.lelii"
	// },
	// "subject": "prova",
	// "body": "asdfsadsfsdadfsadfsadf",
	// "read": true,
	// "opened": false,
	// "addresses": [
	// "alfredo.oliviero"
	// ],
	// "creation_time": 1722869475845

	protected String id;
	// protected String name;
	// protected String path;
	// protected String parent_id;
	// protected String parent_path;
	// protected String primary_type;
	protected boolean with_attachments;

	// protected MessageUser sender;
	protected String user_id;
	protected String user_name;

	protected List<String> addresses;

	protected String subject;
	protected String body;

	// protected Date creation_time;
	protected Date creation_time;

	public UUID getUUID() {
		return UUID.fromString(getId());
	}

	public String getId() {
		return id;
	}

	public String getKey() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public boolean isWith_attachments() {
		return with_attachments;
	}

	public void setWith_attachments(boolean with_attachments) {
		this.with_attachments = with_attachments;
	}

	public String getUser_id() {
		return user_id;
	}

	public void setUser_id(String userid) {
		this.user_id = userid;
	}

	public String getUser_name() {
		return user_name;
	}

	public void setUser_name(String user_name) {
		this.user_name = user_name;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}


	public List<String> getAddresses() {
		return addresses;
	}

	public void setAddresses(List<String> addresses) {
		this.addresses = addresses;
	}

	public Date getCreation_time() {
		return creation_time;
	}

	public void setCreation_time(Date timestamp) {
		this.creation_time = timestamp;
	}

	public Message() {
		super();
	}

	public static String generateUUID(){
		UUID uuid = UUID.randomUUID();
		return uuid.toString();
	}

	public Message(String id, String userid, String user_name, List<String> addresses, String subject, String body,
			Date timestamp, boolean with_attachments ) {
		super();
		this.id = id;
		this.user_id = userid;
		this.user_name = user_name;
		this.addresses = addresses;
		this.subject = subject;
		this.body = body;
		this.creation_time = timestamp;
		this.with_attachments = with_attachments;
	}

	public int compareTo(Message toCompare) {
		return this.getCreation_time().compareTo(toCompare.getCreation_time());
	}

	@Override
	public String toString() {
		return "Message [id=" + id + ", user_id=" + user_id + ", creation_time=" + creation_time
				+ ", addresses=" + addresses + ", subject=" + subject + ", body="
				+ body + ", with_attachments=" + with_attachments + "]";
	}
}

