package org.gcube.portal.social.networking.caches;

import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.slf4j.LoggerFactory;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class GroupsCache {
    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(GroupsCache.class);
    private static GroupsCache singleton = new GroupsCache();

    /**
     * Private constructor: build the cache
     * 
     * @return
     */
    private GroupsCache() {

        logger.debug("Building cache");
        CachesManager.getCache(CachesManager.GROUPS_CACHE);

    }

    /**
     * Get the singleton object
     */
    public static GroupsCache getSingleton() {
        return singleton;
    }

    /**
     * Retrieve an entry
     * 
     * @param groupId
     * @return user associated to the user
     */
    public GCubeGroup getGroup(long groupId) {
        Ehcache groupsCache = CachesManager.getCache(CachesManager.GROUPS_CACHE);
        if (groupsCache.get(groupId) != null)
            return (GCubeGroup) groupsCache.get(groupId).getObjectValue();
        else
            return null;
    }

    /**
     * Save an entry into the cache
     * 
     * @param id
     * @param group
     */
    public void pushEntry(long id, GCubeGroup group) {
        Ehcache groupsCache = CachesManager.getCache(CachesManager.GROUPS_CACHE);
        groupsCache.put(new Element(id, group));
    }

}
