/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/hashtags")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class HashTags {
    private static final Logger logger = LoggerFactory.getLogger(HashTags.class);

    @GET
    @Path(value="get-hashtags-and-occurrences/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Hashtags and occurrences retrieved, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getHashTagsAndOccurrences() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.debug("User " + username + " has requested hashtags of context " + context);
        try {
            DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
            boolean isVRE = GroupManagerWSBuilder.getInstance().getGroupManager().isVRE(GroupManagerWSBuilder.getInstance().getGroupManager().getGroupIdFromInfrastructureScope(context));
            if (isVRE) {
                Map map = datastore.getVREHashtagsWithOccurrence(context);
                responseBean.setResult((Object)map);
                responseBean.setSuccess(true);
            } else {
                responseBean.setMessage("Please provide a VRE token. VO and ROOT VO cases are not yet managed.");
                responseBean.setResult((Object)false);
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve hashtags", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

