/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.utils;

import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.socialnetworking.social_data_search_client.ElasticSearchClient;
import org.gcube.socialnetworking.social_data_search_client.ElasticSearchClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchConnection {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchConnection.class);
    private ElasticSearchClient es;
    private static ElasticSearchConnection singleton = new ElasticSearchConnection();

    private ElasticSearchConnection() {
        try {
            ApplicationContext ctx = ContextProvider.get();
            logger.info("Creating connection to Elasticsearch");
            this.es = new ElasticSearchClientImpl(ctx.container().configuration().infrastructure());
            logger.info("Elasticsearch connection created");
        }
        catch (Exception e) {
            logger.error("Failed to connect to elasticsearch", (Throwable)e);
        }
    }

    public static ElasticSearchConnection getSingleton() {
        return singleton;
    }

    public ElasticSearchClient getElasticSearchClient() {
        return this.es;
    }
}

