/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import java.util.List;
import javax.validation.ValidationException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.RoleManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.methods.v2.Users;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.model.GatewayRolesNames;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/vres")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class VREs {
    private static final Logger logger = LoggerFactory.getLogger(Users.class);

    @GET
    @Path(value="get-my-vres/")
    @Produces(value={"application/json"})
    public Response getMyVres(@DefaultValue(value="false") @QueryParam(value="getManagers") boolean getManagers) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        if (!TokensUtils.isUserToken((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage("This method can only be invoked with a user token!");
            logger.warn("Trying to access get-my-vres method via a token different than USER is not allowed");
        } else {
            GroupManager gmManager = GroupManagerWSBuilder.getInstance().getGroupManager();
            UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
            RoleManager roleManager = RoleManagerWSBuilder.getInstance().getRoleManager();
            try {
                GCubeUser user = userManager.getUserByUsername(username);
                List vres = gmManager.listVresByUser(user.getUserId());
                JSONArray toReturn = new JSONArray();
                for (GCubeGroup group : vres) {
                    JSONObject obj = new JSONObject();
                    obj.put((Object)"name", (Object)group.getGroupName());
                    obj.put((Object)"context", (Object)gmManager.getInfrastructureScope(group.getGroupId()));
                    obj.put((Object)"description", (Object)group.getDescription());
                    JSONArray managers = new JSONArray();
                    if (getManagers) {
                        List vreManagers = userManager.listUsersByGroupAndRole(group.getGroupId(), roleManager.getRoleIdByName(GatewayRolesNames.VRE_MANAGER.getRoleName()));
                        for (GCubeUser vreManager : vreManagers) {
                            JSONObject manager = new JSONObject();
                            manager.put((Object)"username", (Object)vreManager.getUsername());
                            manager.put((Object)"fullname", (Object)vreManager.getFullname());
                            managers.add((Object)manager);
                        }
                        obj.put((Object)"managers", (Object)managers);
                    }
                    toReturn.add((Object)obj);
                }
                responseBean.setSuccess(true);
                responseBean.setResult((Object)toReturn);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve vres for user.", (Throwable)e);
                responseBean.setMessage(e.toString());
                responseBean.setSuccess(false);
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

