/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.liferay.ws;

import java.util.List;
import java.util.Map;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.liferay.ws.ServletContextClass;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayJSONWsCredentials {
    private static final Logger logger = LoggerFactory.getLogger(LiferayJSONWsCredentials.class);
    private static LiferayJSONWsCredentials singleton = new LiferayJSONWsCredentials();
    private String host;
    private String schema;
    private String user;
    private String password;
    private int port;
    private String notifierUserToken;
    private static final String RUNTIME_RESOURCE_NAME = "D4Science Infrastructure Gateway";
    private static final String CATEGORY = "Portal";

    private LiferayJSONWsCredentials() {
        logger.info("Building LiferayJSONWsCredentials object");
        this.loadNotifierToken();
        this.lookupPropertiesFromIs();
        logger.info("LiferayJSONWsCredentials object built");
    }

    private void loadNotifierToken() {
        try {
            this.notifierUserToken = ServletContextClass.getNotifierToken();
            logger.debug("Token read " + this.notifierUserToken.substring(0, 5) + "*********************");
        }
        catch (Exception e) {
            logger.error("Failed to read notifier user token!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupPropertiesFromIs() {
        logger.info("Starting creating LiferayJSONWsCredentials");
        String oldContext = ScopeProvider.instance.get();
        ApplicationContext ctx = ContextProvider.get();
        ScopeProvider.instance.set("/" + ctx.container().configuration().infrastructure());
        logger.info("Discovering liferay user's credentials in context " + ctx.container().configuration().infrastructure());
        try {
            List resources = this.getConfigurationFromIS();
            if (resources.size() == 0) {
                logger.error("There is no Runtime Resource having name D4Science Infrastructure Gateway and Category Portal in this scope.");
                throw new Exception("There is no Runtime Resource having name D4Science Infrastructure Gateway and Category Portal in this scope.");
            }
            block5: for (ServiceEndpoint res : resources) {
                for (ServiceEndpoint.AccessPoint accessPoint : res.profile().accessPoints()) {
                    if (!accessPoint.name().equals("JSONWSUser")) continue;
                    Map properties = accessPoint.propertyMap();
                    this.host = accessPoint.address();
                    this.schema = ((ServiceEndpoint.Property)properties.get("schema")).value();
                    this.user = StringEncrypter.getEncrypter().decrypt(((ServiceEndpoint.Property)properties.get("username")).value());
                    this.password = StringEncrypter.getEncrypter().decrypt(((ServiceEndpoint.Property)properties.get("password")).value());
                    this.port = Integer.valueOf(((ServiceEndpoint.Property)properties.get("port")).value());
                    continue block5;
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such service endpoint information!", (Throwable)e);
            return;
        }
        finally {
            if (oldContext != null) {
                ScopeProvider.instance.set(oldContext);
            }
        }
        logger.info("Bean built " + this.toString());
    }

    private List<ServiceEndpoint> getConfigurationFromIS() throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'D4Science Infrastructure Gateway'");
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        return toReturn;
    }

    public static LiferayJSONWsCredentials getSingleton() {
        return singleton;
    }

    public String getHost() {
        return this.host;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getNotifierUserToken() {
        return this.notifierUserToken;
    }

    public String toString() {
        return "LiferayJSONWsCredentials [host=" + this.host + ", schema=" + this.schema + ", user=" + this.user + ", password=" + this.password + ", port=" + this.port + ", notifierUserToken=" + this.notifierUserToken + "]";
    }
}

