/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.liferay.ws;

import java.util.List;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakAPICredentials {
    private static final Logger logger = LoggerFactory.getLogger(KeycloakAPICredentials.class);
    private static KeycloakAPICredentials singleton = new KeycloakAPICredentials();
    private String keycloakURL;
    private String realm;
    private String clientid;
    private String password;
    private static final String RUNTIME_RESOURCE_NAME = "IAM";
    private static final String CATEGORY = "Service";

    private KeycloakAPICredentials() {
        logger.info("Building KeycloakAPICredentials object");
        this.lookupPropertiesFromIs();
        logger.info("KeycloakAPICredentials object built");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lookupPropertiesFromIs() {
        logger.info("Starting creating KeycloakAPICredentials");
        String oldContext = ScopeProvider.instance.get();
        ApplicationContext ctx = ContextProvider.get();
        ScopeProvider.instance.set("/" + ctx.container().configuration().infrastructure());
        logger.info("Discovering liferay user's credentials in context " + ctx.container().configuration().infrastructure());
        try {
            List resources = this.getConfigurationFromIS();
            if (resources.size() == 0) {
                logger.error("There is no Runtime Resource having name IAM and Category Service in this scope.");
                throw new Exception("There is no Runtime Resource having name IAM and Category Service in this scope.");
            }
            for (ServiceEndpoint res : resources) {
                for (ServiceEndpoint.AccessPoint accessPoint : res.profile().accessPoints()) {
                    if (!accessPoint.name().equals("d4science")) continue;
                    this.keycloakURL = accessPoint.address();
                    this.realm = accessPoint.name();
                    this.clientid = accessPoint.username();
                    this.password = StringEncrypter.getEncrypter().decrypt(accessPoint.password());
                    logger.info("Found accesspoint URL = " + this.keycloakURL);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such service endpoint information!", (Throwable)e);
            return;
        }
        finally {
            if (oldContext != null) {
                ScopeProvider.instance.set(oldContext);
            }
        }
        logger.info("Bean built " + this.toString());
    }

    private List<ServiceEndpoint> getConfigurationFromIS() throws Exception {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name/text() eq 'IAM'");
        query.addCondition("$resource/Profile/Category/text() eq 'Service'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List toReturn = client.submit((Query)query);
        return toReturn;
    }

    public static KeycloakAPICredentials getSingleton() {
        if (singleton == null) {
            singleton = new KeycloakAPICredentials();
        }
        return singleton;
    }

    public String getServerURL() {
        return this.keycloakURL;
    }

    public String getClientid() {
        return this.clientid;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        return "KeycloakAPICredentials [keycloakURL=" + this.keycloakURL + ", realm=" + this.realm + ", clientid=" + this.clientid + ", password=**************]";
    }
}

