/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.EnhancedFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Filters {
    private static final Logger logger = LoggerFactory.getLogger(Filters.class);

    private static List<String> getContexts(String context) throws IllegalArgumentException, UserManagementSystemException, GroupRetrievalFault {
        GroupManager gm = GroupManagerWSBuilder.getInstance().getGroupManager();
        GCubeGroup group = gm.getGroup(gm.getGroupIdFromInfrastructureScope(context));
        ArrayList<String> contexts = new ArrayList<String>();
        if (!gm.isRootVO(group.getGroupId()).booleanValue()) {
            if (gm.isVO(group.getGroupId()).booleanValue()) {
                List vres = group.getChildren();
                for (GCubeGroup gCubeGroup : vres) {
                    contexts.add(gm.getInfrastructureScope(gCubeGroup.getGroupId()));
                }
            } else {
                contexts.add(gm.getInfrastructureScope(group.getGroupId()));
            }
        }
        return contexts;
    }

    public static void filterFeedsPerContextById(List<String> feedsIds, String context) throws Exception {
        DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
        ArrayList<Feed> feeds = new ArrayList<Feed>();
        for (String feedId : feedsIds) {
            try {
                feeds.add(datastore.readFeed(feedId));
            }
            catch (Exception e) {
                logger.error("Unable to read feed with id " + feedId, (Throwable)e);
            }
        }
        Filters.filterFeedsPerContext(feeds, (String)context);
        feedsIds.clear();
        for (Feed feed : feeds) {
            feedsIds.add(feed.getKey());
        }
    }

    @Deprecated
    public static void filterFeedsPerContext(List<Feed> feeds, String context) throws Exception {
        List contexts = Filters.getContexts((String)context);
        Iterator<Feed> iterator = feeds.iterator();
        while (iterator.hasNext()) {
            Feed feed = iterator.next();
            if (contexts.contains(feed.getVreid())) continue;
            iterator.remove();
        }
    }

    public static void filterPostsPerContext(List<Post> posts, String context) throws Exception {
        List contexts = Filters.getContexts((String)context);
        Iterator<Post> iterator = posts.iterator();
        while (iterator.hasNext()) {
            Post post = iterator.next();
            if (contexts.contains(post.getVreid())) continue;
            iterator.remove();
        }
    }

    public static void filterCommentsPerContext(List<Comment> comments, String context) throws Exception {
        List contexts = Filters.getContexts((String)context);
        DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
        Iterator<Comment> iterator = comments.iterator();
        while (iterator.hasNext()) {
            try {
                Comment comment = iterator.next();
                Feed parent = datastore.readFeed(comment.getFeedid());
                if (contexts.contains(parent.getVreid())) continue;
                iterator.remove();
            }
            catch (Exception e) {
                logger.warn("Failed to analyze this comment", (Throwable)e);
                iterator.remove();
            }
        }
    }

    public static <T> void hideSensitiveInformation(List<T> toClear, String usernameCaller) {
        block4: {
            block3: {
                if (toClear == null || toClear.isEmpty() || usernameCaller == null || usernameCaller.isEmpty()) {
                    return;
                }
                if (!toClear.get(0).getClass().equals(Feed.class)) break block3;
                for (T feed : toClear) {
                    Feed feeded = (Feed)feed;
                    if (usernameCaller.equals(feeded.getEntityId())) continue;
                    feeded.setEmail("");
                }
                break block4;
            }
            if (!toClear.get(0).getClass().equals(EnhancedFeed.class)) break block4;
            for (T enhancedFeed : toClear) {
                Feed feeded = ((EnhancedFeed)enhancedFeed).getFeed();
                if (usernameCaller.equals(feeded.getEntityId())) continue;
                feeded.setEmail("");
            }
        }
    }
}

