/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Invite;
import org.gcube.portal.databook.shared.InviteOperationResult;
import org.gcube.portal.databook.shared.InviteStatus;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.Notification;
import org.gcube.portal.databook.shared.NotificationChannelType;
import org.gcube.portal.databook.shared.NotificationType;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.RangePosts;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/lib")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Lib {
    private static final Logger logger = LoggerFactory.getLogger(Lib.class);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="add-comment-lib/")
    public Response addCommentLib(@NotNull(message="Comment to write is missing") @Valid Comment comment) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("Writing comment with commentid " + comment.getKey());
            boolean result = CassandraConnection.getInstance().getDatabookStore().addComment(comment);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="read-comment-by-id-lib/")
    public Response readCommentByIdLib(@QueryParam(value="commentid") String commentid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("Getting comment with commentid " + commentid);
            Comment result = CassandraConnection.getInstance().getDatabookStore().readCommentById(commentid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to find comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-by-post-id-lib/")
    @StatusCodes(value={@ResponseCode(code=200, condition="The list of comments is put into the 'result' field"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllCommentsByPostIdLib(@NotNull @QueryParam(value="postid") String postid) {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List comments = null;
        try {
            logger.info("Retrieving comments for  postid " + postid);
            comments = CassandraConnection.getInstance().getDatabookStore().getAllCommentByPost(postid);
            responseBean.setResult((Object)comments);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-recent-comments-by-user-and-date-lib/")
    public Response getRecentCommentsByUserAndDateLib(@QueryParam(value="time") @Min(value=0L, message="time cannot be negative") long timeInMillis, @QueryParam(value="username") String username) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, timeInMillis);
            responseBean.setResult((Object)comments);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="edit-comment-lib/")
    public Response editCommentLib(@NotNull(message="Comment to edit is missing") @Valid Comment comment) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("Writing comment with commentid " + comment.getKey());
            boolean result = CassandraConnection.getInstance().getDatabookStore().editComment(comment);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="delete-comment-lib/")
    public Response deleteCommentLib(@QueryParam(value="commentid") String commentid, @QueryParam(value="postid") String postid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("deleting comment with commentid " + commentid);
            boolean result = CassandraConnection.getInstance().getDatabookStore().deleteComment(commentid, postid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to delete comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-hashtag-lib/")
    public Response saveHashTagsLib(@QueryParam(value="feedid") String feedid, @QueryParam(value="vreid") String vreid, @NotNull(message="hashtag to save is missing") @Valid List<String> hashtags) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("Saving hashtags ");
            boolean result = CassandraConnection.getInstance().getDatabookStore().saveHashTags(feedid, vreid, hashtags);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to save hashtags.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="delete-hashtag-lib/")
    public Response deleteHashTagsLib(@QueryParam(value="feedid") String feedid, @QueryParam(value="vreid") String vreid, @NotNull(message="hashtag to delete is missing") @Valid List<String> hashtags) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("deleting hashtags ");
            boolean result = CassandraConnection.getInstance().getDatabookStore().deleteHashTags(feedid, vreid, hashtags);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to delete hashtags.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-hashtag-comment-lib/")
    public Response saveHashTagsCommentLib(@QueryParam(value="commentid") String commentid, @QueryParam(value="vreid") String vreid, @NotNull(message="hashtag to save is missing") @Valid List<String> hashtags) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("Saving hashtags comments ");
            boolean result = CassandraConnection.getInstance().getDatabookStore().saveHashTagsComment(commentid, vreid, hashtags);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to save hashtags comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="delete-hashtag-comment-lib/")
    public Response deleteHashTagsCommentLib(@QueryParam(value="commentid") String commentid, @QueryParam(value="vreid") String vreid, @NotNull(message="hashtag to delete is missing") @Valid List<String> hashtags) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("deleting hashtags ");
            boolean result = CassandraConnection.getInstance().getDatabookStore().deleteHashTagsComment(commentid, vreid, hashtags);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to delete hashtags.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-vre-hashtags-occurrences-lib/")
    public Response getVREHashtagsWithOccurrenceLib(@QueryParam(value="vreid") String vreid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Map hashtags = null;
        try {
            logger.info("getting vre hashtags occurrences " + vreid);
            hashtags = CassandraConnection.getInstance().getDatabookStore().getVREHashtagsWithOccurrence(vreid);
            responseBean.setResult((Object)hashtags);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-vre-hashtags-occurrences-time-lib/")
    public Response getVREHashtagsWithOccurrenceFilteredByTimeLib(@QueryParam(value="vreid") String vreid, @QueryParam(value="time") @Min(value=0L, message="time cannot be negative") long timestamp) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Map hashtags = null;
        try {
            logger.info("getting vre hashtags occurrences " + vreid);
            hashtags = CassandraConnection.getInstance().getDatabookStore().getVREHashtagsWithOccurrenceFilteredByTime(vreid, timestamp);
            responseBean.setResult((Object)hashtags);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-vre-post-by-hashtag-lib/")
    public Response getVREFeedsByHashtagLib(@QueryParam(value="vreid") String vreid, @QueryParam(value="hashtag") String hashtag) throws ValidationException {
        hashtag = "#" + hashtag;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List posts = null;
        try {
            logger.info("getting vre hashtags occurrences " + vreid);
            posts = CassandraConnection.getInstance().getDatabookStore().getVREPostsByHashtag(vreid, hashtag);
            responseBean.setResult((Object)posts);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="is-existing-invite-lib/")
    public Response isExistingInviteLib(@QueryParam(value="vreid") String vreid, @QueryParam(value="email") String email) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        String inv = null;
        try {
            logger.info("Retrieving invite for vre " + vreid);
            inv = CassandraConnection.getInstance().getDatabookStore().isExistingInvite(vreid, email);
            responseBean.setResult((Object)inv);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-invite-lib/")
    public Response saveInviteLib(@NotNull(message="invite to save is missing") @Valid Invite invite) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        InviteOperationResult inv = null;
        try {
            inv = CassandraConnection.getInstance().getDatabookStore().saveInvite(invite);
            responseBean.setResult((Object)inv);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="read-invite-lib/")
    public Response readInviteLib(@QueryParam(value="inviteid") String inviteid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Invite inv = null;
        try {
            logger.info("Retrieving invite for id " + inviteid);
            inv = CassandraConnection.getInstance().getDatabookStore().readInvite(inviteid);
            responseBean.setResult((Object)inv);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="set-invite-status-lib/")
    public Response setInviteStatusLib(@QueryParam(value="vreid") String vreid, @QueryParam(value="email") String email, @NotNull(message="invitestatus to save is missing") @Valid InviteStatus stat) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Boolean inv = null;
        try {
            inv = CassandraConnection.getInstance().getDatabookStore().setInviteStatus(vreid, email, stat);
            responseBean.setResult((Object)inv);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="get-invited-email-by-vre-lib/")
    public Response getInvitedEmailsByVRELib(@QueryParam(value="vreid") String vreid, InviteStatus ... stat) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List inv = null;
        try {
            inv = CassandraConnection.getInstance().getDatabookStore().getInvitedEmailsByVRE(vreid, stat);
            responseBean.setResult((Object)inv);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="like-lib/")
    public Response likeLib(@NotNull(message="like to add is missing") @Valid Like like) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("Writing like with likeid " + like.getKey());
            boolean result = CassandraConnection.getInstance().getDatabookStore().like(like);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="unlike-lib/")
    public Response unlikeLib(@QueryParam(value="userid") String userid, @QueryParam(value="likeid") String likeid, @QueryParam(value="feedid") String feedid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.info("Writing unlike with likeid " + likeid);
            boolean result = CassandraConnection.getInstance().getDatabookStore().unlike(userid, likeid, feedid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-all-liked-posts-by-user-lib/")
    public Response getAllLikedPostIdsByUserLib(@QueryParam(value="userid") String userid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List likes = null;
        try {
            logger.info("Retrieving likes for user id " + userid);
            likes = CassandraConnection.getInstance().getDatabookStore().getAllLikedPostIdsByUser(userid);
            responseBean.setResult((Object)likes);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-all-likes-by-post-lib/")
    public Response getAllLikesByPostLib(@QueryParam(value="postid") String postid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List likes = null;
        try {
            logger.info("Retrieving likes for post id " + postid);
            likes = CassandraConnection.getInstance().getDatabookStore().getAllLikesByPost(postid);
            responseBean.setResult((Object)likes);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-notification-lib/")
    public Response saveNotificationLib(@NotNull(message="notification to add is missing") @Valid Notification not) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().saveNotification(not);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="read-notification-lib/")
    public Response readNotificationLib(@QueryParam(value="notid") String notid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            Notification result = CassandraConnection.getInstance().getDatabookStore().readNotification(notid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="set-notification-read-lib/")
    public Response setNotificationReadLib(@QueryParam(value="notid") String notid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().setNotificationRead(notid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-all-notifications-user/")
    public Response getAllNotificationByUserLib(@QueryParam(value="userid") String userid, @QueryParam(value="limit") int limit) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getAllNotificationByUser(userid, limit);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-unread-notifications-user/")
    public Response getUnreadNotificationsByUserLib(@QueryParam(value="userid") String userid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getUnreadNotificationsByUser(userid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-range-notifications-user/")
    public Response getRangeNotificationsByUserLib(@QueryParam(value="userid") String userid, @QueryParam(value="from") int from, @QueryParam(value="quantity") int quantity) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getRangeNotificationsByUser(userid, from, quantity);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="set-all-notification-read-lib/")
    public Response setAllNotificationReadByUserLib(@QueryParam(value="userid") String userid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().setAllNotificationReadByUser(userid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="check-unread-notification-lib/")
    public Response checkUnreadNotificationsLib(@QueryParam(value="userid") String userid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().checkUnreadNotifications(userid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="check-unread-messages-notification-lib/")
    public Response checkUnreadMessagesNotificationsLib(@QueryParam(value="userid") String userid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().checkUnreadMessagesNotifications(userid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="get-user-notification-channels-lib/")
    public Response getUserNotificationChannelsLib(@QueryParam(value="userid") String userid, @QueryParam(value="type") String type) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getUserNotificationChannels(userid, NotificationType.valueOf((String)type));
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="set-notification-preference-lib/")
    public Response setUserNotificationPreferencesLib(@QueryParam(value="userid") String userid, @NotNull(message="notification prefs to add is missing") @Valid Map<NotificationType, NotificationChannelType[]> enabledChannels) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        for (NotificationType notificationType : enabledChannels.keySet()) {
            logger.info("Type: " + notificationType.toString());
            for (NotificationChannelType channelType : enabledChannels.get(notificationType)) {
                logger.info(channelType.toString());
            }
        }
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().setUserNotificationPreferences(userid, enabledChannels);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write settings.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-notification-preference-lib/")
    public Response getUserNotificationPreferencesLib(@QueryParam(value="userid") String userid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            Map result = CassandraConnection.getInstance().getDatabookStore().getUserNotificationPreferences(userid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-user-post-lib/")
    public Response saveUserPostLib(@NotNull(message="post to add is missing") @Valid Post post) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().saveUserPost(post);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-attachment-lib/")
    public Response saveAttachmentEntryLib(@QueryParam(value="postid") String postkey, @NotNull(message="attachment to add is missing") @Valid Attachment attachment) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().saveAttachmentEntry(postkey, attachment);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.info("Unable to write attachment.", (Throwable)e);
            logger.info(e.getMessage());
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-app-post-lib/")
    public Response saveAppPostLib(@NotNull(message="post to add is missing") @Valid Post post) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().saveAppPost(post);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="save-post-to-vretimeline-lib/")
    public Response savePostToVRETimelineLib(@QueryParam(value="postid") String postid, @QueryParam(value="vreid") String vreid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().savePostToVRETimeline(postid, vreid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="read-post-lib/")
    public Response readPostLib(@QueryParam(value="postid") String postid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            Post result = CassandraConnection.getInstance().getDatabookStore().readPost(postid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-recent-posts-by-user-date-lib/")
    public Response getRecentPostsByUserAndDateLib(@QueryParam(value="userid") String userid, @QueryParam(value="time") long timeinmillis) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getRecentPostsByUserAndDate(userid, timeinmillis);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="delete-post-lib/")
    public Response deletePostLib(@QueryParam(value="postid") String postid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            boolean result = CassandraConnection.getInstance().getDatabookStore().deletePost(postid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(result);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-all-posts-by-user-lib/")
    public Response getAllPostsByUserLib(@QueryParam(value="userid") String userid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getAllPostsByUser(userid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-all-posts-by-app-lib/")
    public Response getAllPostsByAppLib(@QueryParam(value="appid") String appid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getAllPostsByApp(appid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-recent-commented-posts-by-user-lib/")
    public Response getRecentCommentedPostsByUserAndDateLib(@QueryParam(value="userid") String userid, @QueryParam(value="time") long timeinmillis) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getRecentCommentedPostsByUserAndDate(userid, timeinmillis);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-portal-privacy-level-posts-lib/")
    public Response getAllPortalPrivacyLevelPostsLib() throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getAllPortalPrivacyLevelPosts();
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-recent-posts-by-user-lib/")
    public Response getRecentPostsByUserLib(@QueryParam(value="userid") String userid, @QueryParam(value="quantity") int quantity) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getRecentPostsByUser(userid, quantity);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-all-posts-by-vre-lib/")
    public Response getAllPostsByVRELib(@QueryParam(value="vreid") String vreid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getAllPostsByVRE(vreid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-recent-posts-by-vre-lib/")
    public Response getRecentPostsByVRELib(@QueryParam(value="vreid") String vreid, @QueryParam(value="quantity") int quantity) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getRecentPostsByVRE(vreid, quantity);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-recent-posts-by-vre-range-lib/")
    public Response getRecentPostsByVREAndRangeLib(@QueryParam(value="vreid") String vreid, @QueryParam(value="from") int from, @QueryParam(value="quantity") int quantity) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            RangePosts result = CassandraConnection.getInstance().getDatabookStore().getRecentPostsByVREAndRange(vreid, from, quantity);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-attachment-by-postid-lib/")
    public Response getAttachmentsByFeedIdLib(@QueryParam(value="postid") String postid) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getAttachmentsByFeedId(postid);
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-all-vre-ids-lib/")
    public Response getAllVREIdsLib() throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List result = CassandraConnection.getInstance().getDatabookStore().getAllVREIds();
            responseBean.setResult((Object)result);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to write comment.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

