/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.databook.shared.RunningJob;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.JobStatusNotificationThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.caches.UsersCache;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.LiferayJSONWsCredentials;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.ex.AuthException;
import org.gcube.portal.social.networking.ws.inputs.UserSetNotificationBean;
import org.gcube.portal.social.networking.ws.mappers.CatalogueEventTypeMapper;
import org.gcube.portal.social.networking.ws.mappers.JobMapper;
import org.gcube.portal.social.networking.ws.mappers.WorkspaceItemMapper;
import org.gcube.portal.social.networking.ws.methods.v2.Notifications;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.DistributedCacheClient;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.social_networking.socialnetworking.model.beans.JobNotificationBean;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEvent;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEventType;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.AddedItemEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.DeletedItemEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FileItemBean;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FolderAddedUserEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FolderAdminDowngradeEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FolderAdminUpgradeEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FolderBean;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.FolderRemovedUserEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.RenamedFolderEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.SharedFolderEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.UnsharedFolderEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.UpdatedItemEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.WorkspaceEvent;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.mortbay.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/notifications")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Notifications {
    private static final Logger logger = LoggerFactory.getLogger(Notifications.class);
    private static final String INFRASTRUCTURE_MANAGER_ROLE = "Infrastructure-Manager";

    @GET
    @Path(value="get-range-notifications/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Notifications retrieved and reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getRangeNotifications(@DefaultValue(value="1") @QueryParam(value="from") @Min(value=1L, message="from must be greater or equal to 1") int from, @DefaultValue(value="10") @QueryParam(value="quantity") @Min(value=0L, message="quantity must be greater or equal to 0") int quantity) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.debug("Retrieving " + quantity + " notifications of user = " + username + " from " + from);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List notifications = null;
        try {
            notifications = CassandraConnection.getInstance().getDatabookStore().getRangeNotificationsByUser(username, from, quantity);
            responseBean.setResult((Object)notifications);
            responseBean.setSuccess(true);
            logger.debug("List of notifications retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such notifications.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="is-user-disabled/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="true if the notification for the username given as query param are disabled (Catalogue and Workspace ones), false otherwise"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=AuthException.class)
    public Response isUserDisabled(@QueryParam(value="username") @NotNull(message="username cannot be null") String username) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            Boolean userDisabled = !this.isNotificationEnabled(username);
            responseBean.setResult((Object)userDisabled);
            responseBean.setSuccess(true);
            logger.debug("are User " + username + " Notifications Disabled?" + userDisabled);
        }
        catch (Exception e) {
            logger.error("Unable to read whether the notifications for this user are enabled or not.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="set-user-notifications/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Notification set Off or On correctly executed"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=AuthException.class)
    public Response setUserNotifications(@NotNull(message="input is missing") @Valid UserSetNotificationBean setting) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            String opExecutor = caller.getClient().getId();
            Boolean result = this.setUserNotificationsOnOff(setting.getUsername(), setting.isDisableNotification(), opExecutor);
            String toReturn = "Could not set notifications";
            if (result.booleanValue()) {
                toReturn = "Notifications have been set";
                toReturn = toReturn + (setting.isDisableNotification() ? " OFF (for 29 days unless re-enabled manually) " : " ON ");
                toReturn = toReturn + "for username=" + setting.getUsername();
            }
            responseBean.setSuccess(true);
            responseBean.setResult((Object)toReturn);
        }
        catch (Exception e) {
            logger.error("Unable to set user notification", (Throwable)e);
            responseBean.setSuccess(false);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    private boolean isNotificationEnabled(String usernameToCheck) throws IOException {
        MemcachedClient entries = new DistributedCacheClient().getMemcachedClient();
        String key = "dun:" + usernameToCheck;
        Boolean userEnabled = false;
        if (entries.get(key) == null) {
            userEnabled = true;
        }
        entries.getConnection().shutdown();
        return userEnabled;
    }

    private Boolean setUserNotificationsOnOff(String username, boolean disable, String callerId) throws IOException {
        MemcachedClient entries = new DistributedCacheClient().getMemcachedClient();
        String key = "dun:" + username;
        OperationFuture result = null;
        result = disable ? entries.set(key, 2506000, (Object)("op.ex:" + callerId)) : entries.delete(key);
        try {
            boolean res = result.getStatus().isSuccess();
            entries.getConnection().shutdown();
            return res;
        }
        catch (Exception e) {
            entries.getConnection().shutdown();
            e.printStackTrace();
            return null;
        }
    }

    @POST
    @Path(value="notify-job-status/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Notification is sent correctly"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response notifyJobStatus(@NotNull(message="input is missing") @Valid JobNotificationBean job) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        String appQualifier = caller.getClient().getId();
        logger.info("Received request from app " + appQualifier + " to notify job status described by bean " + job);
        try {
            String recipient = job.getRecipient();
            GCubeUser userRecipient = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(recipient);
            GenericItemBean recipientBean = new GenericItemBean(userRecipient.getUsername(), userRecipient.getUsername(), userRecipient.getFullname(), userRecipient.getUserAvatarURL());
            SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)context);
            GCubeUser senderUser = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
            SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, user);
            RunningJob theJob = JobMapper.getJob((JobNotificationBean)job);
            new Thread((Runnable)new JobStatusNotificationThread(theJob, Arrays.asList(recipientBean), (NotificationsManager)nm)).start();
            responseBean.setSuccess(true);
            responseBean.setResult((Object)"Notification thread started");
        }
        catch (Exception e) {
            logger.error("Unable to send job notification", (Throwable)e);
            responseBean.setSuccess(false);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="catalogue/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Catalogue Notification is sent correctly"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response catalogue(@NotNull(message="input is missing") @Valid CatalogueEvent event) throws ValidationException, UserManagementSystemException, UserRetrievalFault {
        boolean deliveryResult;
        Response.Status status;
        ResponseBean responseBean;
        block17: {
            Caller caller = AuthorizationProvider.instance.get();
            UserManager um = UserManagerWSBuilder.getInstance().getUserManager();
            GCubeUser senderUser = null;
            SocialNetworkingUser user = null;
            String username = null;
            String fullName = "";
            logger.debug("Catalogue Notification called by " + caller.getClient().getId() + " isUser?" + TokensUtils.isUserToken((Caller)caller));
            if (!TokensUtils.isUserToken((Caller)caller)) {
                GCubeUser jarvis = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
                SecurityTokenProvider.instance.set(LiferayJSONWsCredentials.getSingleton().getNotifierUserToken());
                username = jarvis.getUsername();
                fullName = caller.getClient().getId().replace("service-account-", "");
                senderUser = um.getUserByUsername(username);
                user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), fullName, senderUser.getUserAvatarURL());
            } else {
                username = caller.getClient().getId();
                senderUser = um.getUserByUsername(username);
                user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            }
            String context = ScopeProvider.instance.get();
            logger.debug("catalogue notifications from user = " + username);
            responseBean = new ResponseBean();
            status = Response.Status.OK;
            deliveryResult = false;
            try {
                logger.debug("catalogue notifications type is " + event.getType());
                SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)context);
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, user);
                String[] idsToNotify = event.getIdsToNotify();
                if (!event.idsAsGroup()) {
                    for (int i = 0; i < idsToNotify.length; ++i) {
                        String userIdToNotify = idsToNotify[i];
                        if (this.isNotificationEnabled(userIdToNotify)) {
                            String username2Notify = null;
                            try {
                                username2Notify = um.getUserByUsername(userIdToNotify).getUsername();
                            }
                            catch (Exception e) {
                                status = Response.Status.BAD_REQUEST;
                                logger.error("Username not found", (Throwable)e);
                                responseBean.setSuccess(false);
                                responseBean.setMessage("Username not found, got: " + userIdToNotify);
                                return Response.status((Response.Status)status).entity((Object)responseBean).build();
                            }
                            deliveryResult = nm.notifyCatalogueEvent(CatalogueEventTypeMapper.getType((CatalogueEventType)event.getType()), username2Notify, event.getItemId(), event.getNotifyText(), event.getItemURL());
                            continue;
                        }
                        Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                    }
                    break block17;
                }
                for (int i = 0; i < idsToNotify.length; ++i) {
                    String contextId = idsToNotify[i];
                    try {
                        ScopeBean scope = new ScopeBean(contextId);
                        if (scope.type() != ScopeBean.Type.VRE) {
                            logger.error("Context not a VRE");
                            status = Response.Status.BAD_REQUEST;
                            responseBean.setSuccess(false);
                            responseBean.setMessage("Not a VRE Context, only VREs are supported");
                            return Response.status((Response.Status)status).entity((Object)responseBean).build();
                        }
                        String[] userIdsToNotify = this.getUsernamesByContext(scope).toArray(new String[0]);
                        for (int j = 0; j < userIdsToNotify.length; ++j) {
                            String userIdToNotify = userIdsToNotify[j];
                            if (this.isNotificationEnabled(userIdToNotify)) {
                                deliveryResult = nm.notifyCatalogueEvent(CatalogueEventTypeMapper.getType((CatalogueEventType)event.getType()), userIdToNotify, event.getItemId(), event.getNotifyText(), event.getItemURL());
                                continue;
                            }
                            Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                        }
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        status = Response.Status.BAD_REQUEST;
                        logger.error("Context not valid", (Throwable)e);
                        responseBean.setSuccess(false);
                        responseBean.setMessage("Context not valid, must start with / " + e.getMessage());
                        return Response.status((Response.Status)status).entity((Object)responseBean).build();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to send job notification", (Throwable)e);
                responseBean.setSuccess(false);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        logger.debug("catalogue notifications should have been sent");
        if (deliveryResult) {
            responseBean.setSuccess(true);
            responseBean.setMessage("catalogue notification delivered correctly");
            responseBean.setResult((Object)new Boolean(true));
        } else {
            responseBean.setSuccess(false);
            responseBean.setMessage("An error occurred between this service and Cassandra DB, notification not delivered correctly");
            responseBean.setResult((Object)new Boolean(false));
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="workspace/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Workspace Notification is sent correctly"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response workspace(@NotNull(message="input is missing") @Valid WorkspaceEvent event) throws ValidationException {
        boolean deliveryResult;
        Response.Status status;
        ResponseBean responseBean;
        block17: {
            Caller caller = AuthorizationProvider.instance.get();
            String context = ScopeProvider.instance.get();
            String username = caller.getClient().getId();
            logger.debug("workspace notifications from = " + username);
            responseBean = new ResponseBean();
            status = Response.Status.OK;
            deliveryResult = false;
            try {
                GCubeUser senderUser = null;
                SocialNetworkingUser user = null;
                String fullName = "";
                logger.debug("workspace notifications type is " + event.getType());
                SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)context);
                UserManager um = UserManagerWSBuilder.getInstance().getUserManager();
                logger.debug("Workspace Notification called by " + caller.getClient().getId() + " isUser?" + TokensUtils.isUserToken((Caller)caller));
                if (!TokensUtils.isUserToken((Caller)caller)) {
                    GCubeUser jarvis = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
                    SecurityTokenProvider.instance.set(LiferayJSONWsCredentials.getSingleton().getNotifierUserToken());
                    username = jarvis.getUsername();
                    fullName = caller.getClient().getId().replace("service-account-", "");
                    senderUser = um.getUserByUsername(username);
                    user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), fullName, senderUser.getUserAvatarURL());
                } else {
                    username = caller.getClient().getId();
                    senderUser = um.getUserByUsername(username);
                    user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
                }
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, user);
                String[] idsToNotify = event.getIdsToNotify();
                if (!event.idsAsGroup()) {
                    for (int i = 0; i < idsToNotify.length; ++i) {
                        String userIdToNotify = idsToNotify[i];
                        if (this.isNotificationEnabled(userIdToNotify)) {
                            String username2Notify = "";
                            try {
                                username2Notify = um.getUserByUsername(userIdToNotify).getUsername();
                            }
                            catch (Exception e) {
                                status = Response.Status.NOT_ACCEPTABLE;
                                logger.error("Username not found", (Throwable)e);
                                responseBean.setSuccess(false);
                                responseBean.setMessage("Username not found, received: " + userIdToNotify);
                                return Response.status((Response.Status)status).entity((Object)responseBean).build();
                            }
                            deliveryResult = this.notifyWorkspaceEvent(event, (NotificationsManager)nm, username2Notify);
                            continue;
                        }
                        Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                    }
                    break block17;
                }
                for (int i = 0; i < idsToNotify.length; ++i) {
                    String contextId = idsToNotify[i];
                    try {
                        ScopeBean scope = new ScopeBean(contextId);
                        if (scope.type() != ScopeBean.Type.VRE) {
                            logger.error("Context not a VRE");
                            status = Response.Status.BAD_REQUEST;
                            responseBean.setSuccess(false);
                            responseBean.setMessage("Not a VRE Context, only VREs are supported");
                            return Response.status((Response.Status)status).entity((Object)responseBean).build();
                        }
                        String[] userIdsToNotify = this.getUsernamesByContext(scope).toArray(new String[0]);
                        for (int j = 0; j < userIdsToNotify.length; ++j) {
                            String userIdToNotify = userIdsToNotify[j];
                            if (this.isNotificationEnabled(userIdToNotify)) {
                                deliveryResult = this.notifyWorkspaceEvent(event, (NotificationsManager)nm, userIdToNotify);
                                continue;
                            }
                            Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                        }
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        status = Response.Status.BAD_REQUEST;
                        logger.error("Context not valid", (Throwable)e);
                        responseBean.setSuccess(false);
                        responseBean.setMessage("Context not valid, must start with / " + e.getMessage());
                        return Response.status((Response.Status)status).entity((Object)responseBean).build();
                    }
                }
            }
            catch (Exception e) {
                logger.error("Unable to send job notification", (Throwable)e);
                responseBean.setSuccess(false);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        logger.debug("workspace notifications should have been sent");
        if (deliveryResult) {
            responseBean.setSuccess(true);
            responseBean.setMessage("Workspace notification delivered correctly");
            responseBean.setResult((Object)new Boolean(true));
        } else {
            responseBean.setSuccess(false);
            responseBean.setMessage("An error occurred between this service and Cassandra DB, notification not delivered correctly");
            responseBean.setResult((Object)new Boolean(false));
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    private boolean notifyWorkspaceEvent(WorkspaceEvent event, NotificationsManager nm, String idToNotify) {
        try {
            switch (1.$SwitchMap$org$gcube$social_networking$socialnetworking$model$beans$workspace$WorkspaceEventType[event.getType().ordinal()]) {
                case 1: {
                    AddedItemEvent itemBean = (AddedItemEvent)event;
                    return nm.notifyAddedItem(idToNotify, WorkspaceItemMapper.getFileItem((FileItemBean)itemBean.getItem()), WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getItem().getParent()));
                }
                case 2: {
                    UpdatedItemEvent itemBean = (UpdatedItemEvent)event;
                    return nm.notifyUpdatedItem(idToNotify, WorkspaceItemMapper.getFileItem((FileItemBean)itemBean.getItem()), WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getItem().getParent()));
                }
                case 3: {
                    DeletedItemEvent itemBean = (DeletedItemEvent)event;
                    return nm.notifyRemovedItem(idToNotify, itemBean.getItemName(), WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getFolder()));
                }
                case 4: {
                    SharedFolderEvent itemBean = (SharedFolderEvent)event;
                    return nm.notifyFolderSharing(idToNotify, WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getFolder()));
                }
                case 5: {
                    UnsharedFolderEvent itemBean = (UnsharedFolderEvent)event;
                    return nm.notifyFolderUnsharing(idToNotify, itemBean.getUnsharedFolderId(), itemBean.getUnsharedFolderName());
                }
                case 6: {
                    RenamedFolderEvent itemBean = (RenamedFolderEvent)event;
                    return nm.notifyFolderRenaming(idToNotify, itemBean.getPreviousName(), itemBean.getNewName(), itemBean.getRenamedFolderId());
                }
                case 7: {
                    FolderAdminUpgradeEvent itemBean = (FolderAdminUpgradeEvent)event;
                    return nm.notifyAdministratorUpgrade(idToNotify, WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getFolder()));
                }
                case 8: {
                    FolderAdminDowngradeEvent itemBean = (FolderAdminDowngradeEvent)event;
                    return nm.notifyAdministratorDowngrade(idToNotify, WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getFolder()));
                }
                case 9: {
                    FolderAddedUserEvent itemBean = (FolderAddedUserEvent)event;
                    UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                    return nm.notifyFolderAddedUsers(idToNotify, WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getFolder()), itemBean.getNewAddedUserIds(), userManager);
                }
                case 10: {
                    FolderRemovedUserEvent itemBean = (FolderRemovedUserEvent)event;
                    return nm.notifyFolderRemovedUser(idToNotify, WorkspaceItemMapper.getSharedFolder((FolderBean)itemBean.getFolder()));
                }
            }
        }
        catch (Exception e) {
            logger.error("Unable to send job notification", (Throwable)e);
            return false;
        }
        return false;
    }

    private List<String> getUsernamesByContext(ScopeBean context) throws Exception {
        ArrayList<String> usernames = new ArrayList<String>();
        GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
        UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
        long groupId = groupManager.getGroupIdFromInfrastructureScope(context.toString());
        List userIds = userManager.getUserIdsByGroup(groupId);
        UsersCache cache = UsersCache.getSingleton();
        for (Long userId : userIds) {
            if (cache.getUser(userId.longValue()) == null) {
                GCubeUser theUser = userManager.getUserById(userId.longValue());
                if (theUser == null) continue;
                usernames.add(theUser.getUsername());
                cache.pushEntry(userId.longValue(), theUser);
                continue;
            }
            usernames.add(cache.getUser(userId.longValue()).getUsername());
        }
        return usernames;
    }
}

