/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.ApplicationProfile;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.RangePosts;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.social.networking.ws.inputs.PostInputBean;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.gcube.portal.social.networking.ws.utils.SocialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/posts")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Posts {
    private static final Logger logger = LoggerFactory.getLogger(Posts.class);

    @GET
    @Path(value="get-posts-user-since/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful retrieval of posts, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getRecentPostsByUserAndDate(@QueryParam(value="time") @Min(value=0L, message="time cannot be negative") long timeInMillis) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List posts = null;
        try {
            logger.info("Retrieving post for user id " + username + " and reference time " + timeInMillis);
            posts = CassandraConnection.getInstance().getDatabookStore().getRecentPostsByUserAndDate(username, timeInMillis);
            Filters.filterPostsPerContext((List)posts, (String)context);
            Filters.hideSensitiveInformation((List)posts, (String)caller.getClient().getId());
            responseBean.setResult((Object)posts);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such posts.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-user/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful retrieval of posts, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllPostsByUser() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List posts = null;
        try {
            logger.debug("Retrieving posts for user with id " + username);
            posts = CassandraConnection.getInstance().getDatabookStore().getAllPostsByUser(username);
            Filters.filterPostsPerContext((List)posts, (String)context);
            Filters.hideSensitiveInformation((List)posts, (String)caller.getClient().getId());
            responseBean.setResult((Object)posts);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-post/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful retrieval of posts, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getPost(@QueryParam(value="id") String id) {
        String context = ScopeProvider.instance.get();
        Caller caller = AuthorizationProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        ArrayList<Post> posts = new ArrayList<Post>();
        try {
            logger.debug("Retrieving post with id " + id);
            try {
                posts.add(CassandraConnection.getInstance().getDatabookStore().readPost(id));
            }
            catch (FeedIDNotFoundException feedIDNotFoundException) {
                responseBean.setMessage("The post with id " + id + " does not exist in context " + context);
                responseBean.setSuccess(false);
                return Response.status((Response.Status)status).entity((Object)responseBean).build();
            }
            Filters.filterPostsPerContext(posts, (String)context);
            Filters.hideSensitiveInformation(posts, (String)caller.getClient().getId());
            if (posts.isEmpty()) {
                responseBean.setMessage("The post with id " + id + " does not belong to this context " + context);
                responseBean.setSuccess(false);
                status = Response.Status.FORBIDDEN;
                return Response.status((Response.Status)status).entity((Object)responseBean).build();
            }
            responseBean.setResult(posts.get(0));
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such post.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-user-quantity/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful retrieval of posts, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getQuantityPostsByUser(@DefaultValue(value="10") @QueryParam(value="quantity") @Min(value=0L, message="quantity cannot be negative") int quantity) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List posts = new ArrayList();
        if (quantity == 0) {
            responseBean.setSuccess(true);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            logger.debug("getRecentPostsByUser first, posts made by user " + username);
            posts = CassandraConnection.getInstance().getDatabookStore().getAllPostsByUser(username);
            if (posts != null) {
                logger.debug("got " + posts.size() + " posts");
            }
            logger.debug("Retrieving last " + quantity + " posts made by user " + username + " in context = " + context);
            Filters.filterPostsPerContext(posts, (String)context);
            quantity = quantity > posts.size() ? posts.size() : quantity;
            posts = posts.subList(0, quantity);
            Filters.hideSensitiveInformation(posts, (String)caller.getClient().getId());
            responseBean.setResult(posts);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such posts.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="write-post-user")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Successfull created, the new post is reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response writePostUser(@NotNull(message="Post to write is missing") @Valid PostInputBean post) throws ValidationException {
        logger.debug("Request of writing a feed coming from user " + post);
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        String postText = post.getText();
        String previewTitle = post.getPreviewtitle();
        String previewDescription = post.getPreviewdescription();
        String previewHost = post.getPreviewhost();
        String previewUrl = post.getPreviewurl();
        String httpImageUrl = post.getHttpimageurl();
        boolean enableNotification = post.isEnablenotification();
        if (enableNotification) {
            logger.info("Enable notification for this user post.");
        } else {
            logger.info("Disable notification for this user post.");
        }
        logger.debug("Trying to share user post...");
        Post res = SocialUtils.shareUserUpdate((String)username, (String)postText, (String)context, (String)previewTitle, (String)previewDescription, (String)previewHost, (String)previewUrl, (String)httpImageUrl, (boolean)enableNotification);
        if (res != null) {
            logger.debug("Post correctly written by user " + username);
            responseBean.setResult((Object)res);
            responseBean.setSuccess(true);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        logger.error("Unable to write post.");
        responseBean.setMessage("Unable to write post");
        responseBean.setSuccess(false);
        status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-app/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfull created, the new post is reported in the 'result' field of the returned object"), @ResponseCode(code=403, condition="\"There is no application profile with such token"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllPostsByApp() {
        Caller caller = AuthorizationProvider.instance.get();
        String appId = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        ApplicationProfile appProfile = SocialUtils.getProfileFromInfrastrucure((String)appId, (String)context);
        if (appProfile == null) {
            logger.error("The given token is not belonging to an application!!!");
            status = Response.Status.FORBIDDEN;
            responseBean.setSuccess(false);
            responseBean.setMessage("Invalid token: not belonging to an application.");
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            logger.debug("Retrieving posts for app with id " + appId);
            List feeds = CassandraConnection.getInstance().getDatabookStore().getAllPostsByApp(appId);
            Filters.filterPostsPerContext((List)feeds, (String)context);
            responseBean.setSuccess(true);
            responseBean.setResult((Object)feeds);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such feeds.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="write-post-app")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfull created, the new post is reported in the 'result' field of the returned object"), @ResponseCode(code=403, condition="\"There is no application profile with such token"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response writePostApp(@NotNull(message="Post to write is null") @Valid PostInputBean post) {
        Caller caller = AuthorizationProvider.instance.get();
        String appId = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        logger.debug("Request of writing a feed coming from an application.");
        ApplicationProfile appProfile = SocialUtils.getProfileFromInfrastrucure((String)appId, (String)context);
        if (appProfile == null) {
            logger.error("The given token doesn't belong to an application!!!");
            responseBean.setSuccess(false);
            responseBean.setMessage("Invalid token: not belonging to an application.");
            status = Response.Status.FORBIDDEN;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        String postText = post.getText();
        String previewTitle = post.getPreviewtitle();
        String previewDescription = post.getPreviewdescription();
        String httpImageUrl = post.getHttpimageurl();
        boolean enableNotification = post.isEnablenotification();
        String params = post.getParams();
        if (enableNotification) {
            logger.debug("Enable notification for this application post.");
        } else {
            logger.debug("Disable notification for this application post.");
        }
        Post written = SocialUtils.shareApplicationUpdate((String)postText, (String)params, (String)previewTitle, (String)previewDescription, (String)httpImageUrl, (ApplicationProfile)appProfile, (Caller)caller, (boolean)enableNotification);
        if (written != null) {
            responseBean.setResult((Object)written);
            responseBean.setSuccess(true);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        logger.error("Unable to write post.");
        responseBean.setMessage("Unable to write post");
        responseBean.setSuccess(false);
        status = Response.Status.INTERNAL_SERVER_ERROR;
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-vre/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Sccessfull retrieved posts, they are reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllPostsByVRE() {
        String context = ScopeProvider.instance.get();
        Caller caller = AuthorizationProvider.instance.get();
        logger.debug("Retrieving all posts coming from vre = " + context);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            List posts = CassandraConnection.getInstance().getDatabookStore().getAllPostsByVRE(context);
            Filters.hideSensitiveInformation((List)posts, (String)caller.getClient().getId());
            responseBean.setResult((Object)posts);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve posts for vre = " + context, (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseBean.setMessage(e.toString());
            responseBean.setSuccess(false);
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-recent-posts-vre-by-range/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Sccessfull retrieved posts, they are reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getRecentPostsByVREAndRange(@QueryParam(value="from") @Min(value=1L, message="from cannot be negative") int from, @QueryParam(value="quantity") @Min(value=1L, message="quantity cannot be negative") int quantity) throws ValidationException {
        String context = ScopeProvider.instance.get();
        Caller caller = AuthorizationProvider.instance.get();
        logger.debug("Retrieving all posts coming from vre = " + context);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            RangePosts rangePosts = CassandraConnection.getInstance().getDatabookStore().getRecentPostsByVREAndRange(context, from, quantity);
            Filters.hideSensitiveInformation((List)rangePosts.getPosts(), (String)caller.getClient().getId());
            responseBean.setResult((Object)rangePosts);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve posts for vre = " + context, (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseBean.setMessage(e.toString());
            responseBean.setSuccess(false);
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-posts-by-hashtag/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Sccessfull retrieved posts, they are reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getPostsByHashTags(@QueryParam(value="hashtag") @NotNull(message="hashtag cannot be missing") String hashtag) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("User " + username + " has requested posts containing hashtag " + hashtag + " in context " + context);
        try {
            DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
            List posts = datastore.getVREPostsByHashtag(context, hashtag);
            Filters.hideSensitiveInformation((List)posts, (String)caller.getClient().getId());
            responseBean.setResult((Object)posts);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve hashtags", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-id-liked-posts/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Sccessfull retrieved ids, they are reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllLikedPostIdsByUser() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        logger.debug("Retrieving all liked posts for user with id " + username + " in context " + context);
        List retrievedLikedPostsIds = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            DatabookStore datastore = CassandraConnection.getInstance().getDatabookStore();
            retrievedLikedPostsIds = datastore.getAllLikedPostIdsByUser(username);
            Filters.filterFeedsPerContextById((List)retrievedLikedPostsIds, (String)context);
            responseBean.setResult((Object)retrievedLikedPostsIds);
            responseBean.setSuccess(true);
            logger.debug("Ids of liked posts by " + username + " retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to read such ids of liked Posts.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-liked-posts/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfull retrieved posts, they are reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllLikedPostsByUser(@DefaultValue(value="10") @QueryParam(value="limit") @Min(message="limit cannot be negative", value=0L) int limit) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        String context = ScopeProvider.instance.get();
        List retrievedLikedPosts = null;
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            logger.debug("Retrieving " + limit + " liked posts for user with id " + username + " in context " + context);
            retrievedLikedPosts = CassandraConnection.getInstance().getDatabookStore().getAllLikedPostsByUser(username, limit);
            Filters.filterPostsPerContext((List)retrievedLikedPosts, (String)context);
            Filters.hideSensitiveInformation((List)retrievedLikedPosts, (String)caller.getClient().getId());
            responseBean.setResult((Object)retrievedLikedPosts);
            responseBean.setSuccess(true);
            logger.debug("Liked posts by " + username + " retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to read such liked posts.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

