/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.social.networking.ws.inputs.CommentInputBean;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.Filters;
import org.gcube.portal.social.networking.ws.utils.SocialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/comments")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Comments {
    private static final Logger logger = LoggerFactory.getLogger(Comments.class);

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-by-post-id")
    @StatusCodes(value={@ResponseCode(code=200, condition="The list of comments is put into the 'result' field"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllCommentsByPostId(@NotNull @QueryParam(value="key") String key) {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getAllCommentByPost(key);
            Filters.filterCommentsPerContext((List)comments, (String)context);
            responseBean.setResult((Object)comments);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-user")
    @StatusCodes(value={@ResponseCode(code=200, condition="The list of comments is put into the 'result' field"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getCommentsUser() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, 0L);
            Filters.filterCommentsPerContext((List)comments, (String)context);
            responseBean.setResult((Object)comments);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-comments-user-by-time")
    public Response getCommentsUserByTime(@QueryParam(value="time") @Min(value=0L, message="time cannot be negative") long timeInMillis) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List comments = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            comments = CassandraConnection.getInstance().getDatabookStore().getRecentCommentsByUserAndDate(username, timeInMillis);
            Filters.filterCommentsPerContext((List)comments, (String)context);
            responseBean.setResult((Object)comments);
            responseBean.setMessage("");
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such comments.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="comment-post")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Successfull created, the new comment is reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response writeComment(@NotNull(message="Comment to write is missing") @Valid CommentInputBean comment) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.debug("Request of writing a comment coming from user " + username);
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            String postId = comment.getPostid();
            String commentText = comment.getText();
            String userid = username;
            Date time = new Date();
            String postOwnerId = CassandraConnection.getInstance().getDatabookStore().readPost(postId).getEntityId();
            Comment theComment = SocialUtils.commentPost((String)userid, (Date)time, (String)postId, (String)commentText, (String)postOwnerId, (String)context);
            if (theComment == null) {
                logger.error("Unable to write comment");
                responseBean.setMessage("Unable to write comment, something went wrong please see server log");
                responseBean.setSuccess(false);
                status = Response.Status.INTERNAL_SERVER_ERROR;
                return Response.status((Response.Status)status).entity((Object)responseBean).build();
            }
            logger.info("Added comment " + theComment.toString());
            responseBean.setResult((Object)true);
            responseBean.setSuccess(true);
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        catch (FeedIDNotFoundException ex) {
            logger.error("Unable to find a post comment", (Throwable)ex);
            responseBean.setMessage("Could not reach the DB to write the comment, something went wrong");
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        catch (Exception e) {
            logger.error("Unable to write comment", (Throwable)e);
            responseBean.setMessage("Could not reach the DB to write the comment, something went wrong");
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
    }
}

