/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.utils;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.ex.ApplicationProfileNotFoundException;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.databook.shared.ApplicationProfile;
import org.gcube.portal.databook.shared.Comment;
import org.gcube.portal.databook.shared.Like;
import org.gcube.portal.databook.shared.Post;
import org.gcube.portal.databook.shared.PostType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.CommentNotificationsThread;
import org.gcube.portal.notifications.thread.LikeNotificationsThread;
import org.gcube.portal.notifications.thread.MentionNotificationsThread;
import org.gcube.portal.notifications.thread.PostNotificationsThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portlets.widgets.pickitem.shared.ItemBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.QueryBox;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.social_networking.socialutillibrary.Utils;
import org.gcube.socialnetworking.socialtoken.SocialMessageParser;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocialUtils {
    private static final Logger logger = LoggerFactory.getLogger(SocialUtils.class);
    public static final String NO_TEXT_FILE_SHARE = "_N0_73X7_SH4R3_";
    public static final int CACHING_TIME_TO_EXPIRATION = 2506000;
    public static final String DISABLED_USERS_NOTIFICATIONS_NAMESPACE = "dun:";
    public static final String NEWS_FEED_PORTLET_CLASSNAME = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";

    private static ArrayList<GenericItemBean> getUsersFromUsernames(Set<String> mentions) {
        if (mentions.isEmpty()) {
            return new ArrayList<GenericItemBean>();
        }
        ArrayList<GenericItemBean> toReturn = new ArrayList<GenericItemBean>();
        UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();
        for (String username : mentions) {
            try {
                GCubeUser user = uManager.getUserByUsername(username);
                String fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
                toReturn.add(new GenericItemBean("" + user.getUserId(), username, fullName, ""));
            }
            catch (Exception exception) {
                logger.error("Unable to get user informations for username=" + username);
            }
        }
        return toReturn;
    }

    private static ArrayList<ItemBean> convertToItemBean(Collection<GenericItemBean> items) {
        ArrayList<ItemBean> toReturn = new ArrayList<ItemBean>(items.size());
        for (GenericItemBean item : items) {
            toReturn.add(new ItemBean(item.getId(), item.getName(), item.getAlternativeName(), item.getThumbnailURL()));
        }
        return toReturn;
    }

    public static Post shareApplicationUpdate(String postText, String uriParams, String previewTitle, String previewDescription, String httpImageUrl, ApplicationProfile applicationProfile, Caller caller, boolean notifyGroup) {
        SocialMessageParser messageParser = new SocialMessageParser(postText);
        String escapedPostText = messageParser.getParsedMessage();
        List hashtags = messageParser.getHashtags();
        ArrayList mentionedUsers = SocialUtils.getUsersFromUsernames((Set)Utils.getMentionedUsernames((String)postText));
        ArrayList mentionedUsersToConvertInHTML = SocialUtils.convertToItemBean((Collection)mentionedUsers);
        SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)ScopeProvider.instance.get());
        escapedPostText = Utils.convertMentionUsernamesAnchorHTML((String)escapedPostText, (ArrayList)mentionedUsersToConvertInHTML, (String)site.getSiteURL(), (String)site.getSiteLandingPagePath());
        logger.info("*** Escaped post text is " + escapedPostText);
        String scope = ScopeProvider.instance.get();
        String appId = caller.getClient().getId();
        Post toWrite = SocialUtils.buildPost((String)escapedPostText, (String)(uriParams == null ? "" : uriParams), (String)(previewTitle == null ? "" : previewTitle), (String)(previewDescription == null ? "" : previewDescription), (String)(httpImageUrl == null ? "" : httpImageUrl), (ApplicationProfile)applicationProfile, (String)scope);
        boolean res = CassandraConnection.getInstance().getDatabookStore().saveAppPost(toWrite);
        if (res) {
            logger.info("Feed correctly written by application " + appId);
            if (hashtags != null && !hashtags.isEmpty()) {
                new Thread(() -> {
                    try {
                        Thread.sleep(1000L);
                        CassandraConnection.getInstance().getDatabookStore().saveHashTags(toWrite.getKey(), scope, hashtags);
                    }
                    catch (Exception e1) {
                        logger.error("Failed to save hashtags in Cassandra", (Throwable)e1);
                    }
                }).start();
            }
            SocialNetworkingUser user = new SocialNetworkingUser(appId, "", applicationProfile.getName(), applicationProfile.getImageUrl());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, scope, user, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
            if (!mentionedUsers.isEmpty()) {
                new Thread((Runnable)new MentionNotificationsThread(toWrite.getKey(), toWrite.getDescription(), (NotificationsManager)nm, null, mentionedUsers)).start();
            }
            if (notifyGroup) {
                logger.debug("Sending notifications for " + appId + " " + scope);
                try {
                    String name = new ScopeBean(scope).name();
                    GroupManager gManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                    long groupId = gManager.getGroupId(name);
                    String groupName = gManager.getGroup(groupId).getGroupName();
                    logger.debug("Company id and name " + groupId + " " + groupName);
                    new Thread((Runnable)new PostNotificationsThread(UserManagerWSBuilder.getInstance().getUserManager(), toWrite.getKey(), toWrite.getDescription(), "" + groupId, (NotificationsManager)nm, new HashSet(hashtags), new HashSet())).start();
                }
                catch (Exception exception) {
                    logger.debug("Feed succesfully created but unable to send notifications.");
                }
            }
            return toWrite;
        }
        return null;
    }

    private static Post buildPost(String description, String uriParams, String previewTitle, String previewDescription, String previewThumbnailUrl, ApplicationProfile applicationProfile, String scopeApp) {
        String uri = applicationProfile.getUrl();
        if (uriParams != null && uriParams.compareTo("") != 0) {
            uri = String.valueOf(uri) + "?" + uriParams;
        }
        Post toReturn = new Post(UUID.randomUUID().toString(), PostType.PUBLISH, applicationProfile.getKey(), new Date(), scopeApp, uri, previewThumbnailUrl, description, PrivacyLevel.SINGLE_VRE, applicationProfile.getName(), "no-email", applicationProfile.getImageUrl(), previewTitle, previewDescription, "", true);
        return toReturn;
    }

    public static ApplicationProfile getProfileFromInfrastrucure(String idApp, String scopeApp) {
        ScopeBean scope = new ScopeBean(scopeApp);
        logger.debug("Trying to fetch applicationProfile profile from the infrastructure for " + idApp + " scope: " + scope);
        String rootInfrastructure = scopeApp.split("/")[1];
        ScopeProvider.instance.set("/" + rootInfrastructure);
        try {
            ApplicationProfile toReturn = new ApplicationProfile();
            QueryBox q = new QueryBox("for $profile in collection('/db/Profiles/GenericResource')//Resource where $profile/Profile/SecondaryType/string() eq 'ApplicationProfile' and  $profile/Profile/Body/AppId/string()  eq '" + idApp + "'" + "return $profile");
            DiscoveryClient client = ICFactory.client();
            List appProfile = client.submit((Query)q);
            if (appProfile == null || appProfile.size() == 0) {
                throw new Exception("Your applicationProfile is not registered in the infrastructure");
            }
            String elem = (String)appProfile.get(0);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element node = docBuilder.parse(new InputSource(new StringReader(elem))).getDocumentElement();
            XPathHelper helper = new XPathHelper((Node)node);
            List currValue = null;
            currValue = helper.evaluate("/Resource/Profile/Name/text()");
            if (currValue == null || currValue.size() <= 0) {
                throw new ApplicationProfileNotFoundException("Your applicationProfile NAME was not found in the profile");
            }
            toReturn.setName((String)currValue.get(0));
            currValue = helper.evaluate("/Resource/Profile/Description/text()");
            if (currValue != null && currValue.size() > 0) {
                toReturn.setDescription((String)currValue.get(0));
            } else {
                logger.warn("No Description exists for " + toReturn.getName());
            }
            currValue = helper.evaluate("/Resource/Profile/Body/AppId/text()");
            if (currValue == null || currValue.size() <= 0) {
                throw new ApplicationProfileNotFoundException("Your applicationProfile ID n was not found in the profile, consider adding <AppId> element in <Body>");
            }
            toReturn.setKey((String)currValue.get(0));
            currValue = helper.evaluate("/Resource/Profile/Body/ThumbnailURL/text()");
            if (currValue == null || currValue.size() <= 0) {
                throw new Exception("Your applicationProfile Image Url was not found in the profile, consider adding <ThumbnailURL> element in <Body>");
            }
            toReturn.setImageUrl((String)currValue.get(0));
            currValue = helper.evaluate("/Resource/Profile/Body/EndPoint/Scope/text()");
            if (currValue != null && currValue.size() > 0) {
                List scopes = currValue;
                boolean foundUrl = false;
                int i = 0;
                while (i < scopes.size()) {
                    if (((String)currValue.get(i)).trim().compareTo(scope.toString()) == 0) {
                        toReturn.setUrl((String)helper.evaluate("/Resource/Profile/Body/EndPoint/URL/text()").get(i));
                        toReturn.setScope(scope.toString());
                        foundUrl = true;
                        break;
                    }
                    ++i;
                }
                if (!foundUrl) {
                    throw new ApplicationProfileNotFoundException("Your applicationProfile URL was not found in the profile for Scope: " + scope.toString());
                }
            } else {
                throw new ApplicationProfileNotFoundException("Your applicationProfile EndPoint was not found in the profile, consider adding <EndPoint><Scope> element in <Body>");
            }
            logger.debug("Returning " + toReturn);
            ApplicationProfile applicationProfile = toReturn;
            return applicationProfile;
        }
        catch (Exception e) {
            logger.error("Error while trying to fetch applicationProfile profile from the infrastructure", (Throwable)e);
        }
        finally {
            ScopeProvider.instance.set(scopeApp);
        }
        return null;
    }

    public static Post shareUserUpdate(String userId, String postText, String vreId, String previewTitle, String previewDescription, String previewHost, String previewUrl, String urlThumbnail, boolean notifyGroup) {
        String url;
        GCubeUser user;
        SocialMessageParser messageParser = new SocialMessageParser(postText);
        String escapedPostText = messageParser.getParsedMessage();
        List hashtags = messageParser.getHashtags();
        ArrayList mentionedUsers = SocialUtils.getUsersFromUsernames((Set)Utils.getMentionedUsernames((String)postText));
        ArrayList mentionedUsersToConvertInHTML = SocialUtils.convertToItemBean((Collection)mentionedUsers);
        SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)ScopeProvider.instance.get());
        escapedPostText = Utils.convertMentionUsernamesAnchorHTML((String)escapedPostText, (ArrayList)mentionedUsersToConvertInHTML, (String)site.getSiteURL(), (String)site.getSiteLandingPagePath());
        UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();
        try {
            user = uManager.getUserByUsername(userId);
        }
        catch (Exception e) {
            logger.error("Unable to get user informations, post write fails.", (Throwable)e);
            return null;
        }
        String email = user.getEmail();
        String fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
        String thumbnailURL = user.getUserAvatarURL();
        String linkTitle = previewTitle == null ? "" : previewTitle;
        String linkDesc = previewDescription == null ? "" : previewDescription;
        String host = previewHost == null ? "" : previewHost;
        String string = url = previewUrl == null ? "" : previewUrl;
        if (urlThumbnail == null) {
            urlThumbnail = "null";
        }
        String textToPost = "";
        textToPost = escapedPostText.trim().compareTo("_N0_73X7_SH4R3_") == 0 ? Utils.convertFileNameAnchorHTML((String)url) : escapedPostText;
        Post toShare = new Post(UUID.randomUUID().toString(), PostType.PUBLISH, userId, new Date(), vreId, url, urlThumbnail, textToPost, PrivacyLevel.SINGLE_VRE, fullName, email, thumbnailURL, linkTitle, linkDesc, host);
        logger.info("Attempting to save Post with text: " + textToPost + " Level = " + PrivacyLevel.SINGLE_VRE + " Timeline = " + vreId);
        boolean result = CassandraConnection.getInstance().getDatabookStore().saveUserPost(toShare);
        if (vreId != null && vreId.compareTo("") != 0 && result) {
            logger.trace("Attempting to write onto " + vreId);
            try {
                try {
                    logger.info("Sleeping waiting for cassandra's update");
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    logger.error(e.toString());
                }
                CassandraConnection.getInstance().getDatabookStore().saveFeedToVRETimeline(toShare.getKey(), vreId);
                if (hashtags != null && !hashtags.isEmpty()) {
                    CassandraConnection.getInstance().getDatabookStore().saveHashTags(toShare.getKey(), vreId, hashtags);
                }
            }
            catch (FeedIDNotFoundException feedIDNotFoundException) {
                logger.error("Error writing onto VRES Time Line" + vreId);
            }
            logger.trace("Success writing onto " + vreId);
        }
        if (!result) {
            return null;
        }
        SocialNetworkingUser socialUser = new SocialNetworkingUser(userId, email, fullName, thumbnailURL);
        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, vreId, socialUser, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
        if (!mentionedUsers.isEmpty()) {
            new Thread((Runnable)new MentionNotificationsThread(toShare.getKey(), toShare.getDescription(), (NotificationsManager)nm, null, mentionedUsers)).start();
        }
        if (vreId != null && vreId.compareTo("") != 0 && notifyGroup) {
            try {
                GroupManager gManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                String name = new ScopeBean(vreId).name();
                long groupId = gManager.getGroupId(name);
                String groupName = gManager.getGroup(groupId).getGroupName();
                logger.debug("Company id and name " + groupId + " " + groupName);
                new Thread((Runnable)new PostNotificationsThread(UserManagerWSBuilder.getInstance().getUserManager(), toShare.getKey(), toShare.getDescription(), "" + groupId, (NotificationsManager)nm, new HashSet(), new HashSet(hashtags))).start();
                logger.debug("Start sending notifications for post written by " + userId);
            }
            catch (Exception e) {
                logger.error("Unable to notify users", (Throwable)e);
            }
        }
        return toShare;
    }

    public static Comment commentPost(String userid, Date time, String postId, String commentText, String postOwnerId, String context) throws FeedIDNotFoundException {
        GCubeUser user;
        SocialMessageParser messageParser = new SocialMessageParser(commentText);
        String escapedCommentText = messageParser.getParsedMessage();
        ArrayList mentionedUsers = SocialUtils.getUsersFromUsernames((Set)Utils.getMentionedUsernames((String)commentText));
        ArrayList mentionedUsersToConvertInHTML = SocialUtils.convertToItemBean((Collection)mentionedUsers);
        SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)ScopeProvider.instance.get());
        escapedCommentText = Utils.convertMentionUsernamesAnchorHTML((String)escapedCommentText, (ArrayList)mentionedUsersToConvertInHTML, (String)site.getSiteURL(), (String)site.getSiteLandingPagePath());
        UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();
        try {
            user = uManager.getUserByUsername(userid);
        }
        catch (Exception e) {
            logger.error("Unable to get user informations, comment write fails.", (Throwable)e);
            return null;
        }
        String commentKey = UUID.randomUUID().toString();
        String email = user.getEmail();
        String fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
        String thumbnailURL = user.getUserAvatarURL();
        Comment theComment = new Comment(commentKey, userid, time, postId, escapedCommentText, fullName, thumbnailURL);
        logger.info("Attempting to save Comment with text: " + commentText + " postid=" + postId);
        boolean result = CassandraConnection.getInstance().getDatabookStore().addComment(theComment);
        logger.info("Added comment? " + theComment.toString() + " Result is " + result);
        if (!result) {
            return null;
        }
        SocialNetworkingUser socialUser = new SocialNetworkingUser(userid, email, fullName, thumbnailURL);
        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(uManager, site, context, socialUser, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
        logger.info("The post creator is " + postOwnerId);
        if (!user.getUsername().equals(postOwnerId)) {
            boolean resultNotifyOwnComment = nm.notifyOwnCommentReply(postOwnerId, postId, escapedCommentText, theComment.getKey());
            logger.info("Comment Notification to post creator added? " + resultNotifyOwnComment);
        }
        ArrayList likes = SocialUtils.getAllLikesByPost((String)postId);
        Thread likesThread = new Thread((Runnable)new LikeNotificationsThread(escapedCommentText, (NotificationsManager)nm, likes, postOwnerId, theComment.getKey()));
        likesThread.start();
        Thread commentsNotificationthread = new Thread((Runnable)new CommentNotificationsThread(CassandraConnection.getInstance().getDatabookStore(), uManager, user.getUsername(), theComment.getFeedid(), escapedCommentText, (NotificationsManager)nm, postOwnerId, theComment.getKey(), likes));
        commentsNotificationthread.start();
        if (mentionedUsers != null && mentionedUsers.size() > 0) {
            ArrayList<GenericItemBean> toPass = new ArrayList<GenericItemBean>();
            HashMap<String, ItemBean> uniqueUsersToNotify = new HashMap<String, ItemBean>();
            LiferayUserManager um = new LiferayUserManager();
            for (ItemBean bean : mentionedUsersToConvertInHTML) {
                if (bean.isItemGroup()) {
                    try {
                        List teamUsers = um.listUsersByTeam(Long.parseLong(bean.getId()));
                        for (GCubeUser userTeam : teamUsers) {
                            if (uniqueUsersToNotify.containsKey(userTeam.getUsername())) continue;
                            uniqueUsersToNotify.put(userTeam.getUsername(), new ItemBean(String.valueOf(userTeam.getUserId()), userTeam.getUsername(), userTeam.getFullname(), userTeam.getUserAvatarURL()));
                        }
                    }
                    catch (NumberFormatException | TeamRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                        logger.error("Unable to retrieve team information", e);
                    }
                    continue;
                }
                if (uniqueUsersToNotify.containsKey(bean.getName())) continue;
                uniqueUsersToNotify.put(bean.getName(), bean);
            }
            for (Map.Entry userEntry : uniqueUsersToNotify.entrySet()) {
                ItemBean userBean = (ItemBean)userEntry.getValue();
                toPass.add(new GenericItemBean(userBean.getId(), userBean.getName(), userBean.getAlternativeName(), userBean.getThumbnailURL()));
            }
            Thread thread = new Thread((Runnable)new MentionNotificationsThread(theComment.getFeedid(), escapedCommentText, (NotificationsManager)nm, null, toPass));
            thread.start();
        }
        return theComment;
    }

    private static ArrayList<Like> getAllLikesByPost(String postid) {
        ArrayList toReturn = (ArrayList)CassandraConnection.getInstance().getDatabookStore().getAllLikesByPost(postid);
        logger.debug("Asking likes for " + postid);
        for (Like like : toReturn) {
            GCubeUser user;
            UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();
            try {
                user = uManager.getUserByUsername(like.getUserid());
            }
            catch (Exception e) {
                logger.error("Unable to get user informations, comment write fails.", (Throwable)e);
                return null;
            }
            String thumbnailURL = user.getUserAvatarURL();
            like.setThumbnailURL(thumbnailURL == null ? "" : thumbnailURL);
        }
        return toReturn;
    }

    public static boolean like(String username, String postid, String context) {
        GCubeUser user;
        boolean likeCommitResult = false;
        UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();
        try {
            user = uManager.getUserByUsername(username);
        }
        catch (Exception e) {
            logger.error("Unable to get user informations, like write fails.", (Throwable)e);
            return false;
        }
        String email = user.getEmail();
        String fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
        String thumbnailURL = user.getUserAvatarURL();
        SocialNetworkingUser socialUser = new SocialNetworkingUser(user.getUsername(), email, fullName, thumbnailURL);
        Like toLike = new Like(UUID.randomUUID().toString(), user.getUsername(), new Date(), postid, user.getFullname(), user.getUserAvatarURL());
        Post thePost = null;
        try {
            logger.info("Attempting to read post with id: " + postid);
            thePost = CassandraConnection.getInstance().getDatabookStore().readPost(postid);
            likeCommitResult = CassandraConnection.getInstance().getDatabookStore().like(toLike);
        }
        catch (Exception e) {
            logger.error("Post not found for this like ot could not like the post " + e.getMessage());
            return false;
        }
        boolean resultNotifyLike = false;
        if (likeCommitResult) {
            SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)ScopeProvider.instance.get());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, socialUser, "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
            String postText = thePost.getDescription();
            String postOwnerId = thePost.getEntityId();
            SocialMessageParser messageParser = new SocialMessageParser(postText);
            String escapedPostText = messageParser.getParsedMessage();
            logger.info("The post creator is " + postOwnerId);
            if (!user.getUsername().equals(postOwnerId)) {
                resultNotifyLike = nm.notifyLikedPost(postOwnerId, postid, escapedPostText);
                logger.info("Like Notification to post creator added? " + resultNotifyLike);
            }
        }
        return likeCommitResult && resultNotifyLike;
    }

    public static boolean unlike(String username, String postid) {
        GCubeUser user;
        boolean unlikeCommitResult = false;
        UserManager uManager = UserManagerWSBuilder.getInstance().getUserManager();
        try {
            user = uManager.getUserByUsername(username);
        }
        catch (Exception e) {
            logger.error("Unable to get user informations, unlike write fails.", (Throwable)e);
            return false;
        }
        String fullName = String.valueOf(user.getFirstName()) + " " + user.getLastName();
        String thumbnailURL = user.getUserAvatarURL();
        try {
            unlikeCommitResult = CassandraConnection.getInstance().getDatabookStore().unlike(username, fullName, thumbnailURL);
        }
        catch (Exception e) {
            logger.error("Post not Found for this like ot could not unlike the post " + e.getMessage());
            return false;
        }
        return unlikeCommitResult;
    }
}

