package org.gcube.portal.social.networking.ws.inputs;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.fasterxml.jackson.annotation.JsonProperty;


/**
 * Post id object
 */
//@ApiModel(description="An object containing the app_id field", value="Application")
public class PostId {

	@JsonProperty("postid")
	@NotNull(message="postid cannot be null")
	@Size(message="postid cannot be empty", min=1)
	private String postid;

	public PostId() {
		super();
	}

	public PostId(String postid) {
		super();
		this.postid = postid;
	}

	public String getPostId() {
		return postid;
	}

	public void setPostId(String postid) {
		this.postid = postid;
	}

	@Override
	public String toString() {
		return "PostId [postid=" + postid + "]";
	}
}
