/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.RoleManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
@Path(value="2/people")
public class People {
    private static final Logger logger = LoggerFactory.getLogger(People.class);

    @Produces(value={"application/json"})
    @GET
    @Path(value="profile")
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful retrieval of user's profile, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getProfile() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        GCubeUser user = null;
        String scope = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        if (!TokensUtils.isUserToken((Caller)caller)) {
            status = Response.Status.FORBIDDEN;
            responseBean.setMessage("User's information can only be retrieved through a user token");
            logger.warn("Trying to access users method via a token different than 'user-token' is not allowed");
        } else {
            try {
                UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
                RoleManager roleManager = RoleManagerWSBuilder.getInstance().getRoleManager();
                GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                user = userManager.getUserByUsername(username);
                HashMap<String, Object> toReturn = new HashMap<String, Object>();
                toReturn.put("username", user.getUsername());
                toReturn.put("avatar", user.getUserAvatarURL());
                toReturn.put("fullname", user.getFullname());
                toReturn.put("context", scope);
                List roles = roleManager.listRolesByUserAndGroup(user.getUserId(), groupManager.getGroupIdFromInfrastructureScope(scope));
                ArrayList<String> rolesNames = new ArrayList<String>();
                for (GCubeRole gCubeRole : roles) {
                    rolesNames.add(gCubeRole.getRoleName());
                }
                toReturn.put("roles", rolesNames);
                responseBean.setResult(toReturn);
                responseBean.setSuccess(true);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve user's profile", (Throwable)e);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

