/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/likes")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Likes {
    private static final Logger logger = LoggerFactory.getLogger(Likes.class);

    @GET
    @Produces(value={"application/json"})
    @Path(value="get-likes-by-post-id")
    @StatusCodes(value={@ResponseCode(code=200, condition="The list of likes is put into the 'result' field"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getAllLikesByPostId(@NotNull @QueryParam(value="key") String key) {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Caller caller = AuthorizationProvider.instance.get();
        ScopeProvider.instance.get();
        String username = caller.getClient().getId();
        List likes = null;
        try {
            logger.info("Retrieving comments for user id " + username);
            likes = CassandraConnection.getInstance().getDatabookStore().getAllLikesByPost(key);
            responseBean.setResult((Object)likes);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such likes.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

