/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.KetamaConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DistributedCacheClient {
    private static final Logger logger = LoggerFactory.getLogger(DistributedCacheClient.class);
    private static final String MEMCACHED_RESOURCE_NAME = "Memcached";
    private static final String CATEGORY = "Database";
    private MemcachedClient mClient;

    public DistributedCacheClient() {
        List addrs = DistributedCacheClient.discoverHostOfServiceEndpoint();
        try {
            this.mClient = new MemcachedClient((ConnectionFactory)new KetamaConnectionFactory(), addrs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MemcachedClient getMemcachedClient() {
        return this.mClient;
    }

    private static List<InetSocketAddress> discoverHostOfServiceEndpoint() {
        String currentScope = ScopeProvider.instance.get();
        ApplicationContext ctx = ContextProvider.get();
        String infrastructure = "/" + ctx.container().configuration().infrastructure();
        ScopeProvider.instance.set(infrastructure);
        ArrayList<InetSocketAddress> toReturn = new ArrayList<InetSocketAddress>();
        try {
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/text() eq 'Memcached'");
            query.addCondition("$resource/Profile/Category/text() eq 'Database'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List ses = client.submit((Query)query);
            if (ses.isEmpty()) {
                logger.error("There is no Memcached cluster having name: Memcached and Category Database on root context in this infrastructure: ");
                return null;
            }
            try {
                Iterator iterator = ses.iterator();
                if (iterator.hasNext()) {
                    ServiceEndpoint se = (ServiceEndpoint)iterator.next();
                    Group aps = se.profile().accessPoints();
                    for (ServiceEndpoint.AccessPoint ap : aps.asCollection()) {
                        String address = ap.address();
                        String[] splits = address.split(":");
                        String hostname = splits[0];
                        int port = Integer.parseInt(splits[1]);
                        toReturn.add(new InetSocketAddress(hostname, port));
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Error while retrieving hosts for the Memcached cluster having name: Memcached and Category Database on root context");
            }
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        return toReturn;
    }
}

