/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.caches;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.social.networking.caches.CachesManager;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocialNetworkingSiteFinder {
    private static final Logger logger = LoggerFactory.getLogger(SocialNetworkingSiteFinder.class);
    private static final String EMAIL_SENDER_SITE_CUSTOM_FIELD = "Emailsender";
    private static final String CATEGORY = "Portal";
    private static String PROD_FALLBACK_GATEWAY = "D4Science.org Gateway";
    private static String DEV_FALLBACK_GATEWAY = "gCube Snapshot Gateway";
    private static String PREPROD_FALLBACK_GATEWAY = "D4Science Preproduction Gateway";
    private static SocialNetworkingSiteFinder singleton = new SocialNetworkingSiteFinder();

    private SocialNetworkingSiteFinder() {
        try {
            logger.info("Trying to read config.properties");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            InputStream input = classLoader.getResourceAsStream("config.properties");
            Properties properties = new Properties();
            properties.load(input);
            PROD_FALLBACK_GATEWAY = properties.getProperty("PROD_FALLBACK_GATEWAY");
            DEV_FALLBACK_GATEWAY = properties.getProperty("DEV_FALLBACK_GATEWAY");
            PREPROD_FALLBACK_GATEWAY = properties.getProperty("PREPROD_FALLBACK_GATEWAY");
        }
        catch (Exception e) {
            logger.warn("Failed to read config.properties...", (Throwable)e);
        }
    }

    public static SocialNetworkingSiteFinder getInstance() {
        return singleton;
    }

    public static SocialNetworkingSite getSocialNetworkingSiteFromScope(String scope) {
        Ehcache socialSitesCache = CachesManager.getCache((String)"social_networking_site_cache");
        if (scope == null || scope.isEmpty()) {
            throw new IllegalArgumentException("Scope cannot be null/empty");
        }
        if (socialSitesCache.get((Serializable)((Object)scope)) != null) {
            return (SocialNetworkingSite)socialSitesCache.get((Serializable)((Object)scope)).getObjectValue();
        }
        SocialNetworkingSite site = SocialNetworkingSiteFinder.discoverSite((String)scope);
        if (site != null) {
            socialSitesCache.put(new Element((Serializable)((Object)scope), (Serializable)site));
        }
        return site;
    }

    private static SocialNetworkingSite discoverSite(String scope) {
        GCubeGroup matchingGateway;
        GroupManager groupManager;
        block13: {
            try {
                block12: {
                    logger.info("Requested site for scope " + scope);
                    groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
                    long groupId = groupManager.getGroupIdFromInfrastructureScope(scope);
                    matchingGateway = null;
                    if (groupManager.isVRE(groupId).booleanValue()) {
                        List virtualGroupsOfGroup = groupManager.getVirtualGroups(groupId);
                        if (virtualGroupsOfGroup == null || virtualGroupsOfGroup.isEmpty()) {
                            throw new Exception("It seems that the VRE is not linked to any VirtualGroups");
                        }
                        List gateways = groupManager.getGateways();
                        if (gateways == null || gateways.isEmpty()) {
                            throw new Exception("It seems there is no gateway here!");
                        }
                        logger.info("Retrieved Gateways are " + gateways);
                        for (GCubeGroup gateway : gateways) {
                            List gatewayVirtualGroups = groupManager.getVirtualGroups(gateway.getGroupId());
                            if (gatewayVirtualGroups == null || gatewayVirtualGroups.isEmpty()) continue;
                            for (VirtualGroup gatewayVirtualGroup : gatewayVirtualGroups) {
                                if (!virtualGroupsOfGroup.contains(gatewayVirtualGroup)) continue;
                                logger.info("Matching gateway for scope " + scope + " is " + gateway);
                                matchingGateway = gateway;
                                break block12;
                            }
                        }
                    } else {
                        List gateways = groupManager.getGateways();
                        ApplicationContext ctx = ContextProvider.get();
                        String rootContext = "/" + ctx.container().configuration().infrastructure();
                        String matchingGatewayName = null;
                        matchingGatewayName = SocialNetworkingSiteFinder.isDevOrPreprod((String)rootContext) ? DEV_FALLBACK_GATEWAY : PROD_FALLBACK_GATEWAY;
                        for (GCubeGroup gateway : gateways) {
                            if (!gateway.getGroupName().equals(matchingGatewayName)) continue;
                            matchingGateway = gateway;
                            break;
                        }
                        if (matchingGateway == null && SocialNetworkingSiteFinder.isDevOrPreprod((String)rootContext)) {
                            logger.warn("Checking if it is the preprod environment");
                            matchingGatewayName = PREPROD_FALLBACK_GATEWAY;
                            for (GCubeGroup gateway : gateways) {
                                if (!gateway.getGroupName().equals(matchingGatewayName)) continue;
                                matchingGateway = gateway;
                                break;
                            }
                        }
                    }
                }
                if (matchingGateway != null) break block13;
                logger.warn("There is no gateway for such scope. Returning null");
                return null;
            }
            catch (Exception e) {
                logger.error("Failed to determine the SocialNetworkingSite for scope " + scope, (Throwable)e);
                return null;
            }
        }
        String siteName = matchingGateway.getGroupName();
        String emailSender = (String)((Object)groupManager.readCustomAttr(matchingGateway.getGroupId(), "Emailsender"));
        emailSender = emailSender.replace("\"", "");
        String siteLandingPagePath = "/group" + matchingGateway.getFriendlyURL();
        String siteUrl = SocialNetworkingSiteFinder.discoverHostOfServiceEndpoint((String)siteName);
        SocialNetworkingSite site = new SocialNetworkingSite(siteName, emailSender, siteUrl, siteLandingPagePath);
        logger.info("Site is " + site);
        return site;
    }

    private static boolean isDevOrPreprod(String rootContext) {
        return rootContext.equals("/gcube") || rootContext.equals("/pred4s");
    }

    private static String discoverHostOfServiceEndpoint(String gatewayName) {
        String currentScope = ScopeProvider.instance.get();
        ApplicationContext ctx = ContextProvider.get();
        ScopeProvider.instance.set("/" + ctx.container().configuration().infrastructure());
        String host = null;
        try {
            try {
                XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
                query.addCondition("$resource/Profile/Name/text() eq '" + gatewayName + "'");
                query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
                DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
                List toReturn = client.submit((Query)query);
                Iterator iterator = toReturn.iterator();
                if (iterator.hasNext()) {
                    ServiceEndpoint serviceEndpoint = (ServiceEndpoint)iterator.next();
                    host = "https://" + serviceEndpoint.profile().runtime().hostedOn();
                    logger.info("Gateway host is " + host);
                }
            }
            catch (Exception exception) {
                logger.error("Error while retrieving host for the gateway " + gatewayName);
                ScopeProvider.instance.set(currentScope);
            }
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        return host;
    }
}

