/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.databook.shared.RunningJob;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.JobStatusNotificationThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.caches.UsersCache;
import org.gcube.portal.social.networking.liferay.ws.GroupManagerWSBuilder;
import org.gcube.portal.social.networking.liferay.ws.LiferayJSONWsCredentials;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.ex.AuthException;
import org.gcube.portal.social.networking.ws.inputs.UserSetNotificationBean;
import org.gcube.portal.social.networking.ws.mappers.CatalogueEventTypeMapper;
import org.gcube.portal.social.networking.ws.mappers.JobMapper;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.CassandraConnection;
import org.gcube.portal.social.networking.ws.utils.DistributedCacheClient;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.social_networking.socialnetworking.model.beans.JobNotificationBean;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEvent;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEventType;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.WorkspaceEvent;
import org.gcube.social_networking.socialnetworking.model.beans.workspace.WorkspaceEventType;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.mortbay.log.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="2/notifications")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Notifications {
    private static final Logger logger;
    private static final String INFRASTRUCTURE_MANAGER_ROLE = "Infrastructure-Manager";
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$gcube$social_networking$socialnetworking$model$beans$workspace$WorkspaceEventType;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        Notifications.ajc$preClinit();
        logger = LoggerFactory.getLogger(Notifications.class);
    }

    @GET
    @Path(value="get-range-notifications/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Notifications retrieved and reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getRangeNotifications(@DefaultValue(value="1") @QueryParam(value="from") @Min(value=1L, message="from must be greater or equal to 1") int from, @DefaultValue(value="10") @QueryParam(value="quantity") @Min(value=0L, message="quantity must be greater or equal to 0") int quantity) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        logger.debug("Retrieving " + quantity + " notifications of user = " + username + " from " + from);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        List notifications = null;
        try {
            notifications = CassandraConnection.getInstance().getDatabookStore().getRangeNotificationsByUser(username, from, quantity);
            responseBean.setResult((Object)notifications);
            responseBean.setSuccess(true);
            logger.debug("List of notifications retrieved");
        }
        catch (Exception e) {
            logger.error("Unable to retrieve such notifications.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="is-user-disabled/")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="true if the notification for the username given as query param are disabled (Catalogue and Workspace ones), false otherwise"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=AuthException.class)
    public Response isUserDisabled(@QueryParam(value="username") @NotNull(message="username cannot be null") String username) throws ValidationException {
        String string = username;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            Boolean userDisabled = !this.isNotificationEnabled(username);
            responseBean.setResult((Object)userDisabled);
            responseBean.setSuccess(true);
            logger.debug("are User " + username + " Notifications Disabled?" + userDisabled);
        }
        catch (Exception e) {
            logger.error("Unable to read whether the notifications for this user are enabled or not.", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            responseBean.setSuccess(false);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="set-user-notifications/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Notification set Off or On correctly executed"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=AuthException.class)
    public Response setUserNotifications(@NotNull(message="input is missing") @Valid UserSetNotificationBean setting) throws ValidationException {
        UserSetNotificationBean userSetNotificationBean = setting;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)userSetNotificationBean);
        AuthorizationAspect.aspectOf().before(joinPoint);
        Caller caller = AuthorizationProvider.instance.get();
        ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            String opExecutor = caller.getClient().getId();
            Boolean result = this.setUserNotificationsOnOff(setting.getUsername(), setting.isDisableNotification(), opExecutor);
            String toReturn = "Could not set notifications";
            if (result.booleanValue()) {
                toReturn = "Notifications have been set";
                toReturn = String.valueOf(toReturn) + (setting.isDisableNotification() ? " OFF (for 29 days unless re-enabled manually) " : " ON ");
                toReturn = String.valueOf(toReturn) + "for username=" + setting.getUsername();
            }
            responseBean.setSuccess(true);
            responseBean.setResult((Object)toReturn);
        }
        catch (Exception e) {
            logger.error("Unable to set user notification", (Throwable)e);
            responseBean.setSuccess(false);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    private boolean isNotificationEnabled(String usernameToCheck) {
        MemcachedClient entries = new DistributedCacheClient().getMemcachedClient();
        String key = "dun:" + usernameToCheck;
        Boolean userEnabled = false;
        if (entries.get(key) == null) {
            userEnabled = true;
        }
        return userEnabled;
    }

    private Boolean setUserNotificationsOnOff(String username, boolean disable, String callerId) {
        MemcachedClient entries = new DistributedCacheClient().getMemcachedClient();
        String key = "dun:" + username;
        OperationFuture result = null;
        result = disable ? entries.set(key, 2506000, (Object)("op.ex:" + callerId)) : entries.delete(key);
        try {
            return result.getStatus().isSuccess();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @POST
    @Path(value="notify-job-status/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Notification is sent correctly"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response notifyJobStatus(@NotNull(message="input is missing") @Valid JobNotificationBean job) throws ValidationException {
        Caller caller = AuthorizationProvider.instance.get();
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        String appQualifier = caller.getClient().getId();
        logger.info("Received request from app " + appQualifier + " to notify job status described by bean " + job);
        try {
            String recipient = job.getRecipient();
            GCubeUser userRecipient = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(recipient);
            GenericItemBean recipientBean = new GenericItemBean(userRecipient.getUsername(), userRecipient.getUsername(), userRecipient.getFullname(), userRecipient.getUserAvatarURL());
            SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)context);
            GCubeUser senderUser = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
            SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, user);
            RunningJob theJob = JobMapper.getJob((JobNotificationBean)job);
            new Thread((Runnable)new JobStatusNotificationThread(theJob, Arrays.asList(recipientBean), (NotificationsManager)nm)).start();
            responseBean.setSuccess(true);
            responseBean.setResult((Object)"Notification thread started");
        }
        catch (Exception e) {
            logger.error("Unable to send job notification", (Throwable)e);
            responseBean.setSuccess(false);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="catalogue/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Catalogue Notification is sent correctly"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response catalogue(@NotNull(message="input is missing") @Valid CatalogueEvent event) throws ValidationException, UserManagementSystemException, UserRetrievalFault {
        boolean deliveryResult;
        Response.Status status;
        ResponseBean responseBean;
        block19: {
            Caller caller = AuthorizationProvider.instance.get();
            UserManager um = UserManagerWSBuilder.getInstance().getUserManager();
            GCubeUser senderUser = null;
            SocialNetworkingUser user = null;
            String username = null;
            String fullName = "";
            logger.debug("Catalogue Notification called by " + caller.getClient().getId() + " isUser?" + TokensUtils.isUserToken((Caller)caller));
            if (!TokensUtils.isUserToken((Caller)caller)) {
                GCubeUser jarvis = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
                SecurityTokenProvider.instance.set(LiferayJSONWsCredentials.getSingleton().getNotifierUserToken());
                username = jarvis.getUsername();
                fullName = caller.getClient().getId().replace("service-account-", "");
                senderUser = um.getUserByUsername(username);
                user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), fullName, senderUser.getUserAvatarURL());
            } else {
                username = caller.getClient().getId();
                senderUser = um.getUserByUsername(username);
                user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            }
            String context = ScopeProvider.instance.get();
            logger.debug("catalogue notifications from user = " + username);
            responseBean = new ResponseBean();
            status = Response.Status.OK;
            deliveryResult = false;
            try {
                logger.debug("catalogue notifications type is " + event.getType());
                SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)context);
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, user);
                String[] idsToNotify = event.getIdsToNotify();
                if (!event.idsAsGroup()) {
                    int i = 0;
                    while (i < idsToNotify.length) {
                        String userIdToNotify = idsToNotify[i];
                        if (this.isNotificationEnabled(userIdToNotify)) {
                            String username2Notify = null;
                            try {
                                username2Notify = um.getUserByUsername(userIdToNotify).getUsername();
                            }
                            catch (Exception e) {
                                status = Response.Status.BAD_REQUEST;
                                logger.error("Username not found", (Throwable)e);
                                responseBean.setSuccess(false);
                                responseBean.setMessage("Username not found, got: " + userIdToNotify);
                                return Response.status((Response.Status)status).entity((Object)responseBean).build();
                            }
                            deliveryResult = nm.notifyCatalogueEvent(CatalogueEventTypeMapper.getType((CatalogueEventType)event.getType()), username2Notify, event.getItemId(), event.getNotifyText(), event.getItemURL());
                        } else {
                            Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                        }
                        ++i;
                    }
                    break block19;
                }
                int i = 0;
                while (i < idsToNotify.length) {
                    String contextId = idsToNotify[i];
                    try {
                        ScopeBean scope = new ScopeBean(contextId);
                        if (scope.type() != ScopeBean.Type.VRE) {
                            logger.error("Context not a VRE");
                            status = Response.Status.BAD_REQUEST;
                            responseBean.setSuccess(false);
                            responseBean.setMessage("Not a VRE Context, only VREs are supported");
                            return Response.status((Response.Status)status).entity((Object)responseBean).build();
                        }
                        String[] userIdsToNotify = this.getUsernamesByContext(scope).toArray(new String[0]);
                        int j = 0;
                        while (j < userIdsToNotify.length) {
                            String userIdToNotify = userIdsToNotify[j];
                            if (this.isNotificationEnabled(userIdToNotify)) {
                                deliveryResult = nm.notifyCatalogueEvent(CatalogueEventTypeMapper.getType((CatalogueEventType)event.getType()), userIdToNotify, event.getItemId(), event.getNotifyText(), event.getItemURL());
                            } else {
                                Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                            }
                            ++j;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        status = Response.Status.BAD_REQUEST;
                        logger.error("Context not valid", (Throwable)e);
                        responseBean.setSuccess(false);
                        responseBean.setMessage("Context not valid, must start with / " + e.getMessage());
                        return Response.status((Response.Status)status).entity((Object)responseBean).build();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error("Unable to send job notification", (Throwable)e);
                responseBean.setSuccess(false);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        logger.debug("catalogue notifications should have been sent");
        if (deliveryResult) {
            responseBean.setSuccess(true);
            responseBean.setMessage("catalogue notification delivered correctly");
            responseBean.setResult((Object)new Boolean(true));
        } else {
            responseBean.setSuccess(false);
            responseBean.setMessage("An error occurred between this service and Cassandra DB, notification not delivered correctly");
            responseBean.setResult((Object)new Boolean(false));
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @POST
    @Path(value="workspace/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Workspace Notification is sent correctly"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response workspace(@NotNull(message="input is missing") @Valid WorkspaceEvent event) throws ValidationException {
        boolean deliveryResult;
        Response.Status status;
        ResponseBean responseBean;
        block17: {
            Caller caller = AuthorizationProvider.instance.get();
            String context = ScopeProvider.instance.get();
            String username = caller.getClient().getId();
            logger.debug("workspace notifications from user = " + username);
            responseBean = new ResponseBean();
            status = Response.Status.OK;
            deliveryResult = false;
            try {
                logger.debug("workspace notifications type is " + event.getType());
                SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)context);
                UserManager um = UserManagerWSBuilder.getInstance().getUserManager();
                GCubeUser senderUser = um.getUserByUsername(username);
                SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
                ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, context, user);
                String[] idsToNotify = event.getIdsToNotify();
                if (!event.idsAsGroup()) {
                    int i = 0;
                    while (i < idsToNotify.length) {
                        String userIdToNotify = idsToNotify[i];
                        if (this.isNotificationEnabled(userIdToNotify)) {
                            String username2Notify = "";
                            try {
                                username2Notify = um.getUserByUsername(userIdToNotify).getUsername();
                            }
                            catch (Exception e) {
                                status = Response.Status.NOT_ACCEPTABLE;
                                logger.error("Username not found", (Throwable)e);
                                responseBean.setSuccess(false);
                                responseBean.setMessage("Username not found, received: " + userIdToNotify);
                                return Response.status((Response.Status)status).entity((Object)responseBean).build();
                            }
                            deliveryResult = this.notifyWorkspaceEvent(event, (NotificationsManager)nm, username2Notify);
                        } else {
                            Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                        }
                        ++i;
                    }
                    break block17;
                }
                int i = 0;
                while (i < idsToNotify.length) {
                    String contextId = idsToNotify[i];
                    try {
                        ScopeBean scope = new ScopeBean(contextId);
                        if (scope.type() != ScopeBean.Type.VRE) {
                            logger.error("Context not a VRE");
                            status = Response.Status.BAD_REQUEST;
                            responseBean.setSuccess(false);
                            responseBean.setMessage("Not a VRE Context, only VREs are supported");
                            return Response.status((Response.Status)status).entity((Object)responseBean).build();
                        }
                        String[] userIdsToNotify = this.getUsernamesByContext(scope).toArray(new String[0]);
                        int j = 0;
                        while (j < userIdsToNotify.length) {
                            String userIdToNotify = userIdsToNotify[j];
                            if (this.isNotificationEnabled(userIdToNotify)) {
                                deliveryResult = this.notifyWorkspaceEvent(event, (NotificationsManager)nm, userIdToNotify);
                            } else {
                                Log.info((String)("Notification disabled (admin) for user " + userIdToNotify + " will not notify"));
                            }
                            ++j;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        status = Response.Status.BAD_REQUEST;
                        logger.error("Context not valid", (Throwable)e);
                        responseBean.setSuccess(false);
                        responseBean.setMessage("Context not valid, must start with / " + e.getMessage());
                        return Response.status((Response.Status)status).entity((Object)responseBean).build();
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error("Unable to send job notification", (Throwable)e);
                responseBean.setSuccess(false);
                responseBean.setMessage(e.getMessage());
                status = Response.Status.INTERNAL_SERVER_ERROR;
            }
        }
        logger.debug("workspace notifications should have been sent");
        if (deliveryResult) {
            responseBean.setSuccess(true);
            responseBean.setMessage("Workspace notification delivered correctly");
            responseBean.setResult((Object)new Boolean(true));
        } else {
            responseBean.setSuccess(false);
            responseBean.setMessage("An error occurred between this service and Cassandra DB, notification not delivered correctly");
            responseBean.setResult((Object)new Boolean(false));
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    /*
     * Exception decompiling
     */
    private boolean notifyWorkspaceEvent(WorkspaceEvent event, NotificationsManager nm, String idToNotify) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getUsernamesByContext(ScopeBean context) throws Exception {
        ArrayList<String> usernames = new ArrayList<String>();
        GroupManager groupManager = GroupManagerWSBuilder.getInstance().getGroupManager();
        UserManager userManager = UserManagerWSBuilder.getInstance().getUserManager();
        long groupId = groupManager.getGroupIdFromInfrastructureScope(context.toString());
        List userIds = userManager.getUserIdsByGroup(groupId);
        UsersCache cache = UsersCache.getSingleton();
        for (Long userId : userIds) {
            if (cache.getUser(userId.longValue()) == null) {
                GCubeUser theUser = userManager.getUserById(userId.longValue());
                if (theUser == null) continue;
                usernames.add(theUser.getUsername());
                cache.pushEntry(userId.longValue(), theUser);
                continue;
            }
            usernames.add(cache.getUser(userId.longValue()).getUsername());
        }
        return usernames;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$social_networking$socialnetworking$model$beans$workspace$WorkspaceEventType() {
        if ($SWITCH_TABLE$org$gcube$social_networking$socialnetworking$model$beans$workspace$WorkspaceEventType != null) {
            return $SWITCH_TABLE$org$gcube$social_networking$socialnetworking$model$beans$workspace$WorkspaceEventType;
        }
        int[] nArray = new int[WorkspaceEventType.values().length];
        try {
            nArray[WorkspaceEventType.FOLDER_ADDEDUSER.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.FOLDER_ADMIN_DOWNGRADE.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.FOLDER_ADMIN_UPGRADE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.FOLDER_REMOVEDUSER.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.FOLDER_RENAME.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.FOLDER_SHARE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.FOLDER_UNSHARE.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.ITEM_DELETE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.ITEM_NEW.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WorkspaceEventType.ITEM_UPDATE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$social_networking$socialnetworking$model$beans$workspace$WorkspaceEventType = nArray;
        return nArray;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Notifications.java", Notifications.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isUserDisabled", "org.gcube.portal.social.networking.ws.methods.v2.Notifications", "java.lang.String", "username", "javax.validation.ValidationException", "javax.ws.rs.core.Response"), 172);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUserNotifications", "org.gcube.portal.social.networking.ws.methods.v2.Notifications", "org.gcube.portal.social.networking.ws.inputs.UserSetNotificationBean", "setting", "javax.validation.ValidationException", "javax.ws.rs.core.Response"), 207);
    }
}

