/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.inputs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.gcube.portal.social.networking.ws.inputs.Recipient;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageInputBean
implements Serializable {
    private static final long serialVersionUID = -1317811686036127456L;
    @JsonProperty(value="body")
    @NotNull(message="body cannot be missing")
    @Size(min=1, message="body cannot be empty")
    private String body;
    @JsonProperty(value="subject")
    @NotNull(message="subject cannot be missing")
    @Size(min=1, message="subject cannot be empty")
    private String subject;
    @JsonProperty(value="recipients")
    @NotNull(message="recipients cannot be missing")
    @Size(min=1, message="at least a recipient is needed")
    @Valid
    private ArrayList<Recipient> recipients;

    public MessageInputBean() {
    }

    public MessageInputBean(String sender, String body, String subject, ArrayList<Recipient> recipients) {
        this.body = body;
        this.subject = subject;
        this.recipients = recipients;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public ArrayList<Recipient> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(ArrayList<Recipient> recipients) {
        this.recipients = recipients;
    }

    public String toString() {
        return "MessageInputBean [" + (this.body != null ? "body=" + this.body + ", " : "") + (this.subject != null ? "subject=" + this.subject + ", " : "") + (this.recipients != null ? "recipients=" + this.recipients : "") + "]";
    }
}

