/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.databook.shared.ApplicationProfile;
import org.gcube.portal.social.networking.ws.inputs.ApplicationId;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.SocialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/tokens")
@Deprecated
public class Tokens {
    private static final Logger logger = LoggerFactory.getLogger(Tokens.class);

    @POST
    @Path(value="generate-application-token/")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Successful creation of the token, reported in the 'result' field of the returned object"), @ResponseCode(code=403, condition="There is no application profile with such id"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response generateApplicationToken(@NotNull(message="Missing input parameter") @Valid ApplicationId input) throws ValidationException {
        logger.debug("Incoming request for app token generation.");
        String context = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        String appId = input.getAppId();
        try {
            ApplicationProfile appProfile = SocialUtils.getProfileFromInfrastrucure((String)appId, (String)context);
            if (appProfile == null) {
                logger.error("The given id doesn't belong to an application!!!");
                responseBean.setSuccess(false);
                responseBean.setMessage("Invalid application id: it doesn't belong to an application.");
                status = Response.Status.FORBIDDEN;
                return Response.status((Response.Status)status).entity((Object)responseBean).build();
            }
            logger.info("Generating token for the application with id " + appId);
            String appToken = Constants.authorizationService().generateExternalServiceToken(appId);
            responseBean.setSuccess(true);
            responseBean.setResult((Object)appToken);
        }
        catch (Exception e) {
            logger.error("Unable to generate token for app " + appId + " and scope " + context);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseBean.setSuccess(false);
            responseBean.setMessage("Token generation failed.");
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

