/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.social.networking.ws.methods.v2;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.MessageManagerClient;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portal.social.networking.caches.SocialNetworkingSiteFinder;
import org.gcube.portal.social.networking.liferay.ws.LiferayJSONWsCredentials;
import org.gcube.portal.social.networking.liferay.ws.UserManagerWSBuilder;
import org.gcube.portal.social.networking.ws.inputs.MessageInputBean;
import org.gcube.portal.social.networking.ws.inputs.Recipient;
import org.gcube.portal.social.networking.ws.outputs.ResponseBean;
import org.gcube.portal.social.networking.ws.utils.TokensUtils;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="2/messages")
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
public class Messages {
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);

    @POST
    @Path(value="write-message/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful write a message. Its id is reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response writeMessage(@NotNull(message="Message to send is missing") @Valid MessageInputBean input, @Context HttpServletRequest httpServletRequest) throws ValidationException, UserManagementSystemException, UserRetrievalFault {
        logger.debug("Incoming message bean is " + input);
        Caller caller = AuthorizationProvider.instance.get();
        String senderId = null;
        if (!TokensUtils.isUserToken((Caller)caller)) {
            GCubeUser jarvis = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(LiferayJSONWsCredentials.getSingleton().getUser());
            SecurityTokenProvider.instance.set(LiferayJSONWsCredentials.getSingleton().getNotifierUserToken());
            senderId = jarvis.getUsername();
        } else {
            senderId = caller.getClient().getId();
        }
        String scope = ScopeProvider.instance.get();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.CREATED;
        String body = input.getBody();
        String subject = input.getSubject();
        ArrayList recipientsIds = input.getRecipients();
        logger.info("Sender is going to be the token's owner [" + senderId + "]");
        ArrayList<String> recipientsListFiltered = new ArrayList<String>();
        ArrayList<GenericItemBean> recipientsBeans = new ArrayList<GenericItemBean>();
        for (Recipient recipientId : recipientsIds) {
            try {
                String tempId = recipientId.getId().trim();
                if (tempId.isEmpty()) continue;
                GCubeUser userRecipient = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(tempId);
                if (userRecipient == null) {
                    userRecipient = UserManagerWSBuilder.getInstance().getUserManager().getUserByEmail(tempId);
                }
                if (userRecipient == null) continue;
                GenericItemBean beanUser = new GenericItemBean(userRecipient.getUsername(), userRecipient.getUsername(), userRecipient.getFullname(), userRecipient.getUserAvatarURL());
                recipientsBeans.add(beanUser);
                recipientsListFiltered.add(userRecipient.getUsername());
            }
            catch (Exception e) {
                logger.error("Unable to retrieve recipient information for recipient with id " + recipientId, (Throwable)e);
            }
        }
        if (recipientsListFiltered.isEmpty()) {
            logger.error("Missing/wrong request parameters");
            status = Response.Status.BAD_REQUEST;
            responseBean.setMessage("Missing request parameters.");
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
        try {
            logger.debug("Trying to send message with body " + body + " subject " + subject + " to users " + recipientsIds + " from " + senderId);
            GCubeUser senderUser = UserManagerWSBuilder.getInstance().getUserManager().getUserByUsername(senderId);
            MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
            logger.debug("Sending message to " + recipientsListFiltered);
            String messageId = client.sendMessage(recipientsListFiltered, subject, body, null);
            logger.debug("Message sent to " + recipientsIds + ". Sending message notification to: " + recipientsIds);
            SocialNetworkingSite site = SocialNetworkingSiteFinder.getSocialNetworkingSiteFromScope((String)scope);
            SocialNetworkingUser user = new SocialNetworkingUser(senderUser.getUsername(), senderUser.getEmail(), senderUser.getFullname(), senderUser.getUserAvatarURL());
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(UserManagerWSBuilder.getInstance().getUserManager(), site, ScopeProvider.instance.get(), user);
            new Thread((Runnable)new MessageNotificationsThread(recipientsBeans, messageId, subject, body, (NotificationsManager)nm)).start();
            responseBean.setSuccess(true);
            responseBean.setResult((Object)messageId);
        }
        catch (Exception e) {
            logger.error("Unable to send message.", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            responseBean.setMessage(e.toString());
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-sent-messages")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful read of the sent messages, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getSentMessages() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("Request for retrieving sent messages by " + username);
        try {
            MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
            List sentMessages = client.getSentMessages();
            Collections.reverse(sentMessages);
            responseBean.setSuccess(true);
            logger.debug("Result is " + sentMessages);
            responseBean.setResult((Object)sentMessages);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve sent messages", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-received-messages")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful read of the received messages, reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getReceivedMessages() {
        Caller caller = AuthorizationProvider.instance.get();
        String username = caller.getClient().getId();
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        logger.info("Request for retrieving received messages by " + username);
        try {
            MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
            List getMessages = client.getReceivedMessages();
            Collections.reverse(getMessages);
            responseBean.setSuccess(true);
            responseBean.setResult((Object)getMessages);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve sent messages", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

